/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan;

import com.zarkonnen.longan.data.Letter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class Util {
    static BufferedImage cropMaskAndAdjust(BufferedImage src, Letter r, int intensityAdjustment) {
        BufferedImage maskedSrc = new BufferedImage(r.width, r.height, 1);
        Graphics g = maskedSrc.getGraphics();
        g.drawImage(src, 0, 0, r.width, r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
        int white = Color.WHITE.getRGB();
        for (int y = 0; y < r.height; ++y) {
            for (int x = 0; x < r.width; ++x) {
                boolean hasMask = false;
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dx = -1; dx < 2; ++dx) {
                        int ny = y + dy;
                        int nx = x + dx;
                        if (ny < 0 || ny >= r.height || nx < 0 || nx >= r.width) continue;
                        hasMask |= r.mask[ny][nx];
                    }
                }
                if (!hasMask) {
                    maskedSrc.setRGB(x, y, white);
                    continue;
                }
                Color rgb = new Color(maskedSrc.getRGB(x, y));
                rgb = new Color(Math.min(255, Math.max(0, rgb.getRed() + intensityAdjustment)), Math.min(255, Math.max(0, rgb.getGreen() + intensityAdjustment)), Math.min(255, Math.max(0, rgb.getBlue() + intensityAdjustment)));
                maskedSrc.setRGB(x, y, rgb.getRGB());
            }
        }
        return maskedSrc;
    }
}

