/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan;

import com.zarkonnen.longan.data.Column;
import com.zarkonnen.longan.data.Letter;
import com.zarkonnen.longan.data.Line;
import com.zarkonnen.longan.data.Result;
import com.zarkonnen.longan.data.Word;
import com.zarkonnen.longan.stage.ResultConverter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class Visualizer
implements ResultConverter<BufferedImage> {
    @Override
    public BufferedImage convert(Result result) {
        Graphics2D g = result.img.createGraphics();
        float thickness = (float)(result.img.getWidth() < result.img.getHeight() ? result.img.getWidth() : result.img.getHeight()) / 500.0f;
        if (thickness < 1.0f) {
            thickness = 1.0f;
        }
        g.setStroke(new BasicStroke(thickness));
        g.setColor(new Color(0, 0, 0, 63));
        for (Column c : result.columns) {
            c.regenBoundingRect();
            g.drawRect(c.boundingRect.x, c.boundingRect.y, c.boundingRect.width, c.boundingRect.height);
        }
        g.setColor(new Color(255, 0, 0, 191));
        for (Column c : result.columns) {
            for (Line l : c.lines) {
                for (Word word : l.words) {
                    for (Letter letter : word.letters) {
                        g.drawRect(letter.x, letter.y, letter.width, letter.height);
                    }
                }
            }
        }
        g.setColor(new Color(0, 127, 0, 191));
        for (Column c : result.columns) {
            for (Line line : c.lines) {
                Letter prevLetter = null;
                for (Word word : line.words) {
                    for (Letter letter : word.letters) {
                        if (prevLetter != null) {
                            g.drawLine(prevLetter.x + prevLetter.width / 2, prevLetter.y + prevLetter.height / 2, letter.x + letter.width / 2, letter.y + letter.height / 2);
                        }
                        prevLetter = letter;
                    }
                }
            }
        }
        g.setColor(new Color(0, 0, 255, 191));
        for (Column c : result.columns) {
            for (Line line : c.lines) {
                for (Word word : line.words) {
                    Rectangle wr = word.boundingRect;
                    if (wr == null) continue;
                    g.drawRect(wr.x - (int)thickness * 2, wr.y - (int)thickness * 2, wr.width + (int)thickness * 4, wr.height + (int)thickness * 4);
                }
            }
        }
        g.setColor(new Color(100, 0, 200, 191));
        g.setFont(new Font("Verdana", 0, 16));
        for (Column c : result.columns) {
            for (Line l : c.lines) {
                for (Word word : l.words) {
                    for (Letter letter : word.letters) {
                        g.drawString(letter.bestLetter(), letter.x + letter.width / 2, letter.y + letter.height / 2);
                    }
                }
            }
        }
        g.dispose();
        return result.img;
    }

    @Override
    public void write(BufferedImage output, OutputStream stream) throws IOException {
        ImageIO.write((RenderedImage)output, "png", stream);
    }
}

