/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.better;

import com.zarkonnen.longan.Longan;
import com.zarkonnen.longan.better.LetterXComparator;
import com.zarkonnen.longan.data.Column;
import com.zarkonnen.longan.data.Letter;
import com.zarkonnen.longan.data.Line;
import com.zarkonnen.longan.data.Result;
import com.zarkonnen.longan.data.Word;
import com.zarkonnen.longan.stage.PostProcessor;
import java.util.ArrayList;
import java.util.Collections;

public class LetterSplittingPostProcessor
implements PostProcessor {
    static final double LOW_SCORE_BOUNDARY = 0.8;
    static final double MIN_IMPROVEMENT = 0.1;
    static final double ALWAYS_ACCEPT_BOUNDARY = 0.95;

    @Override
    public void process(Result result, Longan longan) {
        for (Column c : result.columns) {
            for (Line line : c.lines) {
                for (Word word : line.words) {
                    block3: for (int i = 0; i < word.letters.size(); ++i) {
                        Letter l = word.letters.get(i);
                        double bestScore = l.bestScore();
                        if (!(bestScore < 0.8) || l.components.size() <= 1) continue;
                        Collections.sort(l.components, new LetterXComparator());
                        ArrayList<Letter> ls = new ArrayList<Letter>();
                        for (Letter lr : l.components) {
                            if (lr.fragment) continue;
                            longan.letterIdentifier.reIdentify(lr, l, word, line, c, result);
                            if (lr.bestScore() < Math.min(0.95, bestScore + 0.1) || lr.bestLetter().equals(l.bestLetter())) continue block3;
                            ls.add(lr);
                        }
                        word.letters.remove(i);
                        word.letters.addAll(i, ls);
                        word.regenBoundingRect();
                        i += ls.size() - 1;
                    }
                }
            }
        }
    }
}

