/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.data;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Letter
extends Rectangle {
    public final HashMap<ArrayList<String>, Double> possibleLetters = new HashMap();
    public double relativeLineOffset = 0.0;
    public double relativeSize = 1.0;
    public boolean[][] mask;
    public boolean fragment;
    public ArrayList<Letter> components = new ArrayList();

    public Letter(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void setScores(HashMap<ArrayList<String>, Double> sc) {
        this.possibleLetters.clear();
        this.possibleLetters.putAll(sc);
    }

    public Letter add(Letter lr2) {
        Rectangle newR = new Rectangle(this);
        newR.add(lr2);
        boolean[][] newMask = new boolean[newR.height][newR.width];
        for (int my = 0; my < newR.height; ++my) {
            for (int mx = 0; mx < newR.width; ++mx) {
                int thisY = newR.y + my - this.y;
                int thisX = newR.x + mx - this.x;
                if (thisY >= 0 && thisY < this.height && thisX >= 0 && thisX < this.width) {
                    boolean[] blArray = newMask[my];
                    int n = mx;
                    blArray[n] = blArray[n] | this.mask[thisY][thisX];
                }
                int lr2Y = newR.y + my - lr2.y;
                int lr2X = newR.x + mx - lr2.x;
                if (lr2Y < 0 || lr2Y >= lr2.height || lr2X < 0 || lr2X >= lr2.width) continue;
                try {
                    boolean[] blArray = newMask[my];
                    int n = mx;
                    blArray[n] = blArray[n] | lr2.mask[lr2Y][lr2X];
                    continue;
                }
                catch (Exception e) {
                    System.out.println("JAM");
                }
            }
        }
        Letter newLR = new Letter(newR.x, newR.y, newR.width, newR.height);
        newLR.mask = newMask;
        if (this.components.isEmpty()) {
            newLR.components.add(this);
        } else {
            newLR.components.addAll(this.components);
        }
        if (lr2.components.isEmpty()) {
            newLR.components.add(lr2);
        } else {
            newLR.components.addAll(this.components);
        }
        newLR.relativeSize = Math.sqrt(this.relativeSize * this.relativeSize + lr2.relativeSize * lr2.relativeSize);
        newLR.relativeLineOffset = (this.relativeLineOffset + lr2.relativeLineOffset) / 2.0;
        return newLR;
    }

    public ArrayList<Letter> splitAlongXAxis(int xSplit, int splitW) {
        ArrayList<Letter> lrs = new ArrayList<Letter>();
        boolean[][] newMask = new boolean[this.height][xSplit];
        for (int my = 0; my < this.height; ++my) {
            System.arraycopy(this.mask[my], 0, newMask[my], 0, xSplit);
        }
        Letter left = new Letter(this.x, this.y, xSplit, this.height);
        left.mask = newMask;
        left.relativeLineOffset = this.relativeLineOffset;
        left.relativeSize = Math.sqrt(this.relativeSize * (double)xSplit / (double)this.width);
        left.fragment = this.fragment;
        left.cropVertically();
        lrs.add(left);
        newMask = new boolean[this.height][this.width - xSplit - splitW];
        for (int my = 0; my < this.height; ++my) {
            System.arraycopy(this.mask[my], xSplit + splitW, newMask[my], 0, this.width - xSplit - splitW);
        }
        Letter right = new Letter(this.x + xSplit + splitW, this.y, this.width - xSplit - splitW, this.height);
        right.mask = newMask;
        right.relativeLineOffset = this.relativeLineOffset;
        right.relativeSize = Math.sqrt(this.relativeSize * (double)(this.width - xSplit - splitW) / (double)this.width);
        right.fragment = this.fragment;
        right.cropVertically();
        lrs.add(right);
        return lrs;
    }

    void cropVertically() {
        int bottomCrop;
        int topCrop;
        int oldWidth = this.width;
        int oldHeight = this.height;
        block0: for (topCrop = 0; topCrop < this.height; ++topCrop) {
            for (int mx = 0; mx < this.width; ++mx) {
                if (this.mask[topCrop][mx]) break block0;
            }
        }
        block2: for (bottomCrop = 0; bottomCrop < this.height - topCrop; ++bottomCrop) {
            for (int mx = 0; mx < this.width; ++mx) {
                if (this.mask[this.height - bottomCrop - 1][mx]) break block2;
            }
        }
        if (topCrop != 0 || bottomCrop != 0) {
            boolean[][] newMask = new boolean[this.height - topCrop - bottomCrop][this.width];
            System.arraycopy(this.mask, topCrop, newMask, 0, this.height - topCrop - bottomCrop);
            this.mask = newMask;
            this.y += topCrop;
            this.height -= topCrop + bottomCrop;
            this.relativeLineOffset = 0.0;
            this.relativeSize = this.relativeSize * Math.sqrt(this.width * this.height) / Math.sqrt(oldWidth * oldHeight);
        }
    }

    public ArrayList<String> bestLetterClass() {
        ArrayList<String> bestL = null;
        double bestP = -1.0E8;
        for (Map.Entry<ArrayList<String>, Double> entry : this.possibleLetters.entrySet()) {
            if (!(entry.getValue() > bestP)) continue;
            bestL = entry.getKey();
            bestP = entry.getValue();
        }
        return bestL;
    }

    public String bestLetter() {
        return this.bestLetterClass().get(0);
    }

    public double bestScore() {
        double bestScore = 0.0;
        for (double score : this.possibleLetters.values()) {
            if (!(score > bestScore)) continue;
            bestScore = score;
        }
        return bestScore;
    }
}

