/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.nnidentifier;

import com.zarkonnen.longan.nnidentifier.FastLoadingNetwork;
import com.zarkonnen.longan.nnidentifier.NearestNeighbour;
import com.zarkonnen.longan.nnidentifier.TreePredict;
import com.zarkonnen.longan.nnidentifier.network.Network;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Config {
    public ArrayList<Identifier> identifiers = new ArrayList();

    public Config() {
    }

    public Config(JSONObject json) throws IOException {
        try {
            if (!json.optString("version", "1.0").equals("1.0")) {
                throw new IOException("Unknown config file version.");
            }
            JSONArray contentsA = json.getJSONArray("contents");
            for (int i = 0; i < contentsA.length(); ++i) {
                JSONObject item = contentsA.getJSONObject(i);
                if (item.get("type").equals("nnIdentifier")) {
                    this.identifiers.add(new NNIdentifier(item));
                }
                if (item.get("type").equals("numberOfPartsIdentifier")) {
                    this.identifiers.add(new NumberOfPartsIdentifier(item));
                }
                if (item.get("type").equals("nearestNeighbourIdentifier")) {
                    this.identifiers.add(new NearestNeighbourIdentifier(item));
                }
                if (!item.get("type").equals("treeIdentifier")) continue;
                this.identifiers.add(new TreeIdentifier(item));
            }
        }
        catch (JSONException je) {
            throw new IOException("Could not parse config file.", je);
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("version", (Object)"1.0");
        json.put("type", (Object)"config");
        JSONArray contentsA = new JSONArray();
        json.put("contents", (Object)contentsA);
        for (Identifier i : this.identifiers) {
            contentsA.put((Object)i.toJSON());
        }
        return json;
    }

    public static class LetterClass {
        public ArrayList<String> members = new ArrayList();

        public boolean equals(Object o) {
            return o instanceof LetterClass && ((LetterClass)o).members.equals(this.members);
        }

        public int hashCode() {
            return 19 + this.members.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String l : this.members) {
                sb.append(l);
            }
            return sb.toString();
        }

        public boolean contains(LetterClass lc2) {
            return this.members.containsAll(lc2.members);
        }
    }

    public static abstract class Identifier {
        static String DEFAULT_SAMPLE_SENTENCE = "The quick brown fox jumped over the lazy dog.";
        public ArrayList<FontType> fonts;
        public ArrayList<LetterClass> classes = new ArrayList();
        public ArrayList<String> allLetters = new ArrayList();
        public boolean root = false;
        public HashMap<String, Double> expectedRelativeSizes;
        public HashMap<String, Double> expectedAspectRatios;
        public String sampleSentence = DEFAULT_SAMPLE_SENTENCE;
        public long seed = System.currentTimeMillis();

        public String toString() {
            return "Identifier for " + Arrays.toString(this.fonts.toArray()) + " and " + Arrays.toString(this.classes.toArray());
        }

        public Identifier(JSONObject json) throws JSONException {
            if (!json.optString("version", "1.0").equals("1.0")) {
                throw new JSONException("Unknown config file version.");
            }
            this.seed = json.optLong("seed", this.seed);
            this.root = json.optBoolean("root", false);
            this.sampleSentence = json.optString("sampleSentence", DEFAULT_SAMPLE_SENTENCE);
            this.fonts = new ArrayList();
            JSONArray fontsA = json.getJSONArray("fonts");
            for (int i = 0; i < fontsA.length(); ++i) {
                this.fonts.add(new FontType(fontsA.getJSONObject(i).getString("font"), fontsA.getJSONObject(i).optBoolean("italic", false)));
            }
            JSONArray classesA = json.getJSONArray("classes");
            for (int i = 0; i < classesA.length(); ++i) {
                LetterClass lc = new LetterClass();
                this.classes.add(lc);
                String letters = classesA.getString(i);
                for (int j = 0; j < letters.length(); ++j) {
                    lc.members.add(letters.substring(j, j + 1));
                }
                this.allLetters.addAll(lc.members);
            }
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject json = new JSONObject();
            json.put("version", (Object)"1.0");
            json.put("root", this.root);
            json.put("seed", this.seed);
            json.put("sampleSentence", (Object)this.sampleSentence);
            JSONArray fontsA = new JSONArray();
            json.put("fonts", (Object)fontsA);
            for (FontType f : this.fonts) {
                JSONObject fO = new JSONObject();
                fO.put("font", (Object)f.font);
                fO.put("italic", f.italic);
                fontsA.put((Object)fO);
            }
            JSONArray classesA = new JSONArray();
            json.put("classes", (Object)classesA);
            for (LetterClass lc : this.classes) {
                StringBuilder sb = new StringBuilder();
                for (String s : lc.members) {
                    sb.append(s);
                }
                classesA.put((Object)sb.toString());
            }
            return json;
        }
    }

    public static class NumberOfPartsIdentifier
    extends Identifier {
        int numberOfPartsBoundary;
        boolean firstIsAboveBoundary;
        boolean enabled = false;

        public NumberOfPartsIdentifier(JSONObject json) throws JSONException {
            super(json);
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject json = super.toJSON();
            json.put("type", (Object)"numberOfPartsIdentifier");
            return json;
        }

        @Override
        public String toString() {
            return "Number of Parts " + super.toString();
        }
    }

    public static class NearestNeighbourIdentifier
    extends Identifier {
        public NearestNeighbour.Comparisons comparisons;

        public NearestNeighbourIdentifier(JSONObject json) throws JSONException {
            super(json);
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject json = super.toJSON();
            json.put("type", (Object)"nearestNeighbourIdentifier");
            return json;
        }

        @Override
        public String toString() {
            return "Nearest Neighbour " + super.toString();
        }
    }

    public static class TreeIdentifier
    extends Identifier {
        public TreePredict.TreeNode<LetterClass> tree;

        public TreeIdentifier(JSONObject json) throws JSONException {
            super(json);
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject json = super.toJSON();
            json.put("type", (Object)"treeIdentifier");
            return json;
        }

        @Override
        public String toString() {
            return "Tree " + super.toString();
        }
    }

    public static class NNIdentifier
    extends Identifier {
        public ArrayList<Network> networks = new ArrayList();
        public ArrayList<FastLoadingNetwork> fastNetworks = new ArrayList();
        public ArrayList<HashMap<LetterClass, ArrayList<float[]>>> targets = new ArrayList();
        public int numberOfNetworks;
        public boolean proportionalInput = true;

        public NNIdentifier(JSONObject json) throws JSONException {
            super(json);
            this.numberOfNetworks = json.optInt("numberOfNetworks", 1);
            this.proportionalInput = json.optBoolean("proportionalInput", true);
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject json = super.toJSON();
            json.put("type", (Object)"nnIdentifier");
            json.put("numberOfNetworks", this.numberOfNetworks);
            json.put("proportionalInput", this.proportionalInput);
            return json;
        }

        @Override
        public String toString() {
            return "Neural Network " + super.toString();
        }
    }

    public static final class FontType {
        public final String font;
        public final boolean italic;

        public FontType(String font, boolean italic) {
            this.font = font;
            this.italic = italic;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FontType)) {
                return false;
            }
            FontType ft2 = (FontType)o;
            return ft2.italic == this.italic && ft2.font.equals(this.font);
        }

        public int hashCode() {
            return (this.italic ? 7 : 77) + this.font.hashCode();
        }

        public String toString() {
            return this.font + (this.italic ? " Italic" : "");
        }
    }
}

