/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.nnidentifier;

import com.zarkonnen.longan.nnidentifier.network.Layer;
import com.zarkonnen.longan.nnidentifier.network.Network;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class FastLoadingNetwork {
    public ArrayList<FastLayer> layers = new ArrayList();
    public int inputSize;

    public FastLoadingNetwork initFromNetwork(Network n) {
        this.inputSize = n.layers.get((int)0).nodes.size();
        for (int i = 1; i < n.layers.size(); ++i) {
            this.layers.add(new FastLayer(n.layers.get(i), n.layers.get(i - 1)));
        }
        return this;
    }

    public FastLoadingNetwork loadShape(InputStream in) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(in);
        this.inputSize = ois.readInt();
        int numLayers = ois.readInt();
        for (int layerN = 0; layerN < numLayers; ++layerN) {
            int i;
            FastLayer l = new FastLayer();
            this.layers.add(l);
            l.numNodes = ois.readInt();
            l.numWeights = ois.readInt();
            l.totalNumConnections = ois.readInt();
            l.hasBias = ois.readBoolean();
            l.connectionOffsets = new int[l.numNodes];
            l.numConnections = new int[l.numNodes];
            l.connections = new int[l.totalNumConnections];
            l.weightConnections = new int[l.totalNumConnections];
            l.weights = new float[l.numWeights];
            l.biases = new float[l.numNodes];
            l.output = new float[l.numNodes];
            for (i = 0; i < l.connectionOffsets.length; ++i) {
                l.connectionOffsets[i] = ois.readInt();
            }
            for (i = 0; i < l.numConnections.length; ++i) {
                l.numConnections[i] = ois.readInt();
            }
            for (i = 0; i < l.connections.length; ++i) {
                l.connections[i] = ois.readInt();
            }
            for (i = 0; i < l.weightConnections.length; ++i) {
                l.weightConnections[i] = ois.readInt();
            }
        }
        return this;
    }

    public void saveShape(OutputStream out) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeInt(this.inputSize);
        oos.writeInt(this.layers.size());
        for (FastLayer l : this.layers) {
            int i;
            oos.writeInt(l.numNodes);
            oos.writeInt(l.numWeights);
            oos.writeInt(l.totalNumConnections);
            oos.writeBoolean(l.hasBias);
            for (i = 0; i < l.connectionOffsets.length; ++i) {
                oos.writeInt(l.connectionOffsets[i]);
            }
            for (i = 0; i < l.numConnections.length; ++i) {
                oos.writeInt(l.numConnections[i]);
            }
            for (i = 0; i < l.connections.length; ++i) {
                oos.writeInt(l.connections[i]);
            }
            for (i = 0; i < l.weightConnections.length; ++i) {
                oos.writeInt(l.weightConnections[i]);
            }
        }
        oos.flush();
    }

    public FastLoadingNetwork loadWeights(InputStream in) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(in);
        for (FastLayer l : this.layers) {
            int i;
            for (i = 0; i < l.weights.length; ++i) {
                l.weights[i] = ois.readFloat();
            }
            for (i = 0; i < l.biases.length; ++i) {
                l.biases[i] = ois.readFloat();
            }
        }
        return this;
    }

    public void saveWeights(OutputStream out) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        for (FastLayer l : this.layers) {
            int i;
            for (i = 0; i < l.weights.length; ++i) {
                oos.writeFloat(l.weights[i]);
            }
            for (i = 0; i < l.biases.length; ++i) {
                oos.writeFloat(l.biases[i]);
            }
        }
        oos.flush();
    }

    public FastLoadingNetwork cloneWithSameShape() {
        FastLoadingNetwork n2 = new FastLoadingNetwork();
        n2.inputSize = this.inputSize;
        for (FastLayer l : this.layers) {
            n2.layers.add(l.cloneWithSameShape());
        }
        return n2;
    }

    public float[] run(float[] input) {
        for (FastLayer l : this.layers) {
            l.run(input);
            input = l.output;
        }
        return input;
    }

    public static boolean hasBias(Layer layer) {
        return layer.nodes.get((int)0).incoming.get((int)(layer.nodes.get((int)0).incoming.size() - 1)).input.name.toLowerCase().contains("bias");
    }

    public static class FastLayer {
        int numNodes;
        int numWeights;
        int totalNumConnections;
        boolean hasBias;
        int[] connectionOffsets;
        int[] numConnections;
        int[] connections;
        int[] weightConnections;
        float[] weights;
        float[] biases;
        float[] output;

        public FastLayer() {
        }

        public FastLayer(Layer layer, Layer prevLayer) {
            int node;
            this.numNodes = layer.nodes.size();
            this.numWeights = prevLayer.weights.size();
            this.hasBias = FastLoadingNetwork.hasBias(layer);
            this.connectionOffsets = new int[this.numNodes];
            this.numConnections = new int[this.numNodes];
            this.totalNumConnections = 0;
            for (node = 0; node < this.numNodes; ++node) {
                this.connectionOffsets[node] = this.totalNumConnections;
                this.numConnections[node] = layer.nodes.get((int)node).incoming.size() - (this.hasBias ? 1 : 0);
                this.totalNumConnections += this.numConnections[node];
            }
            this.connections = new int[this.totalNumConnections];
            this.weightConnections = new int[this.totalNumConnections];
            this.weights = new float[this.numWeights];
            this.biases = new float[this.numNodes];
            for (int w = 0; w < this.numWeights; ++w) {
                this.weights[w] = prevLayer.weights.get((int)w).value;
            }
            for (node = 0; node < this.numNodes; ++node) {
                for (int input = 0; input < this.numConnections[node]; ++input) {
                    this.connections[this.connectionOffsets[node] + input] = prevLayer.nodes.indexOf(layer.nodes.get((int)node).incoming.get((int)input).input);
                    this.weightConnections[this.connectionOffsets[node] + input] = prevLayer.weights.indexOf(layer.nodes.get((int)node).incoming.get((int)input).weight);
                }
                if (!this.hasBias) continue;
                this.biases[node] = layer.nodes.get((int)node).incoming.get((int)this.numConnections[node]).weight.value;
            }
            this.output = new float[this.numNodes];
        }

        public void run(float[] prevLayer) {
            for (int n = 0; n < this.numNodes; ++n) {
                float x = this.biases[n];
                for (int i = 0; i < this.numConnections[n]; ++i) {
                    x += this.weights[this.weightConnections[this.connectionOffsets[n] + i]] * prevLayer[this.connections[this.connectionOffsets[n] + i]];
                }
                this.output[n] = (float)Math.tanh(x);
            }
        }

        public FastLayer cloneWithSameShape() {
            FastLayer l2 = new FastLayer();
            l2.numNodes = this.numNodes;
            l2.numWeights = this.numWeights;
            l2.totalNumConnections = this.totalNumConnections;
            l2.hasBias = this.hasBias;
            l2.connectionOffsets = this.connectionOffsets;
            l2.numConnections = this.numConnections;
            l2.connections = this.connections;
            l2.weightConnections = this.weightConnections;
            l2.weights = new float[this.weights.length];
            l2.biases = new float[this.biases.length];
            l2.output = new float[this.output.length];
            return l2;
        }
    }
}

