/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.nnidentifier;

import com.zarkonnen.longan.Histogram;
import com.zarkonnen.longan.Metadata;
import com.zarkonnen.longan.data.Column;
import com.zarkonnen.longan.data.Letter;
import com.zarkonnen.longan.data.Line;
import com.zarkonnen.longan.data.Result;
import com.zarkonnen.longan.data.Word;
import com.zarkonnen.longan.nnidentifier.Config;
import com.zarkonnen.longan.nnidentifier.NetworkIO;
import com.zarkonnen.longan.nnidentifier.TreePredict;
import com.zarkonnen.longan.nnidentifier.network.Util;
import com.zarkonnen.longan.stage.LetterIdentifier;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Identifier
implements LetterIdentifier {
    private final Config config;
    static final int REFERENCE_INTENSITY_BOUNDARY = 165;
    static final double ALSO_RAN_PROMO = 1.0E-4;
    static final double BEST_ALT_PROMOTION = 0.002;
    public static final Metadata.Key<Config.Identifier> IDENTIFIER_USED = Metadata.key("identifierUsed", Config.Identifier.class);
    public static final Metadata.Key<Integer> AVG_LETTER_SIZE = Metadata.key("avgLetterSize", Integer.class);
    static final double ASPECT_TO_SIZE_DIST_RATIO = 3.0;
    static final double MIN_VOTE_PROPORTION_TO_STAY_IN_RACE = 0.2;
    static final int MEASURE_VOTE_PROPORTION_EVERY = 16;
    static int qq = 0;
    public static final List<Class<? extends Config.Identifier>> PHASES;
    public static final double SUB_BONUS = 1.0E-4;

    public Identifier(Config config) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.config = config;
    }

    public Identifier() {
        try {
            this.config = NetworkIO.readDefaultArchive();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialise default neural network identifier.", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void identify(Result result) {
        int intensityAdjustment = 0;
        if (result.metadata.containsKey("blackWhiteBoundary")) {
            int blackWhiteBoundary = Integer.parseInt(result.metadata.get("blackWhiteBoundary"));
            intensityAdjustment = (165 - blackWhiteBoundary) * 3 / 4;
        }
        HashMap<Config.Identifier, Integer> votes = new HashMap<Config.Identifier, Integer>();
        HashMap<Config.Identifier, HashMap<Letter, HashMap<ArrayList<String>, Double>>> results = new HashMap<Config.Identifier, HashMap<Letter, HashMap<ArrayList<String>, Double>>>();
        HashMap<Letter, float[]> proportionalInputs = new HashMap<Letter, float[]>();
        HashMap<Letter, float[]> squareInputs = new HashMap<Letter, float[]>();
        for (Column col : result.columns) {
            Histogram sizeHistogram = new Histogram(100);
            for (Line line : col.lines) {
                for (Word word : line.words) {
                    for (Letter letter : word.letters) {
                        sizeHistogram.add((int)Math.sqrt(letter.width * letter.height));
                    }
                }
            }
            sizeHistogram.convolve(new double[]{0.02040816326530612, 0.04081632653061224, 0.061224489795918366, 0.08163265306122448, 0.10204081632653061, 0.12244897959183673, 0.14285714285714285, 0.12244897959183673, 0.10204081632653061, 0.08163265306122448, 0.061224489795918366, 0.04081632653061224, 0.02040816326530612});
            int avgLetterSize = sizeHistogram.secondPeakOrFirstIfUnavailable();
            col.metadata.put(AVG_LETTER_SIZE, avgLetterSize);
            votes.clear();
            results.clear();
            proportionalInputs.clear();
            squareInputs.clear();
            for (Config.Identifier identifier : this.config.identifiers) {
                if (!identifier.root) continue;
                votes.put(identifier, 0);
            }
            boolean bl = false;
            int votesGiven = 0;
            for (Line line : col.lines) {
                for (Word word : line.words) {
                    for (Letter letter : word.letters) {
                        void var11_13;
                        this.runRootIdentifiers(letter, result, intensityAdjustment, proportionalInputs, squareInputs, votes, results);
                        int currentVotesGiven = ++votesGiven;
                        if (++var11_13 % 16 != false) continue;
                        Iterator<Map.Entry<Config.Identifier, Integer>> it = votes.entrySet().iterator();
                        while (it.hasNext()) {
                            int eVotes = it.next().getValue();
                            if (!((double)eVotes < 0.2 * (double)currentVotesGiven)) continue;
                            votesGiven -= eVotes;
                            it.remove();
                        }
                    }
                }
            }
            boolean bl2 = false;
            Config.Identifier bestIdentifier = null;
            for (Map.Entry entry : votes.entrySet()) {
                int n;
                if ((Integer)entry.getValue() <= n) continue;
                n = (Integer)entry.getValue();
                bestIdentifier = (Config.Identifier)entry.getKey();
            }
            col.metadata.put(IDENTIFIER_USED, bestIdentifier);
            for (Line line : col.lines) {
                for (Word w : line.words) {
                    for (Letter letter : w.letters) {
                        letter.setScores(results.get(bestIdentifier).get(letter));
                        this.runSubIdentifiers(letter, bestIdentifier, proportionalInputs, squareInputs, result, intensityAdjustment);
                    }
                }
            }
        }
    }

    @Override
    public void reIdentify(Letter l, Letter source, Word word, Line line, Column col, Result result) {
        int intensityAdjustment = 0;
        if (result.metadata.containsKey("blackWhiteBoundary")) {
            int blackWhiteBoundary = Integer.parseInt(result.metadata.get("blackWhiteBoundary"));
            intensityAdjustment = (165 - blackWhiteBoundary) * 3 / 4;
        }
        HashMap<Config.Identifier, HashMap<Letter, HashMap<ArrayList<String>, Double>>> results = new HashMap<Config.Identifier, HashMap<Letter, HashMap<ArrayList<String>, Double>>>();
        HashMap<Config.Identifier, Integer> votes = new HashMap<Config.Identifier, Integer>();
        HashMap<Letter, float[]> proportionalInputs = new HashMap<Letter, float[]>();
        HashMap<Letter, float[]> squareInputs = new HashMap<Letter, float[]>();
        votes.put(col.metadata.get(IDENTIFIER_USED), 0);
        this.runRootIdentifiers(l, result, intensityAdjustment, proportionalInputs, squareInputs, votes, results);
        l.setScores(results.get(col.metadata.get(IDENTIFIER_USED)).get(l));
        this.runSubIdentifiers(l, col.metadata.get(IDENTIFIER_USED), proportionalInputs, squareInputs, result, intensityAdjustment);
    }

    void runRootIdentifiers(Letter letter, Result result, int intensityAdjustment, HashMap<Letter, float[]> proportionalInputs, HashMap<Letter, float[]> squareInputs, HashMap<Config.Identifier, Integer> votes, HashMap<Config.Identifier, HashMap<Letter, HashMap<ArrayList<String>, Double>>> results) {
        float[] proportionalInput = null;
        float[] squareInput = null;
        Config.Identifier identifierVote = null;
        double bestScore = -1000.0;
        for (Config.Identifier identifier : votes.keySet()) {
            if (!results.containsKey(identifier)) {
                results.put(identifier, new HashMap());
            }
            HashMap<ArrayList<String>, Double> scores = new HashMap<ArrayList<String>, Double>();
            results.get(identifier).put(letter, scores);
            if (!(identifier instanceof Config.NNIdentifier)) continue;
            Config.NNIdentifier id = (Config.NNIdentifier)identifier;
            if (id.proportionalInput) {
                if (proportionalInput == null) {
                    proportionalInput = Util.getInputForNN(letter, result.img, intensityAdjustment, true);
                    proportionalInputs.put(letter, proportionalInput);
                }
            } else if (squareInput == null) {
                squareInput = Util.getInputForNN(letter, result.img, intensityAdjustment, true);
                proportionalInputs.put(letter, squareInput);
            }
            for (int i = 0; i < id.numberOfNetworks; ++i) {
                float[] output = id.fastNetworks.get(i).run(id.proportionalInput ? proportionalInput : squareInput);
                for (Config.LetterClass lc : identifier.classes) {
                    for (float[] target : id.targets.get(i).get(lc)) {
                        double score = Identifier.score(output, target);
                        double newScore = i == 0 ? score / (double)id.numberOfNetworks : (Double)scores.get(lc.members) + score / (double)id.numberOfNetworks;
                        scores.put(lc.members, newScore);
                        if (!(newScore > bestScore)) continue;
                        bestScore = newScore;
                        identifierVote = identifier;
                    }
                }
            }
        }
        votes.put(identifierVote, votes.get(identifierVote) + 1);
    }

    /*
     * WARNING - void declaration
     */
    private void runSubIdentifiers(Letter l, Config.Identifier identifierUsed, HashMap<Letter, float[]> proportionalInputs, HashMap<Letter, float[]> squareInputs, Result result, int intensityAdjustment) {
        ArrayList<String> current = l.bestLetterClass();
        ArrayList<String> dismissed = new ArrayList<String>();
        System.out.print(Arrays.toString(current.toArray()));
        double baseScore = l.possibleLetters.get(current);
        l.possibleLetters.remove(current);
        boolean progress = true;
        HashMap<ArrayList<String>, Double> scores = new HashMap<ArrayList<String>, Double>();
        block0: while (progress) {
            scores.clear();
            progress = false;
            for (Class<? extends Config.Identifier> phase : PHASES) {
                for (Config.Identifier identifier : this.config.identifiers) {
                    Object id;
                    if (identifier.root || !identifier.getClass().equals(phase) || !identifier.fonts.equals(identifierUsed.fonts)) continue;
                    int numberOfClassesWithCurrentLetters = 0;
                    int numberOfClassesWithNonDismissedLetters = 0;
                    for (Config.LetterClass lc : identifier.classes) {
                        for (String lcL : lc.members) {
                            if (!current.contains(lcL)) continue;
                            ++numberOfClassesWithCurrentLetters;
                            break;
                        }
                        if (dismissed.containsAll(lc.members)) continue;
                        ++numberOfClassesWithNonDismissedLetters;
                    }
                    if (numberOfClassesWithCurrentLetters == 0 || numberOfClassesWithNonDismissedLetters < 2) continue;
                    ArrayList<String> bestClass = null;
                    double bestScore = 0.0;
                    if (identifier instanceof Config.NNIdentifier) {
                        void var23_34;
                        id = (Config.NNIdentifier)identifier;
                        boolean bl = false;
                        while (var23_34 < ((Config.NNIdentifier)id).numberOfNetworks) {
                            void var24_42;
                            if (((Config.NNIdentifier)id).proportionalInput) {
                                if (!proportionalInputs.containsKey(l)) {
                                    proportionalInputs.put(l, Util.getInputForNN(l, result.img, intensityAdjustment, true));
                                }
                                float[] fArray = proportionalInputs.get(l);
                            } else {
                                if (!squareInputs.containsKey(l)) {
                                    squareInputs.put(l, Util.getInputForNN(l, result.img, intensityAdjustment, false));
                                }
                                float[] fArray = squareInputs.get(l);
                            }
                            float[] output = ((Config.NNIdentifier)id).fastNetworks.get((int)var23_34).run((float[])var24_42);
                            for (Config.LetterClass lc : identifier.classes) {
                                double lcBestScore = -1.0;
                                for (float[] target : ((Config.NNIdentifier)id).targets.get((int)var23_34).get(lc)) {
                                    double score = Identifier.score(output, target);
                                    lcBestScore = Math.max(lcBestScore, score);
                                }
                                double newScore = var23_34 == false ? lcBestScore / (double)((Config.NNIdentifier)id).numberOfNetworks : (Double)scores.get(lc.members) + lcBestScore / (double)((Config.NNIdentifier)id).numberOfNetworks;
                                scores.put(lc.members, newScore);
                                ArrayList<String> cl = new ArrayList<String>(lc.members);
                                cl.removeAll(dismissed);
                                if (cl.isEmpty() || !(newScore > bestScore)) continue;
                                bestClass = cl;
                                bestScore = newScore;
                            }
                            ++var23_34;
                        }
                        if (scores.isEmpty()) {
                            bestClass = null;
                            bestScore = 0.0;
                            continue;
                        }
                        progress = true;
                    }
                    if (identifier instanceof Config.NumberOfPartsIdentifier) {
                        boolean bl;
                        id = (Config.NumberOfPartsIdentifier)identifier;
                        ArrayList<String> arrayList = new ArrayList<String>(identifier.classes.get((int)0).members);
                        arrayList.removeAll(dismissed);
                        if (arrayList.isEmpty()) continue;
                        ArrayList<String> arrayList2 = new ArrayList<String>(identifier.classes.get((int)1).members);
                        arrayList2.removeAll(dismissed);
                        if (arrayList2.isEmpty()) continue;
                        int n = l.components.isEmpty() ? 1 : l.components.size();
                        boolean bl2 = bl = n > ((Config.NumberOfPartsIdentifier)id).numberOfPartsBoundary;
                        if (bl == ((Config.NumberOfPartsIdentifier)id).firstIsAboveBoundary) {
                            bestClass = arrayList;
                            bestScore = 1.0;
                            scores.put(arrayList, 1.0);
                            scores.put(arrayList2, 0.0);
                        } else {
                            bestClass = arrayList2;
                            bestScore = 1.0;
                            scores.put(arrayList, 0.0);
                            scores.put(arrayList2, 1.0);
                        }
                        progress = true;
                    }
                    if (identifier instanceof Config.NearestNeighbourIdentifier) {
                        if (!squareInputs.containsKey(l)) {
                            squareInputs.put(l, Util.getInputForNN(l, result.img, intensityAdjustment, false));
                        }
                        float[] input = squareInputs.get(l);
                        for (Config.LetterClass letterClass : identifier.classes) {
                            ArrayList<String> cl = new ArrayList<String>(letterClass.members);
                            cl.removeAll(dismissed);
                            if (cl.isEmpty()) continue;
                            double d = ((Config.NearestNeighbourIdentifier)identifier).comparisons.leastError(cl, input);
                            double score = 1.0 - d / 1024.0;
                            scores.put(cl, score);
                            if (!(score > bestScore)) continue;
                            bestClass = cl;
                            bestScore = score;
                        }
                        progress = true;
                    }
                    if (identifier instanceof Config.TreeIdentifier) {
                        id = (Config.TreeIdentifier)identifier;
                        Config.LetterClass letterClass = TreePredict.vote(((Config.TreeIdentifier)id).tree.classify(TreePredict.getImg(l, result.img, intensityAdjustment)));
                        bestClass = new ArrayList<String>(letterClass.members);
                        bestScore = 1.0;
                        for (Config.LetterClass lc : ((Config.TreeIdentifier)id).classes) {
                            if (lc == letterClass) {
                                scores.put(new ArrayList<String>(lc.members), 1.0);
                                continue;
                            }
                            scores.put(new ArrayList<String>(lc.members), 0.0);
                        }
                        progress = true;
                    }
                    scores.remove(bestClass);
                    block10: for (Map.Entry entry : scores.entrySet()) {
                        ArrayList arrayList = new ArrayList((Collection)entry.getKey());
                        for (String string : arrayList) {
                            if (dismissed.contains(string)) continue;
                            dismissed.add(string);
                        }
                        for (ArrayList arrayList3 : l.possibleLetters.keySet()) {
                            arrayList.removeAll(arrayList3);
                            if (!arrayList.isEmpty()) continue;
                            continue block10;
                        }
                        l.possibleLetters.put(arrayList, baseScore + (Double)entry.getValue() / bestScore * 1.0E-4);
                    }
                    current = bestClass;
                    baseScore += 1.0E-4;
                    System.out.print(" -> " + Arrays.toString(current.toArray()));
                    if (!progress) continue;
                    continue block0;
                }
            }
        }
        if (current.size() > 1) {
            String best = null;
            double bestDist = Double.MAX_VALUE;
            for (String candidate : current) {
                double dist;
                double arDist;
                double szDist = l.relativeSize / identifierUsed.expectedRelativeSizes.get(candidate);
                if (szDist < 1.0) {
                    szDist = 1.0 / szDist;
                }
                if ((arDist = Math.sqrt((double)l.width * 1.0 / (double)l.height) / identifierUsed.expectedAspectRatios.get(candidate)) < 1.0) {
                    arDist = 1.0 / arDist;
                }
                if (!((dist = szDist + 3.0 * arDist) < bestDist)) continue;
                bestDist = dist;
                best = candidate;
            }
            ArrayList<String> arrayList = new ArrayList<String>(current);
            arrayList.remove(best);
            l.possibleLetters.put(arrayList, baseScore + 1.0E-4);
            current = new ArrayList();
            current.add(best);
            baseScore += 1.0E-4;
            System.out.print(" -> " + Arrays.toString(current.toArray()));
        }
        l.possibleLetters.put(current, baseScore + 1.0E-4);
        System.out.println();
    }

    @Override
    public void discriminateTopLetterClass(Letter l, Letter source, Word word, Line line, Column column, Result result) {
        int intensityAdjustment = 0;
        if (result.metadata.containsKey("blackWhiteBoundary")) {
            int blackWhiteBoundary = Integer.parseInt(result.metadata.get("blackWhiteBoundary"));
            intensityAdjustment = (165 - blackWhiteBoundary) * 3 / 4;
        }
        this.runSubIdentifiers(l, column.metadata.get(IDENTIFIER_USED), new HashMap<Letter, float[]>(), new HashMap<Letter, float[]>(), result, intensityAdjustment);
    }

    @Override
    public void finish() {
    }

    public static float score(float[] output, float[] target) {
        float error = 0.0f;
        for (int i = 0; i < output.length; ++i) {
            error += (output[i] - target[i]) * (output[i] - target[i]);
        }
        return ((float)output.length - error) / (float)output.length;
    }

    static {
        ArrayList<Class> l = new ArrayList<Class>();
        l.add(Config.NumberOfPartsIdentifier.class);
        l.add(Config.NNIdentifier.class);
        l.add(Config.NearestNeighbourIdentifier.class);
        l.add(Config.TreeIdentifier.class);
        PHASES = Collections.unmodifiableList(l);
    }

    static final class LetterClassInIdentifier {
        final Config.LetterClass letterClass;
        final Config.Identifier identifier;

        public LetterClassInIdentifier(Config.LetterClass letterClass, Config.Identifier identifier) {
            this.letterClass = letterClass;
            this.identifier = identifier;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LetterClassInIdentifier)) {
                return false;
            }
            LetterClassInIdentifier lef2 = (LetterClassInIdentifier)o;
            return this.letterClass.equals(lef2.letterClass) && this.identifier.equals(lef2.identifier);
        }

        public int hashCode() {
            return 41 + this.letterClass.hashCode() * 13 + this.identifier.hashCode();
        }
    }
}

