/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.nnidentifier;

import com.zarkonnen.longan.nnidentifier.Config;
import com.zarkonnen.longan.nnidentifier.TreePredict;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;

public class SVM {
    static final int IMG_SZ = 800;
    static final int DIMS = 81;

    static float[] expand(float[] original) {
        float[] expanded = new float[]{original[0], original[1], original[0] * original[0], original[1] * original[1], original[0] * original[1], original[0] * original[0] + original[1] * original[1]};
        return expanded;
    }

    static float realDot(float[] a, float[] b) {
        a = SVM.expand(a);
        b = SVM.expand(b);
        float d = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            d += a[i] * b[i];
        }
        return d;
    }

    static float dotGaussian(float[] a, float[] b) {
        double normSq = 0.0;
        for (int i = 0; i < a.length; ++i) {
            normSq += (double)((a[i] - b[i]) * (a[i] - b[i]));
        }
        return (float)Math.exp(-0.5 * normSq);
    }

    static float dotSigmoid(float[] a, float[] b) {
        return (float)Math.tanh(0.7 * (double)SVM.realDot(a, b) + 0.3);
    }

    static float dot(float[] a, float[] b) {
        return SVM.dotGaussian(a, b);
    }

    static SV findBestSV(ArrayList<Img<Color>> allEls, ArrayList<Img<Color>> testEls) {
        int bestScore = 0;
        float[] bestV = null;
        float bestD = 0.0f;
        Color aTag = null;
        Color bTag = null;
        float bestNormSquare = 0.0f;
        for (Img<Color> a : allEls) {
            for (Img<Color> b : allEls) {
                if (((Color)a.tag).equals(b.tag)) continue;
                float[] vector = new float[a.data.length];
                float[] avg = new float[a.data.length];
                for (int i = 0; i < vector.length; ++i) {
                    vector[i] = a.data[i] - b.data[i];
                    avg[i] = a.data[i] / 2.0f + b.data[i] / 2.0f;
                }
                float d = SVM.dot(vector, avg);
                int score = 0;
                for (Img<Color> e : testEls) {
                    float dist = d - SVM.dot(vector, e.data);
                    Color tag = dist < 0.0f ? (Color)a.tag : (Color)b.tag;
                    if (!tag.equals(e.tag)) continue;
                    ++score;
                }
                float normSquare = 0.0f;
                for (float f : vector) {
                    normSquare += f * f;
                }
                if (score <= bestScore && (score != bestScore || !(normSquare < bestNormSquare))) continue;
                bestScore = score;
                bestV = vector;
                bestD = d;
                aTag = (Color)a.tag;
                bTag = (Color)b.tag;
                bestNormSquare = normSquare;
            }
        }
        return bestV == null ? null : new SV(bestV, bestD, aTag, bTag);
    }

    static SVNode createSVTree(ArrayList<Img<Color>> allEls, ArrayList<Img<Color>> testEls, int maxD, int minImprovement, Color currentTag) {
        if (maxD == 0) {
            return null;
        }
        SVNode node = new SVNode();
        node.sv = SVM.findBestSV(allEls, testEls);
        if (node.sv == null) {
            return null;
        }
        ArrayList<Img<Color>> aList = new ArrayList<Img<Color>>();
        ArrayList<Img<Color>> bList = new ArrayList<Img<Color>>();
        int aError = 0;
        int bError = 0;
        for (Img<Color> e : testEls) {
            if (node.sv.classify(e).equals(node.sv.aTag)) {
                if (!((Color)e.tag).equals(node.sv.aTag)) {
                    ++aError;
                }
                aList.add(e);
                continue;
            }
            if (!((Color)e.tag).equals(node.sv.bTag)) {
                ++bError;
            }
            bList.add(e);
        }
        if (aError > minImprovement) {
            node.aBranch = SVM.createSVTree(allEls, aList, maxD - 1, minImprovement, node.sv.aTag);
        }
        if (bError > minImprovement) {
            node.bBranch = SVM.createSVTree(allEls, bList, maxD - 1, minImprovement, node.sv.bTag);
        }
        return node;
    }

    static float distSq(float[] a, float[] b) {
        float ds = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            ds += (a[i] - b[i]) * (a[i] - b[i]);
        }
        return ds;
    }

    public static float[] fft(float[] inputReal, float[] inputImag, boolean DIRECT) {
        float tImag;
        float tReal;
        int n = inputReal.length;
        double ld = Math.log(n) / Math.log(2.0);
        if ((double)((int)ld) - ld != 0.0) {
            System.out.println("The number of elements is not a power of 2.");
            return null;
        }
        int nu = (int)ld;
        int n2 = n / 2;
        int nu1 = nu - 1;
        float[] xReal = new float[n];
        float[] xImag = new float[n];
        float constant = DIRECT ? (float)Math.PI * -2 : (float)Math.PI * 2;
        for (int i = 0; i < n; ++i) {
            xReal[i] = inputReal[i];
            xImag[i] = inputImag[i];
        }
        int k = 0;
        for (int l = 1; l <= nu; ++l) {
            while (k < n) {
                for (int i = 1; i <= n2; ++i) {
                    float p = SVM.bitreverseReference(k >> nu1, nu);
                    float arg = constant * p / (float)n;
                    float c = (float)Math.cos(arg);
                    float s = (float)Math.sin(arg);
                    tReal = xReal[k + n2] * c + xImag[k + n2] * s;
                    tImag = xImag[k + n2] * c - xReal[k + n2] * s;
                    xReal[k + n2] = xReal[k] - tReal;
                    xImag[k + n2] = xImag[k] - tImag;
                    int n3 = k;
                    xReal[n3] = xReal[n3] + tReal;
                    int n4 = k++;
                    xImag[n4] = xImag[n4] + tImag;
                }
                k += n2;
            }
            k = 0;
            --nu1;
            n2 /= 2;
        }
        for (k = 0; k < n; ++k) {
            int r = SVM.bitreverseReference(k, nu);
            if (r <= k) continue;
            tReal = xReal[k];
            tImag = xImag[k];
            xReal[k] = xReal[r];
            xImag[k] = xImag[r];
            xReal[r] = tReal;
            xImag[r] = tImag;
        }
        float[] newArray = new float[xReal.length * 2];
        float radice = (float)(1.0 / Math.sqrt(n));
        for (int i = 0; i < newArray.length; i += 2) {
            int i2 = i / 2;
            newArray[i] = xReal[i2] * radice;
            newArray[i + 1] = xImag[i2] * radice;
        }
        return newArray;
    }

    private static int bitreverseReference(int j, int nu) {
        int j1 = j;
        int k = 0;
        for (int i = 1; i <= nu; ++i) {
            int j2 = j1 / 2;
            k = 2 * k + j1 - 2 * j2;
            j1 = j2;
        }
        return k;
    }

    public static void main(String[] args) throws IOException {
        Color tag;
        float[] fftdata;
        float[] data;
        float[] fftdata2;
        TreePredict.Img<Color> timg;
        int i;
        ArrayList<Img<Color>> els = new ArrayList<Img<Color>>();
        Random r = new Random();
        String[] FONTS = new String[]{"Times", "Georgia", "Optima", "Times New Roman"};
        for (i = 0; i < 200; ++i) {
            timg = TreePredict.getImg("a", new Config.FontType(FONTS[i % FONTS.length], false), Color.RED, r);
            fftdata2 = SVM.fft(timg.data, new float[timg.data.length], true);
            els.add(new Img<Color>(fftdata2, Color.RED));
        }
        for (i = 0; i < 200; ++i) {
            timg = TreePredict.getImg("e", new Config.FontType(FONTS[i % FONTS.length], false), Color.BLUE, r);
            fftdata2 = SVM.fft(timg.data, new float[timg.data.length], true);
            els.add(new Img<Color>(fftdata2, Color.BLUE));
        }
        SVNode tree = SVM.createSVTree(els, els, 5, 2, null);
        int failures = 0;
        int tries = 0;
        for (File f : new File("/Users/zar/Desktop/DesktopContents/ltestdata3/a/").listFiles()) {
            if (!f.getName().endsWith(".png")) continue;
            data = TreePredict.getImg((BufferedImage)ImageIO.read((File)f), Color.RED).data;
            fftdata = SVM.fft(data, new float[data.length], true);
            tag = tree.classify(new Img<Color>(fftdata, Color.RED));
            if (!tag.equals(Color.RED)) {
                ++failures;
            }
            ++tries;
        }
        for (File f : new File("/Users/zar/Desktop/DesktopContents/ltestdata3/e/").listFiles()) {
            if (!f.getName().endsWith(".png")) continue;
            data = TreePredict.getImg((BufferedImage)ImageIO.read((File)f), Color.BLUE).data;
            fftdata = SVM.fft(data, new float[data.length], true);
            tag = tree.classify(new Img<Color>(fftdata, Color.BLUE));
            if (!tag.equals(Color.BLUE)) {
                ++failures;
            }
            ++tries;
        }
        System.out.println(failures + "/" + tries);
        System.out.println((double)(tries - failures) * 100.0 / (double)tries);
    }

    static int drawC(SVNode n, float[] coords, int level) {
        double dist = n.sv.d - SVM.dot(n.sv.v, coords);
        if (Math.abs(dist) < 2.28E-11) {
            return Math.min(220, 120 + level * 30);
        }
        if (dist < 0.0 && n.aBranch != null) {
            return SVM.drawC(n.aBranch, coords, level + 1);
        }
        if (dist > 0.0 && n.bBranch != null) {
            return SVM.drawC(n.bBranch, coords, level + 1);
        }
        return 255;
    }

    static void drawVector(SVNode n, Graphics2D g, int level) {
        for (int y = 0; y < 800; ++y) {
            for (int x = 0; x < 800; ++x) {
                float[] coords = new float[81];
                coords[0] = (float)x * 2.0f / 800.0f - 1.0f;
                coords[1] = (float)y * 2.0f / 800.0f - 1.0f;
                int intensity = SVM.drawC(n, coords, 0);
                if (intensity == 255) continue;
                g.setColor(new Color(intensity, intensity, intensity));
                g.fillRect(x, y, 1, 1);
            }
        }
    }

    static class SVNode {
        SV sv;
        SVNode aBranch;
        SVNode bBranch;

        SVNode() {
        }

        public Color classify(Img<Color> e) {
            Color c = this.sv.classify(e);
            if (c == this.sv.aTag && this.aBranch != null) {
                return this.aBranch.classify(e);
            }
            if (c == this.sv.bTag && this.bBranch != null) {
                return this.bBranch.classify(e);
            }
            return c;
        }
    }

    static class SV {
        float[] v;
        float d;
        Color aTag;
        Color bTag;

        public SV(float[] v, float d, Color aTag, Color bTag) {
            this.v = v;
            this.d = d;
            this.aTag = aTag;
            this.bTag = bTag;
        }

        public Color classify(Img<Color> e) {
            float dist = this.d - SVM.dot(this.v, e.data);
            return dist < 0.0f ? this.aTag : this.bTag;
        }
    }

    public static class Img<T> {
        float[] data;
        T tag;

        public Img(float[] data, T tag) {
            this.data = data;
            this.tag = tag;
        }
    }
}

