/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.nnidentifier;

import com.zarkonnen.longan.data.Letter;
import com.zarkonnen.longan.nnidentifier.Config;
import com.zarkonnen.longan.nnidentifier.ExampleGenerator2;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class TreePredict {
    static final int SZ = 9;

    public static <T> T vote(HashMap<T, Integer> result) {
        T v = null;
        int amt = 0;
        for (Map.Entry<T, Integer> e : result.entrySet()) {
            if (v != null && amt >= e.getValue()) continue;
            v = e.getKey();
            amt = e.getValue();
        }
        return v;
    }

    public static TreeNode<Config.LetterClass> buildTree(Config.TreeIdentifier ti) {
        Random r = new Random(ti.seed);
        ArrayList imgs = new ArrayList();
        for (int i = 0; i < 300; ++i) {
            for (Config.FontType ft : ti.fonts) {
                for (Config.LetterClass lc : ti.classes) {
                    for (String l : lc.members) {
                        imgs.add(TreePredict.getImg(l, ft, lc, r));
                    }
                }
            }
        }
        return TreePredict.buildTree(imgs);
    }

    public static <T> TreeNode<T> buildTree(List<Img<T>> imgs) {
        if (imgs.isEmpty()) {
            return new TreeNode();
        }
        float currentScore = TreePredict.entropy(imgs);
        float bestGain = 0.0f;
        int bestDimension = 0;
        float bestTestValue = 0.0f;
        ArrayList<Img<T>>[] bestSets = null;
        for (int dim = 0; dim < imgs.get((int)0).data.length; ++dim) {
            HashSet<Float> columnValues = new HashSet<Float>();
            for (Img<T> img : imgs) {
                columnValues.add(Float.valueOf(img.data[dim]));
            }
            Iterator<Img<Object>> iterator = columnValues.iterator();
            while (iterator.hasNext()) {
                float value = ((Float)((Object)iterator.next())).floatValue();
                ArrayList<Img<T>>[] sets = TreePredict.divideset(imgs, dim, value);
                float p = (float)sets[0].size() * 1.0f / (float)imgs.size();
                float gain = currentScore - p * TreePredict.entropy(sets[0]) - (1.0f - p) * TreePredict.entropy(sets[1]);
                if (!(gain > bestGain) || sets[0].isEmpty() || sets[1].isEmpty()) continue;
                bestGain = gain;
                bestDimension = dim;
                bestTestValue = value;
                bestSets = sets;
            }
        }
        if (bestGain > 0.0f) {
            return new TreeNode(bestDimension, bestTestValue, TreePredict.buildTree(bestSets[0]), TreePredict.buildTree(bestSets[1]));
        }
        return new TreeNode<T>(TreePredict.uniquecounts(imgs));
    }

    public static <T> ArrayList<Img<T>>[] divideset(List<Img<T>> imgs, int dimension, float testValue) {
        ArrayList[] sets = new ArrayList[]{new ArrayList(), new ArrayList()};
        for (Img<T> img : imgs) {
            if (img.data[dimension] < testValue) {
                sets[0].add(img);
                continue;
            }
            sets[1].add(img);
        }
        return sets;
    }

    public static <T> HashMap<T, Integer> uniquecounts(List<Img<T>> imgs) {
        HashMap counts = new HashMap();
        for (Img<T> img : imgs) {
            if (!counts.containsKey(img.tag)) {
                counts.put(img.tag, 1);
                continue;
            }
            counts.put(img.tag, (Integer)counts.get(img.tag) + 1);
        }
        return counts;
    }

    public static <T> float entropy(List<Img<T>> imgs) {
        return TreePredict.entropy(TreePredict.uniquecounts(imgs));
    }

    public static <T> float entropy(HashMap<T, Integer> counts) {
        float ent = 0.0f;
        int size = 0;
        for (int c : counts.values()) {
            size += c;
        }
        for (Integer tag : counts.keySet()) {
            float p = (float)counts.get(tag).intValue() * 1.0f / (float)size;
            ent = (float)((double)ent - (double)p * Math.log(p) / Math.log(2.0));
        }
        return ent;
    }

    public static void writeNode(TreeNode<Config.LetterClass> node, ObjectOutputStream oos) throws IOException {
        oos.writeInt(0);
        oos.writeBoolean(node.results == null);
        if (node.results == null) {
            oos.writeInt(node.dimension);
            oos.writeFloat(node.testValue);
            TreePredict.writeNode(node.falseBranch, oos);
            TreePredict.writeNode(node.trueBranch, oos);
        } else {
            oos.writeInt(node.results.size());
            for (Map.Entry result : node.results.entrySet()) {
                oos.writeInt(((Config.LetterClass)result.getKey()).members.size());
                for (String l : ((Config.LetterClass)result.getKey()).members) {
                    oos.writeUTF(l);
                }
                oos.writeInt(result.getValue());
            }
        }
    }

    public static TreeNode<Config.LetterClass> readNode(ObjectInputStream ois) throws IOException {
        if (ois.readInt() > 0) {
            throw new IOException("TreeNode format too modern: I only support up to version 0.");
        }
        TreeNode<Config.LetterClass> node = new TreeNode<Config.LetterClass>();
        if (ois.readBoolean()) {
            node.results = null;
            node.dimension = ois.readInt();
            node.testValue = ois.readFloat();
            node.falseBranch = TreePredict.readNode(ois);
            node.trueBranch = TreePredict.readNode(ois);
        } else {
            int n = ois.readInt();
            for (int i = 0; i < n; ++i) {
                Config.LetterClass lc = new Config.LetterClass();
                int ls = ois.readInt();
                for (int j = 0; j < ls; ++j) {
                    lc.members.add(ois.readUTF());
                }
                node.results.put(lc, ois.readInt());
            }
        }
        return node;
    }

    static <T> String str(HashMap<T, Integer> results) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<T, Integer> e : results.entrySet()) {
            sb.append(" ");
            sb.append(e.getKey());
            sb.append(": ");
            sb.append(e.getValue());
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static <T> Img<T> getImg(String l, Config.FontType ft, T tag, Random r) {
        return TreePredict.getImg(ExampleGenerator2.makeCorrectlyVariableLetterImage(l, ft, r), tag);
    }

    public static <T> Img<T> getImg(BufferedImage src, T tag) {
        return TreePredict.getImg(src, tag, 0);
    }

    public static <T> Img<T> getImg(BufferedImage src, T tag, int intensityAdjustment) {
        BufferedImage scaledSrc = new BufferedImage(9, 9, 1);
        Graphics g = scaledSrc.getGraphics();
        g.drawImage(src, 0, 0, 9, 9, 0, 0, src.getWidth(), src.getHeight(), null);
        src = scaledSrc;
        float[] result = new float[81];
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                Color c = new Color(src.getRGB(x, y));
                result[y * 9 + x] = (float)(c.getRed() + c.getGreen() + c.getBlue() + intensityAdjustment * 3) / 255.0f / 1.5f - 1.0f;
            }
        }
        return new Img<T>(result, tag);
    }

    public static Img getImg(Letter r, BufferedImage src, int intensityAdjustment) {
        BufferedImage maskedSrc = new BufferedImage(r.width, r.height, 1);
        Graphics g = maskedSrc.getGraphics();
        g.drawImage(src, 0, 0, r.width, r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
        int white = Color.WHITE.getRGB();
        for (int y = 0; y < r.height; ++y) {
            for (int x = 0; x < r.width; ++x) {
                boolean hasMask = false;
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dx = -1; dx < 2; ++dx) {
                        int ny = y + dy;
                        int nx = x + dx;
                        if (ny < 0 || ny >= r.height || nx < 0 || nx >= r.width) continue;
                        hasMask |= r.mask[ny][nx];
                    }
                }
                if (hasMask) continue;
                maskedSrc.setRGB(x, y, white);
            }
        }
        return TreePredict.getImg(maskedSrc, null, intensityAdjustment);
    }

    public static class Img<T> {
        float[] data;
        T tag;
        int width = 9;
        int height = 9;

        public Img(float[] data, T tag) {
            this.data = data;
            this.tag = tag;
        }
    }

    public static class TreeNode<T> {
        int dimension;
        float testValue;
        HashMap<T, Integer> results;
        TreeNode<T> falseBranch;
        TreeNode<T> trueBranch;

        public void prune(float minGain) {
            if (this.results != null) {
                return;
            }
            if (this.falseBranch.results != null) {
                this.falseBranch.prune(minGain);
            }
            if (this.trueBranch.results != null) {
                this.trueBranch.prune(minGain);
            }
            if (this.falseBranch.results != null && this.trueBranch.results != null) {
                HashMap<T, Integer> combined = new HashMap<T, Integer>(this.falseBranch.results);
                for (Map.Entry<T, Integer> e : this.trueBranch.results.entrySet()) {
                    if (combined.containsKey(e.getKey())) {
                        combined.put(e.getKey(), combined.get(e.getKey()) + e.getValue());
                        continue;
                    }
                    combined.put(e.getKey(), e.getValue());
                }
                float delta = TreePredict.entropy(combined) - (TreePredict.entropy(this.falseBranch.results) + TreePredict.entropy(this.trueBranch.results)) / 2.0f;
                if (delta < minGain) {
                    this.results = combined;
                    this.falseBranch = null;
                    this.trueBranch = null;
                }
            }
        }

        public HashMap<T, Integer> classify(Img img) {
            if (this.results == null) {
                if (img.data[this.dimension] < this.testValue) {
                    return this.falseBranch.classify(img);
                }
                return this.trueBranch.classify(img);
            }
            return this.results;
        }

        public TreeNode() {
            this.results = new HashMap();
        }

        public TreeNode(int dimension, float testValue, TreeNode falseBranch, TreeNode trueBranch) {
            this.dimension = dimension;
            this.testValue = testValue;
            this.falseBranch = falseBranch;
            this.trueBranch = trueBranch;
        }

        public TreeNode(HashMap<T, Integer> results) {
            this.results = results;
        }

        public String toString() {
            return this.toString("  ");
        }

        private String toString(String indent) {
            StringBuilder sb = new StringBuilder();
            if (this.results == null) {
                sb.append("data[");
                sb.append(this.dimension);
                sb.append("] > ");
                sb.append(this.testValue);
                sb.append("\n");
                sb.append(indent);
                sb.append("? ");
                sb.append(super.toString(indent + "  "));
                sb.append("\n");
                sb.append(indent);
                sb.append(": ");
                sb.append(super.toString(indent + "  "));
            } else {
                sb.append(TreePredict.str(this.results));
            }
            return sb.toString();
        }
    }

    static class DimCmp
    implements Comparator<Img> {
        final int dim;

        public DimCmp(int dim) {
            this.dim = dim;
        }

        @Override
        public int compare(Img t, Img t1) {
            return Float.compare(t.data[this.dim], t1.data[this.dim]);
        }
    }
}

