/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.nnidentifier.network;

import com.zarkonnen.longan.nnidentifier.network.Node;
import com.zarkonnen.longan.nnidentifier.network.Weight;
import java.util.ArrayList;

public class Layer {
    public final ArrayList<Node> nodes;
    public final ArrayList<Weight> weights;
    public final String name;

    public Layer(String name) {
        this.name = name;
        this.nodes = new ArrayList();
        this.weights = new ArrayList();
    }

    public Layer(String name, ArrayList<Node> nodes, ArrayList<Weight> weights) {
        this.name = name;
        this.nodes = nodes;
        this.weights = weights;
    }

    public void update() {
        for (Node n : this.nodes) {
            n.update();
        }
    }

    public void calculateDelta() {
        for (Node n : this.nodes) {
            n.calculateDelta();
        }
    }

    public float adjustWeights(float n, float m) {
        float total = 0.0f;
        for (Weight w : this.weights) {
            total = (float)((double)total + Math.abs(w.adjust(n, m)));
        }
        return total / (float)this.weights.size();
    }

    String getDetails() {
        String d = "";
        for (Node n : this.nodes) {
            d = d + n.name + " act=" + n.activation + " delta=" + n.delta + "\n";
        }
        return d;
    }
}

