/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.longan.nnidentifier.network;

import com.zarkonnen.longan.nnidentifier.network.Layer;
import com.zarkonnen.longan.nnidentifier.network.Node;
import com.zarkonnen.longan.nnidentifier.network.Weight;
import java.util.ArrayList;

public class Network {
    public final ArrayList<Layer> layers;

    public Network(ArrayList<Layer> layers) {
        this.layers = layers;
    }

    public double cutBelowThreshold(double t) {
        int nCut = 0;
        double nConns = 0.0;
        for (Layer l : this.layers) {
            nConns += (double)l.weights.size();
            for (Weight w : l.weights) {
                if (!((double)Math.abs(w.value) < t)) continue;
                w.value = 0.0f;
                ++nCut;
            }
        }
        return (double)nCut / nConns;
    }

    public void train(float[] input, float[] target, float[] n, float[] m) {
        this.setInput(input);
        this.update();
        this.setTargets(target);
        this.calculateDelta();
        this.adjustWeights(n, m);
    }

    public void train(float[] input, float[] target, float n, float m) {
        this.setInput(input);
        this.update();
        this.setTargets(target);
        this.calculateDelta();
        this.adjustWeights(n, m);
    }

    public float[] run(float[] input) {
        this.setInput(input);
        this.update();
        float[] output = new float[this.layers.get((int)(this.layers.size() - 1)).nodes.size()];
        for (int i = 0; i < output.length; ++i) {
            output[i] = this.layers.get((int)(this.layers.size() - 1)).nodes.get((int)i).activation;
        }
        return output;
    }

    public void setInput(float[] inputs) {
        ArrayList<Node> iNodes = this.layers.get((int)0).nodes;
        assert (inputs.length == iNodes.size());
        for (int i = 0; i < inputs.length; ++i) {
            iNodes.get((int)i).activation = inputs[i];
        }
    }

    public void setTargets(float[] targets) {
        ArrayList<Node> outputs = this.layers.get((int)(this.layers.size() - 1)).nodes;
        assert (targets.length == outputs.size());
        for (int i = 0; i < targets.length; ++i) {
            outputs.get((int)i).delta = targets[i] - outputs.get((int)i).activation;
        }
    }

    public void calculateDelta() {
        for (int i = this.layers.size() - 2; i >= 0; --i) {
            this.layers.get(i).calculateDelta();
        }
    }

    public void adjustWeights(float n, float m) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.get(i).adjustWeights(n, m);
        }
    }

    public void adjustWeights(float[] n, float[] m) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.get(i).adjustWeights(n[i], m[i]);
        }
    }

    public void update() {
        for (Layer l : this.layers) {
            l.update();
        }
    }

    public String getDetails() {
        String d = "";
        for (Layer l : this.layers) {
            d = d + l.getDetails() + "\n";
        }
        return d;
    }

    public int numWeights() {
        int n = 0;
        for (Layer l : this.layers) {
            n += l.weights.size();
        }
        return n;
    }

    public int numNodes() {
        int n = 0;
        for (Layer l : this.layers) {
            n += l.nodes.size();
        }
        return n;
    }
}

