(ns common.basic
  (:require
   [common.coding :refer [b64->string]]
   [clojure.string :as str]))

(defn parse-basic-header
  "Given a request, try to extract and parse the http basic header.
   From buddy."
  [request]
  (when-let [decoded (some->> (get-in request [:headers "authorization"])
                              (re-find #"^Basic (.+)$")
                              (second)
                              (b64->string))]
    (when-let [[username password] (str/split decoded #":" 2)]
      (when username
        {:username username :password password}))))
