(ns common.crypt
  (:import java.security.SecureRandom)
  (:require
   [common.coding :refer [byte-array->hex-string]]))

(def ^:private base62-chars
  "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz")
(def ^:private base62-size (count base62-chars))

(defn random-token
  ([] (random-token 32))
  ([nchars]
   (let [^SecureRandom sr (SecureRandom.)]
     (->> (repeatedly nchars #(.nextInt sr base62-size))
          (map (fn [i] (.charAt base62-chars i)))
          (apply str)))))

(defn sha1-bytes
  "Return the sha1 hash code of a string as a byte array."
  [s]
  (let [md (java.security.MessageDigest/getInstance "SHA1")]
    (.update md (.getBytes s))
    (.digest md)))

(defn sha1
  "Return the sha1 hash code of a string as a hex string"
  [s]
  (byte-array->hex-string (sha1-bytes s) true))
