(ns common.test
  "Things that make testing easier."
  (:require [clojure.test :refer [is]]))

(defn is-each
  "Maps `is` and a predicate over a variety of expected
   input and output values."
  [pred test-fn cases]
  (doseq [[input output] cases]
    (is (pred output (test-fn input)))))

(def is-each= (partial is-each =))
