(ns common.coding
  (:require
   [byte-streams]
   [byte-transforms]))

(defn ->b64-string [x]
  (when x
    (-> x
        (byte-transforms/encode :base64)
        (byte-streams/to-string))))

(defn b64-string->ba [s]
  (when s
    (byte-transforms/decode s :base64)))

(defn b64->string [s]
  (when s
    (-> s
        (byte-transforms/decode :base64)
        (byte-streams/to-string))))

(defn byte-array->hex-string
  "Take a byte array and convert it to a hex string."
  ([array] (byte-array->hex-string array false))
  ([array plain]
     (let [s (new String (org.apache.commons.codec.binary.Hex/encodeHex array))]
       (if plain
           s
           (->> s
                (partition-all 8)
                (interpose "-")
                (map #(apply str %))
                (apply str))))))

(defn hex-string->byte-array
  "Take a string of hex chars and convert it ot a decoded byte array."
  [s]
  (org.apache.commons.codec.binary.Hex/decodeHex (.toCharArray s)))
