(ns hiccup.bootstrap.page
  (:use hiccup.page))

(defn include-bootstrap
  "Add Bootstrap CSS and JS resources to the page."
  []
  (list
   (include-css "/bootstrap/css/bootstrap.css")
   (include-css "/bootstrap/css/bootstrap-responsive.css")
   (include-js  "/bootstrap/js/bootstrap.js")))

(defn include-bootstrap-css
  "Add Bootstrap CSS and JS resources to the page."
  []
  (list
   (include-css "/bootstrap/css/bootstrap.min.css")
   (include-css "/bootstrap/css/bootstrap-responsive.min.css")))

(defn include-bootstrap-js
  "Add Bootstrap CSS and JS resources to the page."
  []
  (list
   (include-js  "/bootstrap/js/bootstrap.min.js")))

(defn fixed-layout
  "Encase its contents in a fixed layout container."
  [& contents]
  [:div {:class "container"} contents])

(defn fluid-layout
  "Encase its contents in a fluid layout container."
  [& contents]
  [:div {:class "container-fluid"}
   [:div {:class "row-fluid"}
    contents]])