/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.jzmq.sockets;

import org.zeromq.api.Bindable;
import org.zeromq.api.Connectable;
import org.zeromq.api.Socket;
import org.zeromq.api.SocketType;
import org.zeromq.jzmq.ManagedContext;

public abstract class SocketBuilder
implements Bindable,
Connectable {
    private String identity;
    private long swapSize;
    private long lingerMS;
    private long sendHWM;
    private long receiveHWM;
    private SocketType socketType;

    public SocketBuilder(ManagedContext context, SocketType socketType) {
        this.socketType = socketType;
    }

    public SocketType getSocketType() {
        return this.socketType;
    }

    public SocketBuilder withLinger(long lingerMS) {
        this.lingerMS = lingerMS;
        return this;
    }

    public long getLinger() {
        return this.lingerMS;
    }

    public SocketBuilder withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public String getIdentity() {
        return this.identity;
    }

    public SocketBuilder withSwap(long swapSize) {
        this.swapSize = swapSize;
        return this;
    }

    public long getSwap() {
        return this.swapSize;
    }

    public SocketBuilder withSendHWM(long sendHWM) {
        this.sendHWM = sendHWM;
        return this;
    }

    public long getSendHWM() {
        return this.sendHWM;
    }

    public SocketBuilder withReceiveHWM(long receiveHWM) {
        this.receiveHWM = receiveHWM;
        return this;
    }

    public long getRecvHWM() {
        return this.receiveHWM;
    }

    @Override
    public abstract Socket connect(String var1) throws Exception;

    @Override
    public abstract Socket bind(String var1) throws Exception;
}

