# java-wrapper

Clojure wrappers for various Java classes.

[![Clojars Project](https://img.shields.io/clojars/v/trptr/java-wrapper.svg)](https://clojars.org/trptr/java-wrapper)

## Goal

Provide APIs for Java classes that make their usage comfortable within Clojure.

For example, compare the usage of `java.util.Locale$Builder.build` in the standard way:

```clojure
(-> (Locale$Builder.)
    (.setLanguage "ru")
    (.setScript   "Cyrl")
    (.build))
```
with the equivalent code using `trptr.java-wrapper.locale/build`:

```clojure
(build {:language "ru"
        :script   "Cyrl"})
```

In simpler cases a keyword (or a string...) can substitute a complete object, which is then created on the fly,
behind the scenes, as needed:

```clojure
(get-display-name :de-ch :en)
```

(using `get-display-name` from the `ns` `trptr.java-wrapper.locale`) is equivalent to

```clojure
(.getDisplayName (Locale. "de" "CH") (Locale. "en"))
```

## Documentation

* this readme
* [API and namepace docs](http://trptr.github.io/java-wrapper/index.html)
* [tests](test/trptr/java_wrapper): simple usage examples


## Status

The latest version is 0.2.2, containing wrappers for 1 class: `java.util.Locale`.

Coming soon: `java.text.NumberFormat`.


## Usage

### Via `deps.edn`

#### Using a git url

Include a dependency on this repo in your `deps.edn`. For exmaple:

```clojure
{:deps {org.clojure/clojure {:mvn/version "1.10.0"}
        trptr/java-wrapper  {:git/url "https://github.com/trptr/java-wrapper.git"
                             :sha     "e9dc1df3e4788b9c5a2b344fdc2b9cb71763e29f"}}}
```

#### Using mvn version

Include a dependency on the mvn version in your `deps.edn`. For exmaple:

```clojure
{:deps {org.clojure/clojure {:mvn/version "1.10.0"}
        trptr/java-wrapper  {:mvn/version "0.2.2"}}}
```
### Via Leiningen

Include a dependency on the mvn version in your `project.clj`. For exmaple:

```clojure
:dependencies [[org.clojure/clojure "1.10.0"]
               [trptr/java-wrapper "0.2.2"]]
```

### Others

See https://clojars.org/trptr/java-wrapper.

### Inside your `ns`

Require the proper trptr namespace(s). For example:

```clojure
(ns my-namespace
    (:require [trptr.java-wrapper.locale :as jwl]))

(defn -main
  [& _]
  (->> jwl/available-locales
       (map jwl/get-display-name)
       sort
       (clojure.string/join "\n")
       println))
```

## License

GPL-3.0 -- if you need other licensing, let me know!
