/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapi;

import com.bloomberglp.blpapi.impl.dj;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public final class Datetime
implements Cloneable {
    public static final short YEAR = 128;
    public static final byte MONTH = 64;
    public static final byte DAY_OF_MONTH = 32;
    public static final byte HOUR = 16;
    public static final byte MINUTE = 8;
    public static final byte SECOND = 4;
    public static final byte MILLISECOND = 2;
    public static final byte TIME_ZONE_OFFSET = 1;
    public static final short DATE = 224;
    public static final short TIME = 28;
    public static final short TIMEMILLI = 30;
    public static final short MICROSECOND = 258;
    public static final short NANOSECOND = 770;
    public static final short PICOSECOND = 1794;
    private int zr;
    private short[] zs;
    private Calendar zt;
    private long zu;
    private int zv = 1000;
    private int zw = 1000000;
    private long zx = 1000000000L;

    public Datetime() {
        this.init();
    }

    public Datetime(Datetime datetime) {
        this.init();
        this.zt = null;
        this.zr = datetime.zr;
        this.zu = datetime.zu;
        System.arraycopy(datetime.zs, 0, this.zs, 0, this.zs.length);
    }

    public Datetime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.init();
        this.setDatetime(n, n2, n3, n4, n5, n6, n7);
    }

    public Datetime(int n, int n2, int n3) {
        this.init();
        this.setDate(n, n2, n3);
    }

    public Datetime(int n, int n2, int n3, int n4) {
        this.init();
        this.setTime(n, n2, n3, n4);
    }

    public Datetime(Calendar calendar) {
        this.init();
        this.setDatetimeTz(calendar);
    }

    private void init() {
        this.zs = new short[8];
        this.clear();
    }

    public int year() {
        return this.zs[0];
    }

    public int month() {
        return this.zs[1];
    }

    public int dayOfMonth() {
        return this.zs[2];
    }

    public int hour() {
        return this.zs[3];
    }

    public int minute() {
        return this.zs[4];
    }

    public int second() {
        return this.zs[5];
    }

    public int milliSecond() {
        return this.millisecond();
    }

    public int millisecond() {
        return this.zs[6];
    }

    public int microsecond() {
        return (int)((this.zu + (long)this.millisecond() * 1000000000L) / 1000000L);
    }

    public int nanosecond() {
        return (int)((this.zu + (long)this.millisecond() * 1000000000L) / 1000L);
    }

    public long picosecond() {
        return this.zu + (long)this.millisecond() * 1000000000L;
    }

    public int timezoneOffsetMinutes() {
        return this.zs[7];
    }

    public Calendar calendar() {
        if (this.zt == null) {
            this.zt = Calendar.getInstance();
        }
        this.zt.clear();
        if (this.hasParts(128)) {
            this.zt.set(1, this.zs[0]);
        }
        if (this.hasParts(64)) {
            this.zt.set(2, this.zs[1] - 1);
        }
        if (this.hasParts(32)) {
            this.zt.set(5, this.zs[2]);
        }
        if (this.hasParts(16)) {
            this.zt.set(11, this.zs[3]);
        }
        if (this.hasParts(8)) {
            this.zt.set(12, this.zs[4]);
        }
        if (this.hasParts(4)) {
            this.zt.set(13, this.zs[5]);
        }
        if (this.hasParts(2)) {
            this.zt.set(14, this.zs[6]);
        }
        if (this.hasParts(1)) {
            if (this.zs[7] == 0) {
                this.zt.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                Calendar calendar = Calendar.getInstance();
                TimeZone timeZone = calendar.getTimeZone();
                Calendar calendar2 = this.hasParts(128) ? this.zt : calendar;
                int n = ((calendar2.get(11) * 60 + calendar2.get(12)) * 60 + calendar2.get(13)) * 1000 + calendar2.get(14);
                int n2 = timeZone.getOffset(calendar2.get(0), calendar2.get(1), calendar2.get(2), calendar2.get(5), calendar2.get(7), n) / 60000;
                if (n2 != this.zs[7]) {
                    this.zt.setTimeZone(TimeZone.getTimeZone("GMT"));
                    if (this.hasParts(16)) {
                        this.zt.setTimeInMillis(this.zt.getTimeInMillis() + (long)(this.zs[7] * 60 * 1000));
                    }
                }
            }
        }
        return this.zt;
    }

    public boolean isValidField(int n) {
        return this.hasParts(n);
    }

    public int parts() {
        return this.zr;
    }

    public boolean hasParts(int n) {
        return n == (this.zr & n);
    }

    public boolean isValid() {
        if ((this.hasParts(128) || this.hasParts(64) || this.hasParts(32)) && !this.iL()) {
            return false;
        }
        return !this.hasParts(16) && !this.hasParts(8) && !this.hasParts(4) && !this.hasParts(2) || this.iM();
    }

    public void setDatetime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDayOfMonth(n3);
        this.setHour(n4);
        this.setMinute(n5);
        this.setSecond(n6);
        this.setMillisecond(n7);
    }

    public void setDatetimeTz(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.setDatetime(n, n2, n3, n4, n5, n6, n7);
        this.setTimezoneOffsetMinutes(n8);
    }

    public void setDate(int n, int n2, int n3) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDayOfMonth(n3);
    }

    public void setDateTz(int n, int n2, int n3, int n4) {
        this.setDate(n, n2, n3);
        this.setTimezoneOffsetMinutes(n4);
    }

    public void setTime(int n, int n2, int n3, int n4) {
        this.setHour(n);
        this.setMinute(n2);
        this.setSecond(n3);
        this.setMillisecond(n4);
    }

    public void setTimeTz(int n, int n2, int n3, int n4, int n5) {
        this.setTime(n, n2, n3, n4);
        this.setTimezoneOffsetMinutes(n5);
    }

    public void setDatetimeTz(Calendar calendar) {
        this.setDatetime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        int n = ((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14);
        int n2 = calendar.getTimeZone().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), n) / 60000;
        this.setTimezoneOffsetMinutes(n2);
    }

    public void setYear(int n) {
        this.zs[0] = (short)n;
        this.zr |= 0x80;
    }

    public void setMonth(int n) {
        this.zs[1] = (byte)n;
        this.zr |= 0x40;
    }

    public void setDayOfMonth(int n) {
        this.zs[2] = (byte)n;
        this.zr |= 0x20;
    }

    public void setHour(int n) {
        this.zs[3] = (byte)n;
        this.zr |= 0x10;
    }

    public void setMinute(int n) {
        this.zs[4] = (byte)n;
        this.zr |= 8;
    }

    public void setSecond(int n) {
        this.zs[5] = (byte)n;
        this.zr |= 4;
    }

    public void setMilliSecond(int n) {
        this.setMillisecond(n);
    }

    public void setMillisecond(int n) {
        this.zs[6] = (short)n;
        this.zr |= 2;
    }

    public void setMicrosecond(int n) {
        this.setMillisecond(n / this.zv % 1000);
        this.zu = (long)(n % 1000) * 1000000L;
        this.zr |= 0x102;
    }

    public void setNanosecond(int n) {
        this.setMillisecond(n / this.zw % 1000);
        this.zu = (long)n % 1000000L * 1000L;
        this.zr |= 0x302;
    }

    public void setPicosecond(long l2) {
        this.setMillisecond((int)(l2 / this.zx % 1000L));
        this.zu = l2 % 1000000000L;
        this.zr |= 0x702;
    }

    public void setTimezoneOffsetMinutes(int n) {
        this.zs[7] = (short)n;
        this.zr |= 1;
    }

    public void clear() {
        this.zr = 0;
        this.zs[0] = 1;
        this.zs[1] = 1;
        this.zs[2] = 1;
        this.zs[3] = 24;
        this.zs[4] = 0;
        this.zs[5] = 0;
        this.zs[6] = 0;
        this.zs[7] = 0;
        this.zt = null;
        this.zu = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Datetime) {
            Datetime datetime = (Datetime)object;
            if ((this.zr & 0xFF) == (datetime.zr & 0xFF) && Arrays.equals(this.zs, datetime.zs) && this.zu == datetime.zu) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        return new Datetime(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10);
        char c2 = '\u0000';
        if (this.hasParts(128) || this.hasParts(64) || this.hasParts(32)) {
            stringBuilder.append(dj.e((Datetime)this));
            c2 = 'T';
        }
        if (this.hasParts(16) || this.hasParts(8) || this.hasParts(4) || this.hasParts(2)) {
            if (c2 != '\u0000') {
                stringBuilder.append(c2);
            }
            stringBuilder.append(dj.g((Datetime)this));
        }
        if (this.hasParts(1)) {
            dj.g((StringBuilder)stringBuilder, (Datetime)this);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        Long l2 = new Long((long)(this.zs[0] + this.zs[1] + this.zs[2] * 3600000 + this.zs[3] * 3600000 + this.zs[4] * 60000 + this.zs[5] * 1000 + this.zs[6] + this.zs[7]) + this.zu);
        return l2.hashCode();
    }

    private boolean isLeapYear(int n) {
        return 0 == n % 4 && (n <= 1752 || 0 != n % 100 || 0 == n % 400);
    }

    private boolean iL() {
        int n = this.year();
        int n2 = this.month();
        int n3 = this.dayOfMonth();
        if (n <= 0 || n > 9999 || n2 <= 0 || n2 > 12 || n3 <= 0 || n3 > 31) {
            return false;
        }
        if (n3 < 29) {
            return true;
        }
        if (n == 1752 && n2 == 9 && n3 > 2 && n3 < 14) {
            return false;
        }
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return true;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return n3 <= 30;
            }
            case 2: {
                if (this.isLeapYear(n)) {
                    return n3 <= 29;
                }
                return n3 <= 28;
            }
        }
        return true;
    }

    private boolean iM() {
        int n = this.hour();
        int n2 = this.minute();
        int n3 = this.second();
        long l2 = this.picosecond();
        if (n == 24) {
            return n2 == 0 && n3 == 0 && l2 == 0L;
        }
        return n >= 0 && n < 24 && n2 >= 0 && n2 < 60 && n3 >= 0 && n3 < 60 && l2 >= 0L && l2 < 1000000000000L;
    }
}

