// Compiled by ClojureScript 0.0-2138
goog.provide('turbovote.imbarcode');
goog.require('cljs.core');
goog.require('turbovote.imbarcode.binary');
goog.require('turbovote.imbarcode.characters');
goog.require('turbovote.imbarcode.codewords');
goog.require('turbovote.imbarcode.crc');
goog.require('turbovote.imbarcode.bars');
goog.require('turbovote.imbarcode.bars');
goog.require('turbovote.imbarcode.characters');
goog.require('turbovote.imbarcode.crc');
goog.require('turbovote.imbarcode.codewords');
goog.require('turbovote.imbarcode.binary');
turbovote.imbarcode.encode_binary_data = (function encode_binary_data(binary_data){var fcs = turbovote.imbarcode.crc.IMb_fcs.call(null,binary_data);return turbovote.imbarcode.bars.bars.call(null,turbovote.imbarcode.characters.codewords__GT_characters.call(null,turbovote.imbarcode.codewords.data__GT_codewords.call(null,binary_data,fcs),fcs));
});
turbovote.imbarcode.barcode_id_COLON_default = "00";
goog.exportSymbol('turbovote.imbarcode.barcode_id_COLON_default', turbovote.imbarcode.barcode_id_COLON_default);
turbovote.imbarcode.service_type_id_COLON_destination = "040";
goog.exportSymbol('turbovote.imbarcode.service_type_id_COLON_destination', turbovote.imbarcode.service_type_id_COLON_destination);
turbovote.imbarcode.service_type_id_COLON_origin = "050";
goog.exportSymbol('turbovote.imbarcode.service_type_id_COLON_origin', turbovote.imbarcode.service_type_id_COLON_origin);
/**
* Generate the texual representation of an encoded USPS IMbarcode
* from the data provided. For origin tracing, pass in a barcode id,
* service type id, customer number, and routing number.  For
* destination tracing, pass in a barcode id, service type id, mailer
* id, serial number, and routing number.
* 
* The generated string will consist of the characters [ADFT].  See
* section 3.1.3 of the IMb spec for a detailed description of the
* parameters.
*/
turbovote.imbarcode.encode = (function() {
var encode = null;
var encode__4 = (function (barcode,service,customer_number,routing){return turbovote.imbarcode.encode_binary_data.call(null,turbovote.imbarcode.binary.binary_encode.call(null,barcode,service,customer_number,routing));
});
var encode__5 = (function (barcode,service,mailer,serial_number,routing){return turbovote.imbarcode.encode_binary_data.call(null,turbovote.imbarcode.binary.binary_encode.call(null,barcode,service,mailer,serial_number,routing));
});
encode = function(barcode,service,mailer,serial_number,routing){
switch(arguments.length){
case 4:
return encode__4.call(this,barcode,service,mailer,serial_number);
case 5:
return encode__5.call(this,barcode,service,mailer,serial_number,routing);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
encode.cljs$core$IFn$_invoke$arity$4 = encode__4;
encode.cljs$core$IFn$_invoke$arity$5 = encode__5;
return encode;
})()
;
goog.exportSymbol('turbovote.imbarcode.encode', turbovote.imbarcode.encode);

//# sourceMappingURL=imbarcode.js.map