// Compiled by ClojureScript 0.0-2138
goog.provide('turbovote.imbarcode');
goog.require('cljs.core');
goog.require('turbovote.imbarcode.binary');
goog.require('turbovote.imbarcode.characters');
goog.require('turbovote.imbarcode.codewords');
goog.require('turbovote.imbarcode.crc');
goog.require('turbovote.imbarcode.bars');
goog.require('turbovote.imbarcode.bars');
goog.require('turbovote.imbarcode.characters');
goog.require('turbovote.imbarcode.crc');
goog.require('turbovote.imbarcode.codewords');
goog.require('turbovote.imbarcode.binary');
turbovote.imbarcode.encode_binary_data = (function encode_binary_data(binary_data){var fcs = turbovote.imbarcode.crc.IMb_fcs.call(null,binary_data);return turbovote.imbarcode.bars.bars.call(null,turbovote.imbarcode.characters.codewords__GT_characters.call(null,turbovote.imbarcode.codewords.data__GT_codewords.call(null,binary_data,fcs),fcs));
});
turbovote.imbarcode.barcode_id_COLON_default = "00";
goog.exportSymbol('turbovote.imbarcode.barcode_id_COLON_default', turbovote.imbarcode.barcode_id_COLON_default);
turbovote.imbarcode.service_type_id_COLON_destination = "040";
goog.exportSymbol('turbovote.imbarcode.service_type_id_COLON_destination', turbovote.imbarcode.service_type_id_COLON_destination);
turbovote.imbarcode.service_type_id_COLON_origin = "050";
goog.exportSymbol('turbovote.imbarcode.service_type_id_COLON_origin', turbovote.imbarcode.service_type_id_COLON_origin);
/**
* Generate the texual representation of an encoded USPS IMbarcode
* from the data provided. For origin tracing, pass in a barcode id,
* service type id, customer number, and routing number.  For
* destination tracing, pass in a barcode id, service type id, mailer
* id, serial number, and routing number.
* 
* The generated string will consist of the characters [ADFT].  See
* section 3.1.3 of the IMb spec for a detailed description of the
* parameters.
*/
turbovote.imbarcode.encode = (function() {
var encode = null;
var encode__4 = (function (barcode,service,customer_number,routing){if(cljs.core.every_QMARK_.call(null,cljs.core.string_QMARK_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [barcode,service,customer_number,routing], null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"every?","every?",1363110461,null),new cljs.core.Symbol(null,"string?","string?",772676615,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null),new cljs.core.Symbol(null,"service","service",343621742,null),new cljs.core.Symbol(null,"customer-number","customer-number",-1672525359,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)], null))))].join('')));
}
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,barcode),2))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null)),2)))].join('')));
}
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,service),3))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"service","service",343621742,null)),3)))].join('')));
}
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,customer_number),15))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"customer-number","customer-number",-1672525359,null)),15)))].join('')));
}
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null).call(null,cljs.core.count.call(null,routing))))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)))))].join('')));
}
return turbovote.imbarcode.encode_binary_data.call(null,turbovote.imbarcode.binary.binary_encode.call(null,barcode,service,customer_number,routing));
});
var encode__5 = (function (barcode,service,mailer,serial_number,routing){if(cljs.core.every_QMARK_.call(null,cljs.core.string_QMARK_,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [barcode,service,mailer,serial_number,routing], null)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"every?","every?",1363110461,null),new cljs.core.Symbol(null,"string?","string?",772676615,null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null),new cljs.core.Symbol(null,"service","service",343621742,null),new cljs.core.Symbol(null,"mailer","mailer",1572862557,null),new cljs.core.Symbol(null,"serial-number","serial-number",1541334779,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)], null))))].join('')));
}
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,barcode),2))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"barcode","barcode",-1974115783,null)),2)))].join('')));
}
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,service),3))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"service","service",343621742,null)),3)))].join('')));
}
if(((cljs.core._EQ_.call(null,cljs.core.count.call(null,mailer),6)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,serial_number),9))) || ((cljs.core._EQ_.call(null,cljs.core.count.call(null,mailer),9)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,serial_number),6))))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"or","or",-1640527972,null),cljs.core.list(new cljs.core.Symbol(null,"and","and",-1640434800,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"mailer","mailer",1572862557,null)),6),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"serial-number","serial-number",1541334779,null)),9)),cljs.core.list(new cljs.core.Symbol(null,"and","and",-1640434800,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"mailer","mailer",1572862557,null)),9),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1640531466,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"serial-number","serial-number",1541334779,null)),6)))))].join('')));
}
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null).call(null,cljs.core.count.call(null,routing))))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [0,null,5,null,9,null,11,null], null), null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-1545680184,null),new cljs.core.Symbol(null,"routing","routing",-254879105,null)))))].join('')));
}
return turbovote.imbarcode.encode_binary_data.call(null,turbovote.imbarcode.binary.binary_encode.call(null,barcode,service,mailer,serial_number,routing));
});
encode = function(barcode,service,mailer,serial_number,routing){
switch(arguments.length){
case 4:
return encode__4.call(this,barcode,service,mailer,serial_number);
case 5:
return encode__5.call(this,barcode,service,mailer,serial_number,routing);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
encode.cljs$core$IFn$_invoke$arity$4 = encode__4;
encode.cljs$core$IFn$_invoke$arity$5 = encode__5;
return encode;
})()
;
goog.exportSymbol('turbovote.imbarcode.encode', turbovote.imbarcode.encode);
turbovote.imbarcode.origin_service_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["050",null,"051",null,"052",null], null), null);
/**
* Split IMbarcode structure digits into their constituent parts
*/
turbovote.imbarcode.split_structure_digits = (function split_structure_digits(imb){var barcode = cljs.core.subs.call(null,imb,0,2);var service = cljs.core.subs.call(null,imb,2,5);var routing = cljs.core.subs.call(null,imb,20);var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"barcode","barcode",680319986),barcode,new cljs.core.Keyword(null,"service","service",2998057511),service,new cljs.core.Keyword(null,"routing","routing",2399556664),routing], null);if(cljs.core.truth_(turbovote.imbarcode.origin_service_types.call(null,service)))
{return cljs.core.assoc.call(null,response,new cljs.core.Keyword(null,"customer-number","customer-number",981910410),cljs.core.subs.call(null,imb,5,20));
} else
{var mailer_and_serial = cljs.core.subs.call(null,imb,5,20);return cljs.core.assoc.call(null,response,new cljs.core.Keyword(null,"6-digit-mailer","6-digit-mailer",4716025069),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mailer","mailer",4227298326),cljs.core.subs.call(null,mailer_and_serial,0,6),new cljs.core.Keyword(null,"serial-number","serial-number",4195770548),cljs.core.subs.call(null,mailer_and_serial,6)], null),new cljs.core.Keyword(null,"9-digit-mailer","9-digit-mailer",3199349194),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mailer","mailer",4227298326),cljs.core.subs.call(null,mailer_and_serial,0,9),new cljs.core.Keyword(null,"serial-number","serial-number",4195770548),cljs.core.subs.call(null,mailer_and_serial,9)], null));
}
});
goog.exportSymbol('turbovote.imbarcode.split_structure_digits', turbovote.imbarcode.split_structure_digits);

//# sourceMappingURL=imbarcode.js.map