(ns tusk.adapter-clojure-jdbc)

(extend-protocol jdbc.proto/ISQLResultSetReadColumn
  PgArray
  (from-sql-type [d conn metadata idx]
    (let [[uno :as a] (into [] (.getArray d))]
      (if (instance? PGobject uno)
        (mapv #(read-pg-object % conn metadata idx) a))))

  PGpoint
  (from-sql-type [d & _] (geom/clj-vec d))

  PGcircle
  (from-sql-type [d & _] (geom/clj-vec d))

  PGbox
  (from-sql-type [d & _] (geom/clj-vec d))

  PGbox
  (from-sql-type [d & _] (geom/clj-vec d))

  PGline
  (from-sql-type [d & _] (geom/clj-vec d))

  PGlseg
  (from-sql-type [d & _] (geom/clj-vec d))

  PGpath
  (from-sql-type [d & _] (geom/clj-vec d))

  PGpolygon
  (from-sql-type [d & _] (geom/clj-vec d))

  PGgeometryLW
  (from-sql-type [d & _] (gis/clj-vec d))

  PGgeometry
  (from-sql-type [d & _] (gis/clj-vec d))

  java.lang.Long
  (from-sql-type [d conn metadata idx]
    d)

  UUID
  (from-sql-type [d & _] d)

  PGobject
  (from-sql-type [d conn metadata idx]
    (read-pg-object d conn metadata idx)))

(extend-protocol jdbc.proto/ISQLType

  clojure.lang.PersistentVector
  (set-stmt-parameter! [this conn stmt index]
    (->> (jdbc.proto/as-sql-type this conn)
         (.setArray stmt index)))
  (as-sql-type [this conn]
    (let [vec-as-array (into-array this)
          boolean?     #(instance? Boolean %)
          pg-type      (condp #(%1 %2) (first vec-as-array)
                         integer?  "integer"
                         float?    "float"
                         number?   "numeric"
                         boolean?  "boolean"
                         string?   "text"
                         char?     "char"
                         "text")]
      (.createArrayOf conn pg-type vec-as-array)))

  clojure.lang.Ratio
  (set-stmt-parameter! [this conn stmt index]
    (.setObject stmt index (jdbc.proto/as-sql-type this conn)))
  (as-sql-type [this conn]
    (let [n (numerator this)
          d (denominator this)
          s (format "(%s, %s)" n d)]
      (doto (PGobject.)
        (.setType "ratio")
        (.setValue s)))))
