(ns tusk.tusk-core.types.uuid
  (:import
   [java.util
    UUID]))

(defn uuid
  "get a uuid.
  With no arguments, a random uuid is returned
  A single argument can be a string or UUID with a UUID returned
  or nil if the string was invalid"
  ([]
   (UUID/randomUUID))
  ([u]
   (if (uuid? u)
     u
     (try
       (UUID/fromString u)
       (catch Exception _)))))
