(ns tusk.types.enum
  (:refer-clojure :exclude [> >= < <=])
  (:require
   [clojure.core :as clj])
  ;; (:import )
  )

(defn ^:private
  enum-compare
  [pred]
  (fn [m k1 k2]
     (pred (k1 m) (k2 m))))

(def after
  (enum-compare clj/>))

(def before
  (enum-compare clj/>=))

(def <
  (enum-compare clj/<))

(def <=
  (enum-compare clj/<=))
