/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.twosigma.cook.jobclient.Group;
import com.twosigma.cook.jobclient.GroupListener;
import com.twosigma.cook.jobclient.InstanceDecorator;
import com.twosigma.cook.jobclient.Job;
import com.twosigma.cook.jobclient.JobClientException;
import com.twosigma.cook.jobclient.JobClientInterface;
import com.twosigma.cook.jobclient.JobListener;
import com.twosigma.cook.jobclient.auth.spnego.BasicSPNegoSchemeFactory;
import com.twosigma.cook.jobclient.auth.spnego.GSSCredentialProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class JobClient
implements Closeable,
JobClientInterface {
    private static final Logger _log = Logger.getLogger(JobClient.class);
    protected static final String COOK_IMPERSONATE_HEADER = "X-Cook-Impersonate";
    private final URI _jobURI;
    private final URI _groupURI;
    private final CloseableHttpClient _httpClient;
    private final ScheduledExecutorService _listenerService;
    private final Map<UUID, Job> _activeUUIDToJob;
    private final Map<UUID, JobListener> _jobUUIDToListener;
    private final Map<UUID, Group> _activeUUIDToGroup;
    private final Map<UUID, GroupListener> _groupUUIDToListener;
    private int _batchRequestSize;
    private int _statusUpdateInterval;
    private int _submitRetryInterval;
    private InstanceDecorator _instanceDecorator;

    private JobClient(String host, int port, String jobEndpoint, String groupEndpoint, int statusUpdateInterval, int submitRetryInterval, int batchSubmissionLimit, InstanceDecorator instanceDecorator, CloseableHttpClient httpClient) throws URISyntaxException {
        this._statusUpdateInterval = statusUpdateInterval;
        this._submitRetryInterval = submitRetryInterval;
        this._batchRequestSize = batchSubmissionLimit;
        this._activeUUIDToJob = new ConcurrentHashMap<UUID, Job>();
        this._jobUUIDToListener = new ConcurrentHashMap<UUID, JobListener>();
        this._activeUUIDToGroup = new ConcurrentHashMap<UUID, Group>();
        this._groupUUIDToListener = new ConcurrentHashMap<UUID, GroupListener>();
        this._jobURI = new URIBuilder().setScheme("http").setHost(host).setPort(port).setPath(jobEndpoint).build();
        this._groupURI = groupEndpoint != null ? new URIBuilder().setScheme("http").setHost(host).setPort(port).setPath(groupEndpoint).build() : null;
        this._httpClient = httpClient;
        _log.info((Object)"Open ScheduledExecutorService for listener.");
        this._listenerService = this.startListenService();
        this._instanceDecorator = instanceDecorator;
    }

    @Override
    public void close() {
        _log.info((Object)"Close ScheduledExecutorService for listener.");
        this._listenerService.shutdownNow();
    }

    private ScheduledExecutorService startListenService() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                _log.error((Object)"Can not handle exception for listener service.", e);
            }
        }).build());
        scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Object listener;
                if (!JobClient.this._jobUUIDToListener.isEmpty()) {
                    Map<UUID, Job> currentUUIDToJob;
                    try {
                        currentUUIDToJob = JobClient.this.queryJobs(JobClient.this._activeUUIDToJob.keySet());
                    }
                    catch (JobClientException e) {
                        _log.warn((Object)("Failed to query job status for jobs " + JobClient.this._activeUUIDToJob.keySet()), (Throwable)e);
                        return;
                    }
                    for (Map.Entry<UUID, Job> entry : currentUUIDToJob.entrySet()) {
                        UUID juuid = entry.getKey();
                        Job currentJob = entry.getValue();
                        if (((Job)JobClient.this._activeUUIDToJob.get(juuid)).equals(currentJob)) continue;
                        listener = (JobListener)JobClient.this._jobUUIDToListener.get(juuid);
                        if (listener != null) {
                            try {
                                listener.onStatusUpdate(currentJob);
                            }
                            catch (Exception e) {
                                _log.warn((Object)("Failed to invoke listener onStatusUpdate() for " + currentJob + ". The listener service won't deliver this message again."), (Throwable)e);
                            }
                        }
                        if (currentJob.getStatus() != Job.Status.COMPLETED) {
                            JobClient.this._activeUUIDToJob.put(juuid, currentJob);
                            continue;
                        }
                        JobClient.this._activeUUIDToJob.remove(juuid);
                        JobClient.this._jobUUIDToListener.remove(juuid);
                    }
                }
                if (!JobClient.this._groupUUIDToListener.isEmpty()) {
                    Map<UUID, Group> currentUUIDToGroup;
                    try {
                        currentUUIDToGroup = JobClient.this.queryGroups(JobClient.this._activeUUIDToGroup.keySet());
                    }
                    catch (JobClientException e) {
                        _log.warn((Object)("Failed to query group status for groups " + JobClient.this._activeUUIDToGroup.keySet()), (Throwable)e);
                        return;
                    }
                    for (Map.Entry<UUID, Group> entry : currentUUIDToGroup.entrySet()) {
                        UUID guuid = entry.getKey();
                        Group currentGroup = entry.getValue();
                        if (((Group)JobClient.this._activeUUIDToGroup.get(guuid)).equals(currentGroup)) continue;
                        listener = (GroupListener)JobClient.this._groupUUIDToListener.get(guuid);
                        if (listener != null) {
                            try {
                                listener.onStatusUpdate(currentGroup);
                            }
                            catch (Exception e) {
                                _log.warn((Object)("Failed to invoke listener onStatusUpdate() for " + currentGroup + ". The listener service won't deliver this message again."), (Throwable)e);
                            }
                        }
                        if (currentGroup.getStatus() != Group.Status.COMPLETED) {
                            JobClient.this._activeUUIDToGroup.put(guuid, currentGroup);
                            continue;
                        }
                        JobClient.this._activeUUIDToGroup.remove(guuid);
                        JobClient.this._groupUUIDToListener.remove(guuid);
                    }
                }
            }
        }, this._statusUpdateInterval, this._statusUpdateInterval, TimeUnit.SECONDS);
        return scheduledExecutorService;
    }

    @Override
    public void submit(List<Job> jobs, JobListener listener) throws JobClientException {
        this.submit(jobs, listener, null);
    }

    @Override
    public void submitWithGroups(List<Job> jobs, List<Group> groups) throws JobClientException {
        this.submitWithGroups(jobs, groups, null, null);
    }

    private void submitWithGroups(List<Job> jobs, List<Group> groups, GroupListener listener, String impersonatedUser) throws JobClientException {
        HttpResponse httpResponse;
        if (listener != null) {
            for (Group group : groups) {
                this._groupUUIDToListener.put(group.getUUID(), listener);
            }
        }
        JSONObject json = new JSONObject();
        try {
            JSONObject groupsJSON = Group.jsonizeGroups(groups);
            JSONObject jobsJSON = Job.jsonizeJob(jobs);
            json.put("groups", (Object)groupsJSON.getJSONArray("groups"));
            json.put("jobs", (Object)jobsJSON.getJSONArray("jobs"));
        }
        catch (JSONException e) {
            throw new JobClientException("Can not jsonize jobs or groups to submit.", e);
        }
        HttpPost httpRequest = JobClient.makeHttpPost(this._jobURI, json, impersonatedUser);
        try {
            httpResponse = this.executeWithRetries((HttpRequestBase)httpRequest, 5, 10L);
        }
        catch (IOException e) {
            throw this.releaseAndCreateException((HttpRequestBase)httpRequest, null, "Can not submit POST request " + json + " via uri " + this._jobURI, e);
        }
        StatusLine statusLine = httpResponse.getStatusLine();
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            throw this.releaseAndCreateException((HttpRequestBase)httpRequest, null, "The response entity is null!", null);
        }
        String response = null;
        try {
            response = EntityUtils.toString((HttpEntity)entity);
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException | ParseException e) {
            throw this.releaseAndCreateException((HttpRequestBase)httpRequest, null, "Can not parse the response for POST request " + json + " via uri " + this._jobURI, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Response String for submitting jobs and groups" + json.toString() + " is " + response));
        }
        boolean isSuccess = false;
        if (null != statusLine && statusLine.getStatusCode() == 201) {
            isSuccess = true;
            _log.info((Object)("Successfully execute POST request with data " + json + " via uri " + this._jobURI));
        } else if (null != statusLine && statusLine.getStatusCode() >= 400) {
            Pattern patternUUID = Pattern.compile("([a-f0-9]{8}-[a-f0-9]{4}-4[a-f0-9]{3}-[89aAbB][a-f0-9]{3}-[a-f0-9]{12} already used)");
            Matcher matchUUID = patternUUID.matcher(response);
            if (matchUUID.find()) {
                _log.info((Object)("Successfully execute POST request with several retries " + json + " via uri " + this._jobURI));
                isSuccess = true;
            } else {
                _log.warn((Object)("Failed to execute POST request with several retries " + json + " via uri " + this._jobURI));
            }
        }
        if (null != httpRequest) {
            httpRequest.releaseConnection();
        }
        if (isSuccess) {
            for (Job job : jobs) {
                this._activeUUIDToJob.put(job.getUUID(), job);
            }
            for (Group group : groups) {
                this._activeUUIDToGroup.put(group.getUUID(), group);
            }
        } else {
            _log.error((Object)("Failed to submit jobs " + json.toString()));
            throw this.releaseAndCreateException((HttpRequestBase)httpRequest, httpResponse, "The response of POST request " + json + " via uri " + this._jobURI + ": " + statusLine.getReasonPhrase() + ", " + statusLine.getStatusCode() + " Body is " + response, null);
        }
    }

    @Override
    public void submitWithGroups(List<Job> jobs, List<Group> groups, GroupListener listener) throws JobClientException {
        this.submitWithGroups(jobs, groups, listener, null);
    }

    private JobClientException releaseAndCreateException(HttpRequestBase httpRequest, HttpResponse httpResponse, String msg, Throwable cause) {
        StringBuilder newMsg = new StringBuilder(msg);
        if (null != httpRequest) {
            httpRequest.releaseConnection();
        }
        if (null != httpResponse) {
            try {
                newMsg.append(" Response body: " + EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null != cause) {
            return new JobClientException(newMsg.toString(), cause);
        }
        return new JobClientException(newMsg.toString());
    }

    private JobClientException groupEndpointMissingException(String msg) {
        return new JobClientException(msg);
    }

    public static HttpPost makeHttpPost(URI uri, JSONObject params) {
        return JobClient.makeHttpPost(uri, params, null);
    }

    private static <R extends HttpRequestBase> R addImpersonation(R request, String impersonatedUser) {
        if (impersonatedUser != null) {
            request.addHeader(COOK_IMPERSONATE_HEADER, impersonatedUser);
        }
        return request;
    }

    private static HttpPost makeHttpPost(URI uri, JSONObject params, String impersonatedUser) {
        try {
            StringEntity input = new StringEntity(params.toString());
            input.setContentType("application/json");
            HttpPost request = new HttpPost(uri);
            request.setEntity((HttpEntity)input);
            JobClient.addImpersonation(request, impersonatedUser);
            return request;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void submit(List<Job> jobs) throws JobClientException {
        this.submit(jobs, null, null);
    }

    private void submit(List<Job> jobs, JobListener listener, String impersonatedUser) throws JobClientException {
        boolean isSuccess;
        String response;
        StatusLine statusLine;
        HttpPost httpRequest;
        JSONObject json;
        block28: {
            HttpResponse httpResponse;
            if (listener != null) {
                for (Job job : jobs) {
                    this._jobUUIDToListener.put(job.getUUID(), listener);
                }
            }
            try {
                json = Job.jsonizeJob(jobs);
            }
            catch (JSONException e) {
                throw new JobClientException("Can not jsonize jobs to submit.", e);
            }
            httpRequest = JobClient.makeHttpPost(this._jobURI, json, impersonatedUser);
            try {
                httpResponse = this.executeWithRetries((HttpRequestBase)httpRequest, 5, this._submitRetryInterval);
            }
            catch (IOException e) {
                throw this.releaseAndCreateException((HttpRequestBase)httpRequest, null, "Can not submit POST request " + json + " via uri " + this._jobURI, e);
            }
            statusLine = httpResponse.getStatusLine();
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) {
                throw this.releaseAndCreateException((HttpRequestBase)httpRequest, null, "The response entity is null!", null);
            }
            response = null;
            try {
                response = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException | ParseException e) {
                throw this.releaseAndCreateException((HttpRequestBase)httpRequest, null, "Can not parse the response for POST request " + json + " via uri " + this._jobURI, e);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response String for submitting jobs" + json.toString() + " is " + response));
            }
            isSuccess = false;
            if (null != statusLine && statusLine.getStatusCode() == 201) {
                isSuccess = true;
                _log.info((Object)("Successfully execute POST request with data " + json + " via uri " + this._jobURI));
            } else if (null != statusLine && statusLine.getStatusCode() >= 500) {
                String transactionTimeoutMessage = "Transaction timed out.";
                if (String.valueOf(response).contains("Transaction timed out.")) {
                    _log.warn((Object)("POST experienced transaction timeout via uri " + this._jobURI));
                    HashSet<UUID> jobUuids = new HashSet<UUID>();
                    for (Job job : jobs) {
                        jobUuids.add(job.getUUID());
                    }
                    _log.info((Object)("Sleeping " + this._submitRetryInterval + " secs to allow transaction opportunity to complete"));
                    try {
                        Thread.sleep(this._submitRetryInterval * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    _log.info((Object)"Verifying whether all the jobs were created despite the transaction timeout message");
                    try {
                        Map<UUID, Job> uuidToJob = this.queryJobs(jobUuids);
                        if (uuidToJob.size() == jobUuids.size()) {
                            _log.info((Object)("All " + uuidToJob.size() + " jobs were created despite the transaction timeout message"));
                            isSuccess = true;
                            break block28;
                        }
                        _log.warn((Object)("POST failed: " + uuidToJob.size() + " of " + jobUuids.size() + " jobs were created in the timed out transaction"));
                    }
                    catch (Exception ex) {
                        _log.error((Object)("POST failed: all queried jobs were not found: " + ex.getMessage()));
                    }
                }
            } else if (null != statusLine && statusLine.getStatusCode() >= 400) {
                Pattern patternUUID = Pattern.compile("[a-f0-9]{8}-[a-f0-9]{4}-4[a-f0-9]{3}-[89aAbB][a-f0-9]{3}-[a-f0-9]{12} already used");
                Matcher matchUUID = patternUUID.matcher(response);
                if (matchUUID.find()) {
                    _log.info((Object)("Successfully execute POST request with several retries " + json + " via uri " + this._jobURI));
                    isSuccess = true;
                } else {
                    _log.warn((Object)("Failed to execute POST request with several retries " + json + " via uri " + this._jobURI));
                }
            }
        }
        if (null != httpRequest) {
            httpRequest.releaseConnection();
        }
        if (isSuccess) {
            for (Job job : jobs) {
                this._activeUUIDToJob.put(job.getUUID(), job);
            }
        } else {
            _log.error((Object)("Failed to submit jobs " + json.toString()));
            throw new JobClientException("The response of POST request " + json + " via uri " + this._jobURI + ": " + statusLine.getReasonPhrase() + ", " + statusLine.getStatusCode() + ", response is: " + response);
        }
    }

    @Override
    public Map<UUID, Job> queryJobs(Collection<UUID> uuids) throws JobClientException {
        ArrayList<BasicNameValuePair> allParams = new ArrayList<BasicNameValuePair>(uuids.size());
        for (UUID uuid : uuids) {
            allParams.add(new BasicNameValuePair("job", uuid.toString()));
        }
        ImmutableMap.Builder UUIDToJob = ImmutableMap.builder();
        for (List params : Lists.partition(allParams, (int)this._batchRequestSize)) {
            CloseableHttpResponse httpResponse;
            HttpGet httpRequest;
            try {
                URIBuilder uriBuilder = new URIBuilder(this._jobURI);
                uriBuilder.addParameters(params);
                httpRequest = new HttpGet(uriBuilder.build());
                httpResponse = this._httpClient.execute((HttpUriRequest)httpRequest);
            }
            catch (IOException | URISyntaxException e) {
                throw this.releaseAndCreateException(null, null, "Can not submit GET request " + params + " via uri " + this._jobURI, e);
            }
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw this.releaseAndCreateException((HttpRequestBase)httpRequest, (HttpResponse)httpResponse, "The response of GET request " + params + " via uri " + this._jobURI + ": " + statusLine.getReasonPhrase() + ", " + statusLine.getStatusCode(), null);
            }
            String response = null;
            try {
                HttpEntity entity = httpResponse.getEntity();
                response = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
                for (Job job : Job.parseFromJSON(response, this._instanceDecorator)) {
                    UUIDToJob.put((Object)job.getUUID(), (Object)job);
                }
            }
            catch (IOException | ParseException | JSONException e) {
                throw new JobClientException("Can not parse the response = " + response + " for GET request " + params + " via uri " + this._jobURI, e);
            }
            finally {
                httpRequest.releaseConnection();
            }
        }
        return UUIDToJob.build();
    }

    public Map<UUID, Job> query(Collection<UUID> uuids) throws JobClientException {
        return this.queryJobs(uuids);
    }

    @Override
    public Map<UUID, Job> queryGroupJobs(Group group) throws JobClientException {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (UUID juuid : group.getJobs()) {
            uuids.add(juuid);
        }
        return this.queryJobs(uuids);
    }

    @Override
    public Group queryGroup(UUID guuid) throws JobClientException {
        Group result;
        CloseableHttpResponse httpResponse;
        HttpGet httpRequest;
        if (this._groupURI == null) {
            throw this.groupEndpointMissingException("Cannot query groups if the jobclient's group endpoint is null");
        }
        ArrayList<BasicNameValuePair> allParams = new ArrayList<BasicNameValuePair>();
        allParams.add(new BasicNameValuePair("detailed", "true"));
        allParams.add(new BasicNameValuePair("uuid", guuid.toString()));
        try {
            URIBuilder uriBuilder = new URIBuilder(this._groupURI);
            uriBuilder.addParameters(allParams);
            httpRequest = new HttpGet(uriBuilder.build());
            httpResponse = this._httpClient.execute((HttpUriRequest)httpRequest);
        }
        catch (IOException | URISyntaxException e) {
            throw this.releaseAndCreateException(null, null, "Can not submit GET request " + allParams + " via uri " + this._jobURI, e);
        }
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw this.releaseAndCreateException((HttpRequestBase)httpRequest, (HttpResponse)httpResponse, "The response of GET request " + allParams + " via uri " + this._jobURI + ": " + statusLine.getReasonPhrase() + ", " + statusLine.getStatusCode(), null);
        }
        String response = null;
        try {
            HttpEntity entity = httpResponse.getEntity();
            response = EntityUtils.toString((HttpEntity)entity);
            EntityUtils.consume((HttpEntity)entity);
            result = Group.parseFromJSON(response, this._instanceDecorator).get(0);
        }
        catch (IOException | IndexOutOfBoundsException | ParseException | JSONException e) {
            throw new JobClientException("Can not parse the response = " + response + " for GET request " + allParams + " via uri " + this._jobURI, e);
        }
        finally {
            httpRequest.releaseConnection();
        }
        return result;
    }

    @Override
    public Map<UUID, Group> queryGroups(Collection<UUID> guuids) throws JobClientException {
        if (this._groupURI == null) {
            throw this.groupEndpointMissingException("Cannot query groups if the jobclient's group endpoint is null");
        }
        ArrayList<BasicNameValuePair> allParams = new ArrayList<BasicNameValuePair>(guuids.size());
        for (UUID guuid : guuids) {
            allParams.add(new BasicNameValuePair("uuid", guuid.toString()));
        }
        allParams.add(new BasicNameValuePair("detailed", "true"));
        ImmutableMap.Builder UUIDToGroup = ImmutableMap.builder();
        for (List params : Lists.partition(allParams, (int)this._batchRequestSize)) {
            CloseableHttpResponse httpResponse;
            HttpGet httpRequest;
            try {
                URIBuilder uriBuilder = new URIBuilder(this._groupURI);
                uriBuilder.addParameters(params);
                httpRequest = new HttpGet(uriBuilder.build());
                httpResponse = this._httpClient.execute((HttpUriRequest)httpRequest);
            }
            catch (IOException | URISyntaxException e) {
                throw this.releaseAndCreateException(null, null, "Can not submit GET request " + params + " via uri " + this._jobURI, e);
            }
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw this.releaseAndCreateException((HttpRequestBase)httpRequest, (HttpResponse)httpResponse, "The response of GET request " + params + " via uri " + this._jobURI + ": " + statusLine.getReasonPhrase() + ", " + statusLine.getStatusCode(), null);
            }
            String response = null;
            try {
                HttpEntity entity = httpResponse.getEntity();
                response = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
                for (Group group : Group.parseFromJSON(response, this._instanceDecorator)) {
                    UUIDToGroup.put((Object)group.getUUID(), (Object)group);
                }
            }
            catch (IOException | ParseException | JSONException e) {
                throw new JobClientException("Can not parse the response = " + response + " for GET request " + params + " via uri " + this._jobURI, e);
            }
            finally {
                httpRequest.releaseConnection();
            }
        }
        return UUIDToGroup.build();
    }

    @Override
    public void abort(Collection<UUID> uuids) throws JobClientException {
        this.abort(uuids, null);
    }

    private void abort(Collection<UUID> uuids, String impersonatedUser) throws JobClientException {
        ArrayList<BasicNameValuePair> allParams = new ArrayList<BasicNameValuePair>(uuids.size());
        for (UUID uuid : uuids) {
            allParams.add(new BasicNameValuePair("job", uuid.toString()));
        }
        for (List params : Lists.partition(allParams, (int)this._batchRequestSize)) {
            HttpResponse httpResponse;
            HttpDelete httpRequest;
            try {
                URIBuilder uriBuilder = new URIBuilder(this._jobURI);
                uriBuilder.addParameters(params);
                httpRequest = new HttpDelete(uriBuilder.build());
                JobClient.addImpersonation(httpRequest, impersonatedUser);
            }
            catch (URISyntaxException e) {
                throw this.releaseAndCreateException(null, null, "Can not submit DELETE request " + params + " via uri " + this._jobURI, e);
            }
            try {
                httpResponse = this.executeWithRetries((HttpRequestBase)httpRequest, 5, 10L);
            }
            catch (IOException e) {
                throw this.releaseAndCreateException((HttpRequestBase)httpRequest, null, "Can not submit DELETE request " + params + " via uri " + this._jobURI, e);
            }
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 204) {
                throw this.releaseAndCreateException((HttpRequestBase)httpRequest, httpResponse, "The response of DELETE request " + params + " via uri " + this._jobURI + ": " + statusLine.getReasonPhrase() + ", " + statusLine.getStatusCode(), null);
            }
            try {
                HttpEntity entity = httpResponse.getEntity();
                if (null == entity) continue;
                String response = EntityUtils.toString((HttpEntity)entity);
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Response String for aborting jobs " + uuids + " is " + response));
            }
            catch (IOException | ParseException e) {
                throw new JobClientException("Can not parse the response for DELETE request " + params + " via uri " + this._jobURI, e);
            }
            finally {
                httpRequest.releaseConnection();
            }
        }
    }

    public HttpResponse executeWithRetries(HttpRequestBase request, int maxRetries, long baseIntervalSeconds) throws IOException {
        Preconditions.checkArgument((maxRetries > 0 ? 1 : 0) != 0, (Object)"maxRetries must be > 1");
        Preconditions.checkArgument((baseIntervalSeconds > 0L ? 1 : 0) != 0, (Object)"baseIntervalSeconds must be > 0");
        CloseableHttpResponse response = null;
        IOException exception = null;
        long sleepMillis = TimeUnit.SECONDS.toMillis(baseIntervalSeconds);
        for (int i = 0; i < maxRetries; ++i) {
            try {
                response = this._httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                exception = e;
                response = null;
                try {
                    Thread.sleep(sleepMillis);
                    sleepMillis *= 2L;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (null == response) continue;
            return response;
        }
        throw new IOException(exception);
    }

    public String toString() {
        return "JobClient [_jobURI=" + this._jobURI + ", _httpClient=" + this._httpClient + ", _listenerService=" + this._listenerService + ", _activeUUIDToJob=" + this._activeUUIDToJob + ", _batchSubmissionLimit=" + this._batchRequestSize + ", _statusUpdateInterval=" + this._statusUpdateInterval + "]";
    }

    public JobClientInterface impersonating(String impersonatedUser) {
        return new ImpersonationProxy(impersonatedUser);
    }

    public static UUID makeTemporalUUID() {
        long millis = System.currentTimeMillis();
        long millisMasked = millis & 0xFFFFFFFFFFL;
        UUID baseUUID = UUID.randomUUID();
        long baseUUIDHighMasked = baseUUID.getMostSignificantBits() & 0xFFFFFFL;
        return new UUID(baseUUIDHighMasked | millisMasked << 24, baseUUID.getLeastSignificantBits());
    }

    private class ImpersonationProxy
    implements JobClientInterface {
        private final String _impersonatedUser;

        protected ImpersonationProxy(String impersonatedUser) {
            this._impersonatedUser = impersonatedUser;
        }

        @Override
        public void submit(List<Job> jobs, JobListener listener) throws JobClientException {
            JobClient.this.submit(jobs, listener, this._impersonatedUser);
        }

        @Override
        public void submitWithGroups(List<Job> jobs, List<Group> groups) throws JobClientException {
            JobClient.this.submitWithGroups(jobs, groups, null, this._impersonatedUser);
        }

        @Override
        public void submitWithGroups(List<Job> jobs, List<Group> groups, GroupListener listener) throws JobClientException {
            JobClient.this.submitWithGroups(jobs, groups, listener, this._impersonatedUser);
        }

        @Override
        public void submit(List<Job> jobs) throws JobClientException {
            JobClient.this.submit(jobs, null, this._impersonatedUser);
        }

        @Override
        public Map<UUID, Job> queryJobs(Collection<UUID> uuids) throws JobClientException {
            return JobClient.this.queryJobs(uuids);
        }

        @Override
        public Map<UUID, Job> queryGroupJobs(Group group) throws JobClientException {
            return JobClient.this.queryGroupJobs(group);
        }

        @Override
        public Group queryGroup(UUID guuid) throws JobClientException {
            return JobClient.this.queryGroup(guuid);
        }

        @Override
        public Map<UUID, Group> queryGroups(Collection<UUID> guuids) throws JobClientException {
            return JobClient.this.queryGroups(guuids);
        }

        @Override
        public void abort(Collection<UUID> uuids) throws JobClientException {
            JobClient.this.abort(uuids, this._impersonatedUser);
        }
    }

    public static class Builder {
        private String _host;
        private String _jobEndpoint;
        private String _groupEndpoint;
        private Integer _port;
        public static final int DEFAULT_STATUS_UPDATE_INTERVAL_SECONDS = 10;
        public static final int DEFAULT_BATCH_REQUEST_SIZE = 32;
        public static final int DEFAULT_REQUEST_TIMEOUT_SECONDS = 60;
        public static final int DEFAULT_SUBMIT_RETRY_INTERVAL_SECONDS = 10;
        private Integer _statusUpdateIntervalSeconds;
        private Integer _submitRetryIntervalSeconds;
        private Integer _batchRequestSize;
        private Integer _requestTimeoutSeconds;
        private HttpClientBuilder _httpClientBuilder = HttpClientBuilder.create();
        private InstanceDecorator _instanceDecorator;

        public JobClient build() throws URISyntaxException {
            if (this._statusUpdateIntervalSeconds == null) {
                this._statusUpdateIntervalSeconds = 10;
            }
            if (this._submitRetryIntervalSeconds == null) {
                this._submitRetryIntervalSeconds = 10;
            }
            if (this._batchRequestSize == null) {
                this._batchRequestSize = 32;
            }
            if (this._requestTimeoutSeconds == null) {
                this._requestTimeoutSeconds = 60;
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this._requestTimeoutSeconds * 1000).setConnectTimeout(this._requestTimeoutSeconds * 1000).setConnectionRequestTimeout(this._requestTimeoutSeconds * 1000).setStaleConnectionCheckEnabled(true).build();
            this._httpClientBuilder.setDefaultRequestConfig(requestConfig);
            this._httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler());
            return new JobClient((String)Preconditions.checkNotNull((Object)this._host, (Object)"host must be set"), (Integer)Preconditions.checkNotNull((Object)this._port, (Object)"port must be set"), (String)Preconditions.checkNotNull((Object)this._jobEndpoint, (Object)"jobEndpoint must be set"), this._groupEndpoint, this._statusUpdateIntervalSeconds, this._submitRetryIntervalSeconds, this._batchRequestSize, this._instanceDecorator, this._httpClientBuilder.build());
        }

        public Builder setUsernameAuth(String username, String password) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            this._httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            return this;
        }

        public Builder setKerberosAuth() {
            return this.setKerberosAuth((GSSCredentialProvider)null);
        }

        public Builder setKerberosAuth(AuthSchemeProvider authSchemaProvider) {
            Credentials creds = new Credentials(){

                public String getPassword() {
                    return null;
                }

                public Principal getUserPrincipal() {
                    return null;
                }
            };
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this._host, this._port.intValue(), AuthScope.ANY_REALM, "negotiate"), creds);
            this._httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            this._httpClientBuilder.setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("negotiate", (Object)authSchemaProvider).build());
            return this;
        }

        public Builder setKerberosAuth(GSSCredentialProvider gssCredentialProvider) {
            return this.setKerberosAuth((AuthSchemeProvider)BasicSPNegoSchemeFactory.build(true, gssCredentialProvider));
        }

        public Builder setHost(String host) {
            Preconditions.checkNotNull((Object)host, (Object)"host can not be null!");
            this._host = host;
            return this;
        }

        public String getHost() {
            return this._host;
        }

        public Builder setPort(int port) {
            Preconditions.checkNotNull((Object)port, (Object)"port can not be null!");
            this._port = port;
            return this;
        }

        public Integer getPort() {
            return this._port;
        }

        public Builder setEndpoint(String jobEndpoint) {
            return this.setJobEndpoint(jobEndpoint);
        }

        public Builder setJobEndpoint(String jobEndpoint) {
            this._jobEndpoint = !jobEndpoint.startsWith("/") ? "/" + jobEndpoint : jobEndpoint;
            return this;
        }

        public Builder setGroupEndpoint(String groupEndpoint) {
            this._groupEndpoint = !groupEndpoint.startsWith("/") ? "/" + groupEndpoint : groupEndpoint;
            return this;
        }

        public String getEndpoint() {
            return this._jobEndpoint;
        }

        public String getJobEndpoint() {
            return this._jobEndpoint;
        }

        public String getGroupEndpoint() {
            return this._groupEndpoint;
        }

        public Builder setStatusUpdateInterval(int intervalSeconds) {
            this._statusUpdateIntervalSeconds = Math.max(intervalSeconds, 10);
            _log.info((Object)("The status update interval in seconds is " + this._statusUpdateIntervalSeconds));
            return this;
        }

        public Integer getStatusUpdateInterval() {
            return this._statusUpdateIntervalSeconds;
        }

        public Integer getSubmitRetryInterval() {
            return this._submitRetryIntervalSeconds;
        }

        public Builder setSubmitRetryInterval(int submitRetryIntervalSeconds) {
            this._submitRetryIntervalSeconds = submitRetryIntervalSeconds;
            return this;
        }

        public Builder setBatchRequestSize(int batchRequestSize) {
            Preconditions.checkArgument((batchRequestSize > 0 ? 1 : 0) != 0, (Object)"The batch request size must be > 0.");
            this._batchRequestSize = batchRequestSize;
            return this;
        }

        public Integer getBatchRequestSize() {
            return this._batchRequestSize;
        }

        public Builder setRequestTimeout(int timeoutSeconds) {
            Preconditions.checkArgument((timeoutSeconds > 0 ? 1 : 0) != 0, (Object)"The timeout seconds must be > 0.");
            this._requestTimeoutSeconds = timeoutSeconds;
            return this;
        }

        public Integer getRequestTimeout() {
            return this._requestTimeoutSeconds;
        }

        public Builder setInstanceDecorator(InstanceDecorator decorator) {
            this._instanceDecorator = decorator;
            return this;
        }

        public InstanceDecorator getInstanceDecorator() {
            return this._instanceDecorator;
        }
    }
}

