/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.twosigma.cook.jobclient.Application;
import com.twosigma.cook.jobclient.Executor;
import com.twosigma.cook.jobclient.FetchableURI;
import com.twosigma.cook.jobclient.Group;
import com.twosigma.cook.jobclient.Instance;
import com.twosigma.cook.jobclient.InstanceDecorator;
import com.twosigma.cook.jobclient.JobClient;
import com.twosigma.cook.jobclient.constraint.Constraint;
import com.twosigma.cook.jobclient.constraint.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Job {
    private final UUID _uuid;
    private final String _name;
    private final String _command;
    private final Executor _executor;
    private final Double _memory;
    private final Double _cpus;
    private final Integer _retries;
    private final Long _maxRuntime;
    private final Long _expectedRuntime;
    private final Integer _priority;
    private final String _pool;
    private final Status _status;
    private final Boolean _isMeaCulpaRetriesDisabled;
    private final List<Instance> _instances;
    private final Map<String, String> _env;
    private final List<FetchableURI> _uris;
    private final JSONObject _container;
    private final Map<String, String> _labels;
    private final Set<Constraint> _constraints;
    private final List<UUID> _groups;
    private final Application _application;
    private final String _progressOutputFile;
    private final String _progressRegexString;
    private final String _user;
    private final JSONArray _datasets;

    private Job(UUID uuid, String name, String command, Executor executor, Double memory, Double cpus, Integer retries, Long maxRuntime, Long expectedRuntime, Status status, Integer priority, String pool, Boolean isMeaCulpaRetriesDisabled, List<Instance> instances, Map<String, String> env, List<FetchableURI> uris, JSONObject container, Map<String, String> labels, Set<Constraint> constraints, List<UUID> groups, Application application, String progressOutputFile, String progressRegexString, String user, JSONArray datasets) {
        this._uuid = uuid;
        this._name = name;
        this._command = command;
        this._executor = executor;
        this._memory = memory;
        this._cpus = cpus;
        this._retries = retries;
        this._maxRuntime = maxRuntime;
        this._expectedRuntime = expectedRuntime;
        this._status = status;
        this._priority = priority;
        this._pool = pool;
        this._isMeaCulpaRetriesDisabled = isMeaCulpaRetriesDisabled;
        this._instances = ImmutableList.copyOf(instances);
        this._env = ImmutableMap.copyOf(env);
        this._uris = ImmutableList.copyOf(uris);
        this._application = application;
        this._progressOutputFile = progressOutputFile;
        this._progressRegexString = progressRegexString;
        this._user = user;
        if (container != null) {
            try {
                this._container = new JSONObject(container.toString());
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to parse the container string", e);
            }
        } else {
            this._container = null;
        }
        if (datasets != null) {
            try {
                this._datasets = new JSONArray(datasets.toString());
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to parse datasets string", e);
            }
        } else {
            this._datasets = null;
        }
        this._labels = ImmutableMap.copyOf(labels);
        this._constraints = ImmutableSet.copyOf(constraints);
        this._groups = groups;
    }

    public UUID getUUID() {
        return this._uuid;
    }

    public String getCommand() {
        return this._command;
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public Double getMemory() {
        return this._memory;
    }

    public Double getCpus() {
        return this._cpus;
    }

    public Integer getRetries() {
        return this._retries;
    }

    public Long getMaxRuntime() {
        return this._maxRuntime;
    }

    public Long getExpectedRuntime() {
        return this._expectedRuntime;
    }

    public Map<String, String> getEnv() {
        return this._env;
    }

    public Map<String, String> getLabels() {
        return this._labels;
    }

    public Set<Constraint> getConstraints() {
        return this._constraints;
    }

    public UUID getGroup() {
        if (this._groups.size() > 0) {
            return this._groups.get(0);
        }
        return null;
    }

    public JSONObject getContainer() {
        return this._container;
    }

    public List<FetchableURI> getUris() {
        return this._uris;
    }

    public String getUser() {
        return this._user;
    }

    public Status getStatus() {
        return this._status;
    }

    public String getName() {
        return this._name;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public String getPool() {
        return this._pool;
    }

    public Boolean isMeaCulpaRetriesDisabled() {
        return this._isMeaCulpaRetriesDisabled;
    }

    public List<Instance> getInstances() {
        return this._instances;
    }

    public Application getApplication() {
        return this._application;
    }

    public String getProgressOutputFile() {
        return this._progressOutputFile;
    }

    public String getProgressRegexString() {
        return this._progressRegexString;
    }

    public JSONArray getDatasets() {
        return this._datasets;
    }

    public Instance getRunningInstance() {
        for (Instance instance : this._instances) {
            if (!Instance.Status.RUNNING.equals((Object)instance.getStatus())) continue;
            return instance;
        }
        return null;
    }

    public Boolean isSuccess() {
        if (this.getStatus() == Status.COMPLETED) {
            for (Instance instance : this.getInstances()) {
                if (instance.getStatus() != Instance.Status.SUCCESS) continue;
                return true;
            }
        }
        return false;
    }

    public static JSONObject jsonizeJob(Job job) throws JSONException {
        JSONObject env = new JSONObject(job.getEnv());
        JSONObject labels = new JSONObject(job.getLabels());
        JSONObject container = job.getContainer();
        JSONObject object = new JSONObject();
        object.put("uuid", (Object)job.getUUID().toString());
        object.put("name", (Object)job.getName());
        object.put("command", (Object)job.getCommand());
        if (job.getExecutor() != null) {
            object.put("executor", (Object)job.getExecutor().displayName());
        }
        object.put("mem", (Object)job.getMemory());
        object.put("cpus", (Object)job.getCpus());
        object.put("priority", (Object)job.getPriority());
        object.put("max_retries", (Object)job.getRetries());
        object.put("disable_mea_culpa_retries", (Object)job.isMeaCulpaRetriesDisabled());
        object.put("max_runtime", (Object)job.getMaxRuntime());
        object.put("env", (Object)env);
        object.put("labels", (Object)labels);
        UUID group = job.getGroup();
        if (group != null) {
            object.put("group", (Object)job.getGroup().toString());
        }
        for (Constraint constraint : job.getConstraints()) {
            object.append("constraints", (Object)constraint.toJson());
        }
        if (container != null) {
            object.put("container", (Object)container);
        }
        for (FetchableURI uri : job.getUris()) {
            object.append("uris", (Object)FetchableURI.jsonizeUri(uri));
        }
        if (job._application != null) {
            object.put("application", (Object)Application.jsonizeApplication(job._application));
        }
        if (job._progressOutputFile != null) {
            object.put("progress_output_file", (Object)job._progressOutputFile);
        }
        if (job._progressRegexString != null) {
            object.put("progress_regex_string", (Object)job._progressRegexString);
        }
        if (job._expectedRuntime != null) {
            object.put("expected_runtime", (Object)job._expectedRuntime);
        }
        if (job._datasets != null) {
            object.put("datasets", (Object)job._datasets);
        }
        return object;
    }

    public static JSONObject jsonizeJob(Collection<Job> jobs) throws JSONException {
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
        for (Job job : jobs) {
            objects.add(Job.jsonizeJob(job));
        }
        JSONObject object = new JSONObject();
        object.put("jobs", objects);
        return object;
    }

    public static List<Job> parseFromJSON(String listOfJobs, InstanceDecorator decorator) throws JSONException {
        JSONArray jsonArray = new JSONArray(listOfJobs);
        ArrayList<Job> jobs = new ArrayList<Job>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONArray groupsJson;
            JSONArray urisJson;
            JSONObject json = jsonArray.getJSONObject(i);
            Builder jobBuilder = new Builder();
            jobBuilder.setUUID(UUID.fromString(json.getString("uuid")));
            jobBuilder.setMemory(json.getDouble("mem"));
            jobBuilder.setCpus(json.getDouble("cpus"));
            jobBuilder.setCommand(json.getString("command"));
            if (json.has("executor")) {
                jobBuilder.setExecutor(json.getString("executor"));
            }
            jobBuilder.setPriority(json.getInt("priority"));
            jobBuilder.setStatus(Status.fromString(json.getString("status")));
            if (json.has("disable_mea_culpa_retries") && json.getBoolean("disable_mea_culpa_retries")) {
                jobBuilder.disableMeaCulpaRetries();
            } else {
                jobBuilder.enableMeaCulpaRetries();
            }
            if (json.has("name")) {
                jobBuilder.setName(json.getString("name"));
            }
            if (json.has("user")) {
                jobBuilder.setUser(json.getString("user"));
            }
            jobBuilder.setRetries(json.getInt("max_retries"));
            jobBuilder.setMaxRuntime(json.getLong("max_runtime"));
            if (json.has("container")) {
                jobBuilder.setContainer(json.getJSONObject("container"));
            }
            if (json.has("env")) {
                JSONObject envJson = json.getJSONObject("env");
                HashMap<String, String> envMap = new HashMap<String, String>();
                if (envJson.length() > 0) {
                    for (String varName : JSONObject.getNames((JSONObject)envJson)) {
                        envMap.put(varName, envJson.getString(varName));
                    }
                }
                jobBuilder.setEnv(envMap);
            }
            if (json.has("labels")) {
                JSONObject labelsJson = json.getJSONObject("labels");
                HashMap<String, String> labelsMap = new HashMap<String, String>();
                if (labelsJson.length() > 0) {
                    for (String varName : JSONObject.getNames((JSONObject)labelsJson)) {
                        labelsMap.put(varName, labelsJson.getString(varName));
                    }
                }
                jobBuilder.setLabels(labelsMap);
            }
            if ((urisJson = json.optJSONArray("uris")) != null) {
                for (int j = 0; j < urisJson.length(); ++j) {
                    jobBuilder.addUri(FetchableURI.parseFromJSON(urisJson.getJSONObject(j)));
                }
            }
            if (json.has("constraints")) {
                JSONArray constraintsJson = json.getJSONArray("constraints");
                for (int j = 0; j < constraintsJson.length(); ++j) {
                    jobBuilder.addConstraint(Constraints.parseFrom(constraintsJson.getJSONArray(j)));
                }
            }
            if ((groupsJson = json.optJSONArray("groups")) != null) {
                for (int j = 0; j < groupsJson.length(); ++j) {
                    jobBuilder._setGroupByUUID(UUID.fromString(groupsJson.getString(j)));
                }
            }
            jobBuilder.addInstances(Instance.parseFromJSON(json.getJSONArray("instances"), decorator));
            if (json.has("application")) {
                JSONObject applicationJson = json.getJSONObject("application");
                jobBuilder.setApplication(Application.parseFromJSON(applicationJson));
            }
            if (json.has("expected_runtime")) {
                jobBuilder.setExpectedRuntime(json.getLong("expected_runtime"));
            }
            if (json.has("progress_output_file")) {
                jobBuilder.setProgressOutputFile(json.getString("progress_output_file"));
            }
            if (json.has("progress_regex_string")) {
                jobBuilder.setProgressRegexString(json.getString("progress_regex_string"));
            }
            if (json.has("datasets")) {
                jobBuilder.setDatasets(json.getJSONArray("datasets"));
            }
            if (json.has("pool")) {
                jobBuilder.setPool(json.getString("pool"));
            }
            jobs.add(jobBuilder.build());
        }
        return jobs;
    }

    public static List<Job> parseFromJSON(String listOfJobs) throws JSONException {
        return Job.parseFromJSON(listOfJobs, null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("Job [_uuid=" + this._uuid + ", _name=" + this._name + ", _command=" + this._command + ", _executor=" + (Object)((Object)this._executor) + ", _memory=" + this._memory + ", _cpus=" + this._cpus + ", _retries=" + this._retries + ", _maxRuntime=" + this._maxRuntime + ", _status=" + (Object)((Object)this._status) + ", _priority=" + this._priority + ", _pool=" + this._pool + ", _progressOutputFile=" + this._progressOutputFile + ", _progressRegexString=" + this._progressRegexString + ", _isMeaCulpaRetriesDisabled=" + this._isMeaCulpaRetriesDisabled + ", _user=" + this._user + "]");
        stringBuilder.append('\n');
        for (Instance instance : this.getInstances()) {
            stringBuilder.append(instance.toString()).append('\n');
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._status == null ? 0 : this._status.hashCode());
        result = 31 * result + (this._uuid == null ? 0 : this._uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Job other = (Job)obj;
        if (this._status != other._status) {
            return false;
        }
        return !(this._uuid == null ? other._uuid != null : !this._uuid.equals(other._uuid));
    }

    public static class Builder {
        private UUID _uuid;
        private String _name;
        private String _command;
        private Executor _executor;
        private Double _memory;
        private Double _cpus;
        private Integer _retries;
        private Long _maxRuntime;
        private Long _expectedRuntime;
        private Status _status;
        private Integer _priority;
        private String _pool;
        private Boolean _isMeaCulpaRetriesDisabled;
        private List<Instance> _instances = Collections.synchronizedList(new ArrayList());
        private List<FetchableURI> _uris = new ArrayList<FetchableURI>();
        private Map<String, String> _env = new HashMap<String, String>();
        private JSONObject _container;
        private Map<String, String> _labels = new HashMap<String, String>();
        private List<UUID> _groups = new ArrayList<UUID>();
        private Set<Constraint> _constraints = new LinkedHashSet<Constraint>();
        private Application _application;
        private String _progressOutputFile;
        private String _progressRegexString;
        private String _user;
        private JSONArray _datasets;

        public Job build() {
            Preconditions.checkNotNull((Object)this._command, (Object)"command must be set!");
            Preconditions.checkNotNull((Object)this._memory, (Object)"memory must be set!");
            Preconditions.checkNotNull((Object)this._cpus, (Object)"cpus must be set!");
            if (this._uuid == null) {
                this._uuid = JobClient.makeTemporalUUID();
            }
            if (this._retries == null) {
                this._retries = 5;
            }
            if (this._maxRuntime == null) {
                this._maxRuntime = Long.MAX_VALUE;
            }
            if (this._priority == null) {
                this._priority = 50;
            }
            if (this._status == null) {
                this._status = Status.INITIALIZED;
            }
            if (this._name == null) {
                this._name = "cookjob";
            }
            if (this._isMeaCulpaRetriesDisabled == null) {
                this._isMeaCulpaRetriesDisabled = false;
            }
            return new Job(this._uuid, this._name, this._command, this._executor, this._memory, this._cpus, this._retries, this._maxRuntime, this._expectedRuntime, this._status, this._priority, this._pool, this._isMeaCulpaRetriesDisabled, this._instances, this._env, this._uris, this._container, this._labels, this._constraints, this._groups, this._application, this._progressOutputFile, this._progressRegexString, this._user, this._datasets);
        }

        public Builder of(Job job) {
            this.setCommand(job.getCommand());
            this.setExecutor(job.getExecutor());
            this.setMemory(job.getMemory());
            this.setCpus(job.getCpus());
            this.setRetries(job.getRetries());
            this.setMaxRuntime(job.getMaxRuntime());
            this.setEnv(job.getEnv());
            this.setUris(job.getUris());
            this.setContainer(job.getContainer());
            this.setPool(job.getPool());
            this.setLabels(job.getLabels());
            this.setDatasets(job.getDatasets());
            if (job.isMeaCulpaRetriesDisabled().booleanValue()) {
                this.disableMeaCulpaRetries();
            } else {
                this.enableMeaCulpaRetries();
            }
            return this;
        }

        public Builder addUri(FetchableURI uri) {
            this._uris.add(uri);
            return this;
        }

        public Builder addUris(Collection<FetchableURI> uris) {
            this._uris.addAll(uris);
            return this;
        }

        private Builder _setGroupByUUID(UUID guuid) {
            this._groups.clear();
            this._groups.add(guuid);
            return this;
        }

        public Builder setGroup(Group group) {
            this._setGroupByUUID(group.getUUID());
            return this;
        }

        public Builder addConstraint(Constraint constraint) {
            this._constraints.add(constraint);
            return this;
        }

        public Builder addConstraint(Collection constraints) {
            this._constraints.addAll(constraints);
            return this;
        }

        public Builder setUris(Collection<FetchableURI> uris) {
            this._uris.clear();
            this._uris.addAll(uris);
            return this;
        }

        public Builder addEnv(String name, String value) {
            this._env.put(name, value);
            return this;
        }

        public Builder addEnv(Map<String, String> environment) {
            this._env.putAll(environment);
            return this;
        }

        public Builder setEnv(Map<String, String> environment) {
            this._env = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder addLabel(String key, String value) {
            this._labels.put(key, value);
            return this;
        }

        public Builder addLabels(Map<String, String> labels) {
            this._labels.putAll(labels);
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this._labels = ImmutableMap.copyOf(labels);
            return this;
        }

        public Builder setUUID(UUID uuid) {
            this._uuid = uuid;
            return this;
        }

        public Builder setCommand(String command) {
            this._command = command;
            return this;
        }

        public Builder setExecutor(String executor) {
            return this.setExecutor(Executor.fromString(executor));
        }

        public Builder setExecutor(Executor executor) {
            this._executor = executor;
            return this;
        }

        public Builder setCpus(Double cpus) {
            this._cpus = cpus;
            return this;
        }

        public Builder setMemory(Double memory) {
            this._memory = memory;
            return this;
        }

        public Builder setContainer(JSONObject container) {
            this._container = container;
            return this;
        }

        public Builder setRetries(Integer retries) {
            Preconditions.checkArgument((retries > 0 ? 1 : 0) != 0, (Object)"The number of retries must be > 0.");
            this._retries = retries;
            return this;
        }

        public Builder disableMeaCulpaRetries() {
            this._isMeaCulpaRetriesDisabled = true;
            return this;
        }

        public Builder enableMeaCulpaRetries() {
            this._isMeaCulpaRetriesDisabled = false;
            return this;
        }

        public Builder setMaxRuntime(Long runtime) {
            Preconditions.checkArgument((runtime > 0L ? 1 : 0) != 0, (Object)"The max runtime in milliseconds must be > 0.");
            this._maxRuntime = runtime;
            return this;
        }

        public Builder setExpectedRuntime(long runtime) {
            Preconditions.checkArgument((runtime > 0L ? 1 : 0) != 0, (Object)"The expected runtime in milliseconds must be > 0.");
            this._expectedRuntime = runtime;
            return this;
        }

        public Builder setStatus(Status status) {
            this._status = status;
            return this;
        }

        public Builder setName(String name) {
            Pattern pattern = Pattern.compile("[\\.a-zA-Z0-9_-]{0,128}");
            Preconditions.checkArgument((boolean)pattern.matcher(name).matches(), (Object)"Name can only contain '.', '_', '-' or any work characters has length at most 128");
            this._name = name;
            return this;
        }

        public Builder setPriority(Integer priority) {
            this._priority = priority;
            return this;
        }

        private Builder setPool(String pool) {
            this._pool = pool;
            return this;
        }

        public Builder addInstance(Instance instance) {
            this._instances.add(instance);
            return this;
        }

        public Builder addInstances(List<Instance> instances) {
            this._instances.addAll(instances);
            return this;
        }

        public Builder setApplication(Application application) {
            this._application = application;
            return this;
        }

        public Builder setProgressOutputFile(String progressOutputFile) {
            this._progressOutputFile = progressOutputFile;
            return this;
        }

        public Builder setProgressRegexString(String progressRegexString) {
            this._progressRegexString = progressRegexString;
            return this;
        }

        public Builder setUser(String user) {
            this._user = user;
            return this;
        }

        public Builder setDatasets(JSONArray datasets) {
            this._datasets = datasets;
            return this;
        }
    }

    public static enum Status {
        INITIALIZED("INITIALIZED"),
        WAITING("WAITING"),
        RUNNING("RUNNING"),
        COMPLETED("COMPLETED");


        private Status(String name) {
        }

        public static Status fromString(String name) {
            return Enum.valueOf(Status.class, name.trim().toUpperCase());
        }
    }
}

