/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import com.google.common.collect.ImmutableList;
import com.twosigma.cook.jobclient.HostPlacement;
import com.twosigma.cook.jobclient.InstanceDecorator;
import com.twosigma.cook.jobclient.JobClient;
import com.twosigma.cook.jobclient.StragglerHandling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Group {
    private final UUID _uuid;
    private final Status _status;
    private final String _name;
    private final HostPlacement _hostPlacement;
    private final StragglerHandling _stragglerHandling;
    private final List<UUID> _jobs;

    private Group(UUID uuid, Status status, String name, HostPlacement hostPlacement, StragglerHandling stragglerHandling, List<UUID> jobs) {
        this._uuid = uuid;
        this._status = status;
        this._name = name;
        this._hostPlacement = hostPlacement;
        this._stragglerHandling = stragglerHandling;
        this._jobs = ImmutableList.copyOf(jobs);
    }

    public UUID getUUID() {
        return this._uuid;
    }

    public Status getStatus() {
        return this._status;
    }

    public String getName() {
        return this._name;
    }

    public HostPlacement getHostPlacement() {
        return this._hostPlacement;
    }

    public StragglerHandling getStragglerHandling() {
        return this._stragglerHandling;
    }

    public List<UUID> getJobs() {
        return this._jobs;
    }

    public static JSONObject jsonizeGroup(Group group) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("uuid", (Object)group.getUUID().toString());
        object.put("name", (Object)group.getName());
        object.put("host_placement", (Object)HostPlacement.jsonize(group.getHostPlacement()));
        object.put("straggler_handling", (Object)StragglerHandling.jsonize(group.getStragglerHandling()));
        return object;
    }

    public static JSONObject jsonizeGroups(Collection<Group> groups) throws JSONException {
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
        for (Group group : groups) {
            objects.add(Group.jsonizeGroup(group));
        }
        JSONObject object = new JSONObject();
        object.put("groups", objects);
        return object;
    }

    public static List<Group> parseFromJSON(String listOfGroups, InstanceDecorator decorator) throws JSONException {
        JSONArray jsonArray = new JSONArray(listOfGroups);
        ArrayList<Group> groups = new ArrayList<Group>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            JSONArray jobsJson = json.getJSONArray("jobs");
            Builder groupBuilder = new Builder();
            groupBuilder.setUUID(UUID.fromString(json.getString("uuid")));
            if (json.has("name")) {
                groupBuilder.setName(json.getString("name"));
            }
            for (int j = 0; j < jobsJson.length(); ++j) {
                groupBuilder._addJobByUUID(UUID.fromString(jobsJson.getString(j)));
            }
            groupBuilder.setHostPlacement(HostPlacement.parseFromJSON(json.getJSONObject("host_placement"), decorator));
            groupBuilder.setStragglerHandling(StragglerHandling.parseFromJSON(json.getJSONObject("straggler_handling"), decorator));
            if (json.isNull("completed")) {
                groupBuilder.setStatus(Status.INITIALIZED);
            } else if (json.getInt("completed") == jobsJson.length()) {
                groupBuilder.setStatus(Status.COMPLETED);
            } else if (json.getInt("waiting") == jobsJson.length()) {
                groupBuilder.setStatus(Status.WAITING);
            } else {
                groupBuilder.setStatus(Status.RUNNING);
            }
            groups.add(groupBuilder.build());
        }
        return groups;
    }

    public static List<Group> parseFromJSON(String listOfGroups) throws JSONException {
        return Group.parseFromJSON(listOfGroups, null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("Group [_uuid=" + this._uuid + ",_status=" + (Object)((Object)this._status) + ", _name=" + this._name + ", _hostPlacement=" + this._hostPlacement + ", _stragglerHandling=" + this._stragglerHandling + "]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._status == null ? 0 : this._status.hashCode());
        result = 31 * result + (this._uuid == null ? 0 : this._uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Group other = (Group)obj;
        if (this._status != other._status) {
            return false;
        }
        return !(this._uuid == null ? other._uuid != null : !this._uuid.equals(other._uuid));
    }

    public static class Builder {
        private UUID _uuid;
        private Status _status;
        private String _name;
        private HostPlacement _hostPlacement;
        private StragglerHandling _stragglerHandling;
        private List<UUID> _jobs = new ArrayList<UUID>();

        public Group build() {
            if (this._uuid == null) {
                this._uuid = JobClient.makeTemporalUUID();
            }
            if (this._status == null) {
                this._status = Status.INITIALIZED;
            }
            if (this._name == null) {
                this._name = "cookgroup";
            }
            if (this._hostPlacement == null) {
                HostPlacement.Builder hpBuilder = new HostPlacement.Builder();
                this._hostPlacement = hpBuilder.setType(HostPlacement.Type.ALL).build();
            }
            if (this._stragglerHandling == null) {
                this._stragglerHandling = new StragglerHandling.Builder().build();
            }
            return new Group(this._uuid, this._status, this._name, this._hostPlacement, this._stragglerHandling, this._jobs);
        }

        public Builder setUUID(UUID uuid) {
            this._uuid = uuid;
            return this;
        }

        public Builder setStatus(Status status) {
            this._status = status;
            return this;
        }

        public Builder setName(String name) {
            this._name = name;
            return this;
        }

        public Builder setHostPlacement(HostPlacement hostPlacement) {
            this._hostPlacement = hostPlacement;
            return this;
        }

        public Builder setStragglerHandling(StragglerHandling stragglerHandling) {
            this._stragglerHandling = stragglerHandling;
            return this;
        }

        private Builder _setJobs(List<UUID> juuids) {
            this._jobs = new ArrayList<UUID>(juuids);
            return this;
        }

        private Builder _addJobByUUID(UUID juuid) {
            this._jobs.add(juuid);
            return this;
        }
    }

    public static enum Status {
        INITIALIZED("INITIALIZED"),
        WAITING("WAITING"),
        RUNNING("RUNNING"),
        COMPLETED("COMPLETED");


        private Status(String name) {
        }

        public static Status fromString(String name) {
            return Enum.valueOf(Status.class, name.trim().toUpperCase());
        }
    }
}

