/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import org.json.JSONException;
import org.json.JSONObject;

public class Disk {
    private Double _request;
    private Double _limit;
    private String _type;

    public Disk() {
        this(null, null, null);
    }

    public Disk(Double request, Double limit, String type) {
        this._request = request;
        this._limit = limit;
        this._type = type;
    }

    public void setRequest(Double request) {
        this._request = request;
    }

    public void setLimit(Double limit) {
        this._limit = limit;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setType(DiskType type) {
        this.setType(type.toString());
    }

    public Double getRequest() {
        return this._request;
    }

    public Double getLimit() {
        return this._limit;
    }

    public String getType() {
        return this._type;
    }

    public boolean shouldIncludeInJSON() {
        return this._request != null || this._limit != null || this._type != null;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject object = new JSONObject();
        if (this._request != null) {
            object.put("request", (Object)this._request);
        }
        if (this._limit != null) {
            object.put("limit", (Object)this._limit);
        }
        if (this._type != null) {
            object.put("type", (Object)this._type);
        }
        return object;
    }

    public static Disk parseFromJSON(JSONObject object) throws JSONException {
        Disk newDisk = new Disk();
        if (object.has("request")) {
            Double request = object.getDouble("request");
            newDisk.setRequest(request);
        }
        if (object.has("limit")) {
            Double limit = object.getDouble("limit");
            newDisk.setLimit(limit);
        }
        if (object.has("type")) {
            String type = object.getString("type");
            newDisk.setType(type);
        }
        return newDisk;
    }

    public static enum DiskType {
        STANDARD("standard"),
        PD_SSD("pd-ssd");

        private final String typeString;

        private DiskType(String typeString) {
            this.typeString = typeString;
        }

        public String toString() {
            return this.typeString;
        }
    }
}

