/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import org.json.JSONException;
import org.json.JSONObject;

public class Application {
    private final String _name;
    private final String _version;
    private final String _workloadClass;
    private final String _workloadId;
    private final String _workloadDetails;

    public Application(String name, String version, String workloadClass, String workloadId, String workloadDetails) {
        this._name = name;
        this._version = version;
        this._workloadClass = workloadClass;
        this._workloadId = workloadId;
        this._workloadDetails = workloadDetails;
    }

    public Application(String name, String version) {
        this(name, version, null, null, null);
    }

    public String getName() {
        return this._name;
    }

    public String getVersion() {
        return this._version;
    }

    public String getWorkloadClass() {
        return this._workloadClass;
    }

    public String getWorkloadId() {
        return this._workloadId;
    }

    public String getWorkloadDetails() {
        return this._workloadDetails;
    }

    static JSONObject jsonizeApplication(Application application) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("name", (Object)application._name);
        object.put("version", (Object)application._version);
        if (application._workloadClass != null) {
            object.put("workload-class", (Object)application._workloadClass);
        }
        if (application._workloadId != null) {
            object.put("workload-id", (Object)application._workloadId);
        }
        if (application._workloadDetails != null) {
            object.put("workload-details", (Object)application._workloadDetails);
        }
        return object;
    }

    private static String tryGetString(JSONObject object, String key) throws JSONException {
        return object.has(key) ? object.getString(key) : null;
    }

    static Application parseFromJSON(JSONObject object) throws JSONException {
        String name = object.getString("name");
        String version = object.getString("version");
        String workloadClass = Application.tryGetString(object, "workload-class");
        String workloadId = Application.tryGetString(object, "workload-id");
        String workloadDetails = Application.tryGetString(object, "workload-details");
        return new Application(name, version, workloadClass, workloadId, workloadDetails);
    }
}

