/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient.auth.spnego;

import com.twosigma.cook.jobclient.auth.spnego.GSSCredentialProvider;
import org.apache.http.auth.AuthScheme;
import org.apache.http.impl.auth.SPNegoScheme;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class BasicSPNegoSchemeFactory
extends SPNegoSchemeFactory {
    public static final boolean USE_CANONICAL_HOSTNAME = false;
    static final String SPNEGO_OID = "1.2.840.113554.1.2.2";
    private final GSSCredentialProvider _credentialProvider;

    public static SPNegoSchemeFactory build(boolean stripPort, GSSCredentialProvider credentialProvider) {
        return credentialProvider == null ? new SPNegoSchemeFactory(true, false) : new BasicSPNegoSchemeFactory(true, credentialProvider);
    }

    protected BasicSPNegoSchemeFactory(boolean stripPort, GSSCredentialProvider credentialProvider) {
        super(stripPort, false);
        this._credentialProvider = credentialProvider;
    }

    public AuthScheme newInstance(HttpParams params) {
        return new BasicSPNegoScheme(this.isStripPort(), this._credentialProvider);
    }

    public AuthScheme create(HttpContext context) {
        return new BasicSPNegoScheme(this.isStripPort(), this._credentialProvider);
    }

    private static class BasicSPNegoScheme
    extends SPNegoScheme {
        private Oid _oid;
        private final GSSCredentialProvider _credentialProvider;

        private synchronized Oid getOID() throws GSSException {
            if (this._oid == null) {
                this._oid = new Oid(BasicSPNegoSchemeFactory.SPNEGO_OID);
            }
            return this._oid;
        }

        private GSSCredential getCredential() {
            if (this._credentialProvider == null) {
                return null;
            }
            return this._credentialProvider.getCredential();
        }

        BasicSPNegoScheme(boolean stripPort, GSSCredentialProvider credentialProvider) {
            super(stripPort, false);
            this._credentialProvider = credentialProvider;
        }

        protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
            byte[] token = input;
            if (token == null) {
                token = new byte[]{};
            }
            GSSManager manager = this.getManager();
            GSSName serverName = manager.createName("HTTP@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
            GSSCredential cred = this.getCredential();
            Oid oid = this.getOID();
            GSSContext gssContext = manager.createContext(serverName.canonicalize(oid), oid, cred, 0);
            gssContext.requestMutualAuth(true);
            gssContext.requestConf(true);
            return gssContext.initSecContext(token, 0, token.length);
        }
    }
}

