/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.cook.jobclient;

import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Checkpoint {
    private final Mode _mode;
    private final CheckpointOptions _checkpointOptions;
    private final PeriodicCheckpointOptions _periodicCheckpointOptions;

    public Checkpoint(Mode mode, CheckpointOptions checkpointOptions, PeriodicCheckpointOptions periodicCheckpointOptions) {
        this._mode = mode;
        this._checkpointOptions = checkpointOptions;
        this._periodicCheckpointOptions = periodicCheckpointOptions;
    }

    public Mode getMode() {
        return this._mode;
    }

    public CheckpointOptions getCheckpointOptions() {
        return this._checkpointOptions;
    }

    public PeriodicCheckpointOptions getPeriodicCheckpointOptions() {
        return this._periodicCheckpointOptions;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject object = new JSONObject();
        object.put("mode", (Object)this._mode.toString());
        if (this._checkpointOptions != null) {
            object.put("options", (Object)this._checkpointOptions.toJSONObject());
        }
        if (this._periodicCheckpointOptions != null) {
            object.put("periodic-options", (Object)this._periodicCheckpointOptions.toJSONObject());
        }
        return object;
    }

    public static Checkpoint parseFromJSON(JSONObject object) throws JSONException {
        Mode mode = Mode.valueOf(object.getString("mode"));
        CheckpointOptions checkpointOptions = null;
        PeriodicCheckpointOptions periodicCheckpointOptions = null;
        if (object.has("options")) {
            checkpointOptions = CheckpointOptions.parseFromJSON(object.getJSONObject("options"));
        }
        if (object.has("periodic-options")) {
            periodicCheckpointOptions = PeriodicCheckpointOptions.parseFromJSON(object.getJSONObject("periodic-options"));
        }
        return new Checkpoint(mode, checkpointOptions, periodicCheckpointOptions);
    }

    public static enum Mode {
        auto,
        periodic,
        preemption;

    }

    public static class CheckpointOptions {
        private final Set<String> _preservePaths;

        public CheckpointOptions(Set<String> preservePaths) {
            this._preservePaths = preservePaths;
        }

        public Set<String> getPreservePaths() {
            return this._preservePaths;
        }

        public JSONObject toJSONObject() throws JSONException {
            JSONObject object = new JSONObject();
            object.put("preserve-paths", this._preservePaths);
            return object;
        }

        public static CheckpointOptions parseFromJSON(JSONObject object) throws JSONException {
            HashSet<String> preservePaths = new HashSet<String>();
            JSONArray jsonArray = object.getJSONArray("preserve-paths");
            for (int i = 0; i < jsonArray.length(); ++i) {
                preservePaths.add(jsonArray.getString(i));
            }
            return new CheckpointOptions(preservePaths);
        }
    }

    public static class PeriodicCheckpointOptions {
        private final int _periodSec;

        public PeriodicCheckpointOptions(int periodSec) {
            this._periodSec = periodSec;
        }

        public int getPeriodSec() {
            return this._periodSec;
        }

        public JSONObject toJSONObject() throws JSONException {
            JSONObject object = new JSONObject();
            object.put("period-sec", this._periodSec);
            return object;
        }

        public static PeriodicCheckpointOptions parseFromJSON(JSONObject object) throws JSONException {
            int periodSec = object.getInt("period-sec");
            return new PeriodicCheckpointOptions(periodSec);
        }
    }
}

