/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.waiter.courier;

import com.twosigma.waiter.courier.CourierGrpc;
import com.twosigma.waiter.courier.CourierReply;
import com.twosigma.waiter.courier.CourierRequest;
import com.twosigma.waiter.courier.CourierSummary;
import com.twosigma.waiter.courier.GrpcServer;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GrpcClient {
    private static final Logger LOGGER = Logger.getLogger(GrpcServer.class.getName());
    private static Function<String, Void> logFunction = new Function<String, Void>(){

        @Override
        public Void apply(String message) {
            LOGGER.info(message);
            return null;
        }
    };

    public static void setLogFunction(Function<String, Void> logFunction) {
        GrpcClient.logFunction = logFunction;
    }

    private static ManagedChannel initializeChannel(String host, int port) {
        logFunction.apply("initializing plaintext client at " + host + ":" + port);
        return ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
    }

    private static void shutdownChannel(ManagedChannel channel) throws InterruptedException {
        logFunction.apply("shutting down channel");
        channel.shutdown().awaitTermination(1L, TimeUnit.SECONDS);
        if (channel.isShutdown()) {
            logFunction.apply("channel shutdown successfully");
        } else {
            logFunction.apply("channel shutdown timed out!");
        }
    }

    private static Metadata createRequestHeadersMetadata(Map<String, Object> headers) {
        Metadata headerMetadata = new Metadata();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            headerMetadata.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        }
        return headerMetadata;
    }

    private static Channel wrapResponseLogger(ManagedChannel channel) {
        return ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                            public void onHeaders(Metadata headers) {
                                logFunction.apply("headers received from server:" + headers);
                                super.onHeaders(headers);
                            }

                            public void onClose(Status status, Metadata trailers) {
                                logFunction.apply("status received from server:" + status);
                                logFunction.apply("trailers received from server:" + trailers);
                                super.onClose(status, trailers);
                            }
                        }, headers);
                    }
                };
            }
        }});
    }

    /*
     * Exception decompiling
     */
    public static CourierReply sendPackage(String host, int port, Map<String, Object> headers, String id, String from, String message) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<CourierSummary> collectPackages(String host, int port, Map<String, Object> headers, List<String> ids, String from, List<String> messages, int interMessageSleepMs, final boolean lockStepMode, int cancelThreshold) throws InterruptedException {
        ManagedChannel channel = GrpcClient.initializeChannel(host, port);
        AtomicBoolean awaitChannelTermination = new AtomicBoolean(true);
        try {
            final Semaphore lockStep = new Semaphore(1);
            final AtomicBoolean errorSignal = new AtomicBoolean(false);
            Channel wrappedChannel = GrpcClient.wrapResponseLogger(channel);
            Metadata headerMetadata = GrpcClient.createRequestHeadersMetadata(headers);
            CourierGrpc.CourierStub rawStub = CourierGrpc.newStub(wrappedChannel);
            CourierGrpc.CourierStub futureStub = (CourierGrpc.CourierStub)MetadataUtils.attachHeaders((AbstractStub)rawStub, (Metadata)headerMetadata);
            logFunction.apply("will try to send package from " + from + " ...");
            final CompletableFuture responsePromise = new CompletableFuture();
            try {
                StreamObserver<CourierRequest> collector = futureStub.collectPackages(new StreamObserver<CourierSummary>(){
                    final List<CourierSummary> resultList = new ArrayList<CourierSummary>();

                    public void onNext(CourierSummary response) {
                        logFunction.apply("received response CourierSummary{count=" + response.getNumMessages() + ", length=" + response.getTotalLength() + "}");
                        this.resultList.add(response);
                        if (lockStepMode) {
                            logFunction.apply("releasing semaphore after receiving response");
                            lockStep.release();
                        }
                    }

                    public void onError(Throwable throwable) {
                        logFunction.apply("error in collecting summaries " + throwable);
                        errorSignal.compareAndSet(false, true);
                        this.resolveResponsePromise();
                        if (lockStepMode) {
                            logFunction.apply("releasing semaphore after receiving error");
                            lockStep.release();
                        }
                        if (throwable instanceof StatusRuntimeException) {
                            StatusRuntimeException exception = (StatusRuntimeException)throwable;
                            CourierSummary response = CourierSummary.newBuilder().setNumMessages(0L).setStatusCode(exception.getStatus().getCode().name()).setStatusDescription(exception.getStatus().getDescription()).build();
                            this.resultList.add(response);
                        }
                    }

                    public void onCompleted() {
                        logFunction.apply("completed collecting summaries");
                        this.resolveResponsePromise();
                    }

                    private void resolveResponsePromise() {
                        logFunction.apply("client result has " + this.resultList.size() + " entries");
                        responsePromise.complete(this.resultList);
                    }
                });
                for (int i = 0; i < messages.size(); ++i) {
                    if (i >= cancelThreshold) {
                        logFunction.apply("cancelling sending messages");
                        awaitChannelTermination.set(false);
                        channel.shutdownNow();
                        throw new CancellationException("Cancel threshold reached: " + cancelThreshold);
                    }
                    if (errorSignal.get()) {
                        logFunction.apply("aborting sending messages as error was discovered");
                        break;
                    }
                    String requestId = ids.get(i);
                    if (lockStepMode) {
                        logFunction.apply("acquiring semaphore before sending request " + requestId);
                        lockStep.acquire();
                    }
                    CourierRequest request = CourierRequest.newBuilder().setId(requestId).setFrom(from).setMessage(messages.get(i)).build();
                    logFunction.apply("sending message CourierRequest{id=" + request.getId() + ", from=" + request.getFrom() + ", message.length=" + request.getMessage().length() + "}");
                    collector.onNext((Object)request);
                    Thread.sleep(interMessageSleepMs);
                }
                logFunction.apply("completed sending packages");
                collector.onCompleted();
                List list = (List)responsePromise.get();
                return list;
            }
            catch (StatusRuntimeException e) {
                List<CourierSummary> list;
                block13: {
                    logFunction.apply("RPC failed, status: " + e.getStatus());
                    list = null;
                    if (!awaitChannelTermination.get()) break block13;
                    GrpcClient.shutdownChannel(channel);
                }
                return list;
            }
            catch (Exception e) {
                List<CourierSummary> list;
                block14: {
                    logFunction.apply("RPC failed, message: " + e.getMessage());
                    list = null;
                    if (!awaitChannelTermination.get()) break block14;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    GrpcClient.shutdownChannel(channel);
                }
                return list;
            }
        }
        finally {
            if (awaitChannelTermination.get()) {
                GrpcClient.shutdownChannel(channel);
            }
        }
    }

    public static List<CourierSummary> collectPackages(String host, int port, Map<String, Object> headers, String idPrefix, String from, List<String> messages, int interMessageSleepMs, boolean lockStepMode, int cancelThreshold) throws InterruptedException {
        ArrayList<String> ids = new ArrayList<String>(messages.size());
        for (int i = 0; i < messages.size(); ++i) {
            ids.add(idPrefix + i);
        }
        return GrpcClient.collectPackages(host, port, headers, ids, from, messages, interMessageSleepMs, lockStepMode, cancelThreshold);
    }

    public static void main(String ... args) throws Exception {
        long startTimeMillis = System.currentTimeMillis();
        String host = "localhost";
        int port = 8080;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("x-cid", "cid-collect-packages-server-error." + startTimeMillis);
        List<String> ids = IntStream.range(0, 10).mapToObj(i -> "id-" + i).collect(Collectors.toList());
        ids.set(5, (String)ids.get(5) + ".SEND_ERROR");
        List<String> messages = IntStream.range(0, 10).mapToObj(i -> "message-" + i).collect(Collectors.toList());
        List<CourierSummary> courierSummaries = GrpcClient.collectPackages("localhost", 8080, headers, ids, "User", messages, 100, true, messages.size() + 1);
        logFunction.apply("collectPackages[cancel] summary = " + courierSummaries);
    }

    private static /* synthetic */ String lambda$main$5(int i) {
        return "message-" + i;
    }

    private static /* synthetic */ String lambda$main$4(int i) {
        return "id-" + i;
    }

    private static /* synthetic */ String lambda$main$3(int i) {
        return "message-" + i;
    }

    private static /* synthetic */ String lambda$main$2(int i) {
        return "id-" + i;
    }

    private static /* synthetic */ String lambda$main$1(int i) {
        return "message-" + i;
    }

    private static /* synthetic */ String lambda$main$0(int i) {
        return "message-" + i;
    }
}

