/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.waiter.courier;

import com.twosigma.waiter.courier.CourierGrpc;
import com.twosigma.waiter.courier.CourierReply;
import com.twosigma.waiter.courier.CourierRequest;
import com.twosigma.waiter.courier.CourierSummary;
import com.twosigma.waiter.courier.Variant;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;

public class GrpcServer {
    private static final Logger LOGGER = Logger.getLogger(GrpcServer.class.getName());
    private Server server;

    private static void sleep(int durationMillis) {
        try {
            Thread.sleep(durationMillis);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void start(int port) throws IOException {
        LOGGER.info("starting gRPC server on port " + port);
        this.server = ServerBuilder.forPort((int)port).addService((BindableService)new CourierImpl()).intercept((ServerInterceptor)new GrpcServerInterceptor()).build().start();
        LOGGER.info("gRPC server started, listening on " + port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server since JVM is shutting down");
            this.stop();
            System.err.println("*** server shut down");
        }));
    }

    private void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    private static class GrpcServerInterceptor
    implements ServerInterceptor {
        private GrpcServerInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, final Metadata requestMetadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            this.logMetadata(requestMetadata, "request");
            final Metadata.Key xCidKey = Metadata.Key.of((String)"x-cid", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            final String correlationId = (String)requestMetadata.get(xCidKey);
            ForwardingServerCall.SimpleForwardingServerCall wrapperCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                public void sendHeaders(Metadata responseHeaders) {
                    LOGGER.info("GrpcServerInterceptor.sendHeaders[cid=" + correlationId + "]");
                    this.logMetadata(requestMetadata, "response");
                    if (correlationId != null) {
                        LOGGER.info("response linked to cid: " + correlationId);
                        responseHeaders.put(xCidKey, (Object)correlationId);
                    }
                    super.sendHeaders(responseHeaders);
                }

                public void sendMessage(RespT response) {
                    LOGGER.info("GrpcServerInterceptor.sendMessage[cid=" + correlationId + "]");
                    super.sendMessage(response);
                }

                public void close(Status status, Metadata trailers) {
                    LOGGER.info("GrpcServerInterceptor.close[cid=" + correlationId + "] " + status + ", " + trailers);
                    super.close(status, trailers);
                }
            };
            final ServerCall.Listener listener = serverCallHandler.startCall((ServerCall)wrapperCall, requestMetadata);
            return new ServerCall.Listener<ReqT>(){

                public void onMessage(ReqT message) {
                    LOGGER.info("GrpcServerInterceptor.onMessage[cid=" + correlationId + "]");
                    listener.onMessage(message);
                }

                public void onHalfClose() {
                    LOGGER.info("GrpcServerInterceptor.onHalfClose[cid=" + correlationId + "]");
                    listener.onHalfClose();
                }

                public void onCancel() {
                    LOGGER.info("GrpcServerInterceptor.onCancel[cid=" + correlationId + "]");
                    listener.onCancel();
                }

                public void onComplete() {
                    LOGGER.info("GrpcServerInterceptor.onComplete[cid=" + correlationId + "]");
                    listener.onComplete();
                }

                public void onReady() {
                    LOGGER.info("GrpcServerInterceptor.onReady[cid=" + correlationId + "]");
                    listener.onReady();
                }
            };
        }

        private void logMetadata(Metadata metadata, String label) {
            Set metadataKeys = metadata.keys();
            LOGGER.info(label + "@" + metadata.hashCode() + " metadata keys = " + metadataKeys);
            for (String key : metadataKeys) {
                String value = (String)metadata.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                LOGGER.info(label + " metadata " + key + " = " + value);
            }
        }
    }

    private static class CourierImpl
    extends CourierGrpc.CourierImplBase {
        private CourierImpl() {
        }

        @Override
        public void sendPackage(CourierRequest request, StreamObserver<CourierReply> responseObserver) {
            LOGGER.info("received CourierRequest{id=" + request.getId() + ", from=" + request.getFrom() + ", message.length=" + request.getMessage().length() + "}");
            if (responseObserver instanceof ServerCallStreamObserver) {
                ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(() -> LOGGER.info("CancelHandler:sendPackage CourierRequest{id=" + request.getId() + "} was cancelled"));
            }
            if (Variant.SEND_ERROR.equals((Object)request.getVariant())) {
                StatusRuntimeException error = Status.CANCELLED.withCause((Throwable)new RuntimeException(request.getId())).withDescription("Cancelled by server").asRuntimeException();
                LOGGER.info("Sending cancelled by server error");
                responseObserver.onError((Throwable)error);
            } else if (Variant.EXIT_PRE_RESPONSE.equals((Object)request.getVariant())) {
                GrpcServer.sleep(1000);
                LOGGER.info("Exiting server abruptly");
                System.exit(1);
            } else {
                CourierReply reply = CourierReply.newBuilder().setId(request.getId()).setMessage(request.getMessage()).setResponse("received").build();
                LOGGER.info("Sending CourierReply for id=" + reply.getId());
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
            }
        }

        @Override
        public StreamObserver<CourierRequest> collectPackages(final StreamObserver<CourierSummary> responseObserver) {
            if (responseObserver instanceof ServerCallStreamObserver) {
                ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(() -> LOGGER.info("CancelHandler:collectPackages() was cancelled"));
            }
            return new StreamObserver<CourierRequest>(){
                private long numMessages = 0L;
                private long totalLength = 0L;

                public void onNext(CourierRequest request) {
                    LOGGER.info("Received CourierRequest id=" + request.getId());
                    ++this.numMessages;
                    this.totalLength += (long)request.getMessage().length();
                    LOGGER.info("Summary of collected packages: numMessages=" + this.numMessages + " with totalLength=" + this.totalLength);
                    if (Variant.EXIT_PRE_RESPONSE.equals((Object)request.getVariant())) {
                        GrpcServer.sleep(1000);
                        LOGGER.info("Exiting server abruptly");
                        System.exit(1);
                    } else if (Variant.SEND_ERROR.equals((Object)request.getVariant())) {
                        StatusRuntimeException error = Status.CANCELLED.withCause((Throwable)new RuntimeException(request.getId())).withDescription("Cancelled by server").asRuntimeException();
                        LOGGER.info("Sending cancelled by server error");
                        responseObserver.onError((Throwable)error);
                    } else {
                        CourierSummary courierSummary = CourierSummary.newBuilder().setNumMessages(this.numMessages).setTotalLength(this.totalLength).build();
                        LOGGER.info("Sending CourierSummary for id=" + request.getId());
                        responseObserver.onNext((Object)courierSummary);
                    }
                    if (Variant.EXIT_POST_RESPONSE.equals((Object)request.getVariant())) {
                        GrpcServer.sleep(1000);
                        LOGGER.info("Exiting server abruptly");
                        System.exit(1);
                    }
                }

                public void onError(Throwable th) {
                    LOGGER.severe("Error in collecting packages: " + th.getMessage());
                    responseObserver.onError(th);
                }

                public void onCompleted() {
                    LOGGER.severe("Completed collecting packages");
                    responseObserver.onCompleted();
                }
            };
        }
    }
}

