
(ns form-dot-clj.dsl)

(declare start-tag second-entry content)

(defn start-tag [state i]
  (let [tag-name (name i)]
    {:add (open-tag tag-name)
     :next second-entry
     :end (fn [_] (close-tag tag-name))}))

(defn second-entry [state i]
  (cond
    (map? i)         {:add (build-attributes item)
                      :next content}
    :else            (content state i)))

(defn content [state i]
  (cond
    (vector? i)      {:descend i
                      :next start-tag}
    :else            {:add i
                      :next content}))

;; This should be a function available in dsl library
(defn- string-reduce [acc i]
  (if (and (seq? i) (not (list? i)))
    (reduce string-reduce acc i)
    (let [l (peek acc)]
      (if (stringable? l i)
        (conj (pop acc) (str l i))
        (conj acc i)))))

(def-dsl html
  :start-at start-tag
  :start-state  nil
  :reduce-with string-reduce)
