
(ns form-dot-clj.js-utils
  "Javascript generating utilities"
  (:use hiccup.core)
  (:use com.reasonr.scriptjure))

(defn script
  "Wraps js code in a script tag"
  [jscript]
  (html
   [:script {:type "text/javascript"}
    (js (clj jscript))]))

(defn on-ready
  "Sets up a jquery on-ready function"
  [jscript]
  (js*
   (.ready ($ document)
           (fn [] (clj jscript)))))

(defmacro html-id
  "Creates a string for a html id"
  [id]
  (let [js-id# (str "#" id)]
    `(js* ($ ~js-id#))))

(defmacro js-concat
  "Concatenates two pieces of javascript together"
  [a bs]
  `(js* ~a ~@bs))
        
               
