# [Fluokitten](http://fluokitten.uncomplicate.org) - category theory in idiomatic Clojure
[![Build Status](https://secure.travis-ci.org/uncomplicate/fluokitten.png)](https://travis-ci.org/uncomplicate/fluokitten)

Fluokitten is a Clojure library that implements category theory concepts, such as functors, applicative functors, monads, monoids etc. in idiomatic Clojure.

There is a lot of documentation and tutorials at [Fluokitten Website](http://fluokitten.uncomplicate.org). Please make sure to check it out.

## Project Goals

* Fit well into idiomatic Clojure - Clojure programmers should be able to use and understand Fluokitten like any regular Clojure library.
* Fit well into Haskell monadic types conventions - programmers should be able to reuse existing widespread monadic programming know-how and easily translate it to Clojure code.
* Be reasonably easy to learn - the code from the existing books, articles and tutorials for learning monadic programming, which is usually written in Haskell should be easily translatable to Clojure with Fluokitten.
* Offer good performance.

## Documentation & Examples

The project is documented in the following ways:
* [API documentation](http://fluokitten.uncomplicate.org/codox).
* Learning resources on the [Fluokitten Homepage](http://fluokitten.uncomplicate.org)
* Code examples that are parts of the test suite.

## Project Maturity

While the project is in the 0.X.Y version it is considered in development, so the priority is adding the new features and enhancing the existing code as much as possible, rather than backward compatibility.
Once it reaches version 1.0.0 it will be considered stable, and more consideration will be directed towards supporting backward compatibility.

## License

Copyright © 2013-2017 Dragan Djuric

Distributed under the Eclipse Public License, the same as Clojure
