# Unified Template for {{name}} Project
## Prerequisites
- [rlwrap](https://github.com/hanslub42/rlwrap): Helper to allows Special interaction with the REPL (Optional)
- [Leiningen](https://leiningen.org): Tool for a peaceful Clojure(Script) environment.
- [PhantomJS](http://phantomjs.org): Javascript library for Unit Testing. Used for Frontend Unit Testing.

## Main commands
*Note*: You can add `rlwrap` in front of every command to get additional features (Backspace, history, ...)
### Generic
- `lein clean`: clean the project

### Frontend
- `lein front`: Launch frontend in dev
- `lein test-front`: Launch frontend tests
- `lein build-front`: Launch frontend build

### Backend
- `lein back`: Launch backend in dev
- `lein test-back`: Launch backend tests


## Architecture
```
├── project.clj ----------------------> Project
├── README.md ------------------------> The file you're currently reading
├── resources
│   └── public
│       ├── css
│       │   └── style.css ------------>
│       ├── cards.html ---------------> HTML Main File (for devcards build)
│       └── index.html ---------------> HTML Main File (for dev/prod build)
├── src
│   ├── back
│   │   └── {{sanitized}}
│   │       └── core.clj -------------> Backend Main File
│   ├── common
│   │   └── {{sanitized}}
│   │       └── common
│   │           └── core.cljc --------> Common example file
│   └── front
│       └── {{sanitized}}
│           ├── core.cljs ------------> Frontend Main File (for dev/prod build)
│           └── core_devcards.cljs ---> Frontend Main File (for devcards build)
└── test
    ├── back
    │   └── test
    │       └── core.clj -------------> Backend Main Test
    ├── common
    │   └── test
    │       └── common
    │           └── core.cljc --------> Common Main Test
    └── front
        └── test
            ├── core.cljs ------------> Frontend Main Test
            └── runner.cljs ----------> Frontend Test Runner
```
