(ns uniui.react.react
  (:require [cljsjs.react]))

(defn- transform-type
  [type]
  (if (keyword? type)
    (name type)
    type))

(defn create-element
  [type props children]
  (apply js/React.createElement (into [(transform-type type) (clj->js props)] (map clj->js children))))

(defn create-fragment
  [children]
  (create-element js/React.Fragment {} children))

(defn valid-element?
  "Returns true if x is a valid React element"
  [x]
  (js/React.isValidElement x))