(ns leiningen.new.tmpl
  (:require
    [leiningen.new.templates :as template]
    [clj-time.local :as l]))

(def files
  {:root ^:always   {"README.md"           "README.md"}})

(defn make-data [project-name opts]
  {:name      project-name
   :sanitized (template/name-to-path project-name)
   :basic-date (l/format-local-time (l/local-now) :basic-date)})

(def all (->> files (filter (comp not :always meta second)) (map first) set))

(def opts
  {:all all})
