(ns leiningen.new.uploadatron
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "uploadatron"))

(defn uploadatron
  "Generate a new Uploadatron project into a directory called name"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)
              :clojure-version "1.6.0"}]
    (main/info "Generating fresh 'lein new' uploadatron project.")
    (->files data
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render "gitignore" data)]
             ["src/{{sanitized}}/schema.clj" (render "schema.clj" data)]
             ["src/{{sanitized}}/server.clj" (render "server.clj" data)]
             ["src/{{sanitized}}/views.clj" (render "views.clj" data)]

             ["test/{{sanitized}}/schema_test.clj" (render "schema_test.clj" data)]
             ["test/{{sanitized}}/server_test.clj" (render "server_test.clj" data)]
             ["test/{{sanitized}}/views_test.clj" (render "views_test.clj" data)])))
