(ns {{name}}.server-test
  (:require [clojure.java.io :as io]
            [clojure.test :refer :all]
            [{{name}}.server :refer :all]
            [ring.mock.request :as mock]
            [ring.util.response :refer [response]]))

(deftest test-routes
  (testing "invalid routes are caught"
    (let [response (app (mock/request :get "/invalid"))]
      (is (= 404 (:status response)))))

  (testing "main route"
    (let [response (app (mock/request :get "/"))]
      (is (= 200 (:status response)))
      (is (= "Upload transactions" (re-find #"Upload transactions" (:body response))))))

  (testing "failing upload"
    (let [params {:multipart-params
                  {:size 3500
                   :tempfile "marmot.clj"
                   :content-type "application/text"
                   :filename "marmot.clj"}}
          request (mock/request :post "/upload" params)
          response (app request)]
      (is (= 400 (:status response)))
      (is (= "Upload failed" (re-find #"Upload failed" (:body response))))))  )
