(ns uswitch.ring-riemann
  (:require [riemann.client :as client]
            [clojure.string :as string]
            [clj-stacktrace.repl :as stacktrace]))


(defn- safe-send
  [client event]
  (try (client/send-event client event)
       (catch Throwable t (log/error t "Error sending metric to riemann"))))


(defn wrap-riemann
  [handler host service]
  (let [c (client/tcp-client :host host)]
    (fn [req]
      (let [t (System/currentTimeMillis)]
        (try
          (let [res (handler req)
                service (if-let [custom-service (-> res :riemann-service)]
                          (str service " " custom-service)
                          service)]
            (safe-send c {:service service
                          :state   (str (:status res))
                          :description  (str "Request headers\n"
                                             (prn-str (:headers req))
                                             "\n"
                                             "Response headers\n"
                                             (prn-str (:headers res))) 
                          :metric  (- (System/currentTimeMillis) t)})
            res)
          (catch Throwable t
            (safe-send c {:service service
                          :state   "exception"
                          :tags    ["exception"]
                          :metric  (- (System/currentTimeMillis) t)
                          :description (stacktrace/pst-str t)})
            (throw t)))))))

