(defproject uswitch/tools.reader "0.9.3"
  :description "A Clojure reader in Clojure"
  :parent [org.clojure/pom.contrib "0.1.2"]
  :url "https://github.com/clojure/tools.reader"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :source-paths ["src/main/clojure" "src/main/cljs"]
  :test-paths ["src/test/clojure"]
  :repositories {"sonatype-oss-public" "https://oss.sonatype.org/content/groups/public/"}
  :dependencies [[org.clojure/clojure "1.7.0-RC1"]
                 [org.clojure/clojurescript "0.0-3269"]]
  :plugins [[lein-cljsbuild "1.0.5"]]
  :profiles {:1.4 {:dependencies [[org.clojure/clojure "1.4.0"]]}
             :1.5 {:dependencies [[org.clojure/clojure "1.5.1"]]}
             :1.6 {:dependencies [[org.clojure/clojure "1.6.0"]]}
             :1.7 {:dependencies [[org.clojure/clojure "1.7.0-RC1"]]}
             :dev {:dependencies [[com.cemerick/piggieback "0.2.1"]
                                  [org.clojure/tools.nrepl "0.2.10"]]
                   :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}}
  :aliases {"test-all" ["with-profile" "test,1.4:test,1.5:test,1.6:test,1.7" "test"]
            "check-all" ["with-profile" "1.4:1.5:1.6:1.7" "check"]}
  :min-lein-version "2.0.0"
  :cljsbuild {:test-commands {"test" ["node" :runner "target/test/tools.reader.test.js"]}
              :builds [{:id "dev"
                        :source-paths ["src/main/cljs"]
                        :compiler {:output-to "out/main.js"
                                   :output-dir "out"
                                   :optimizations :simple
                                   :pretty-print true}}
                       {:id "test"
                        :source-paths ["src/main/cljs" "src/test/cljs"]
                        :notify-command ["node" "target/test/tools.reader.test.js"]
                        :compiler
                        {:output-to  "target/test/tools.reader.test.js"
                         :source-map "target/test/tools.reader.test.js.map"
                         :output-dir "target/test/out"
                         :optimizations :simple}}]})
