(defproject vadelabs/vade-design-system "0.0.0-SNAPSHOT"
  :description "Vade Design System. It is built using ClojureScript, Re-Frame. It follows atomic design pattern for better and scalable directory structure.",
  :url "https://vadelabs.com/vade-design-system"
  :scm {:name "git" :url "https://gitlab.com/vadelabs/vadecljs/vade-design-system.git"}
  :source-paths ["src"]
  :deploy-repositories [["clojars" {:url "https://clojars.org/repo"
                                    :creds :gpg}]]
  :dependencies [[proto-repl "0.3.1"]
                 [reagent "0.9.0-rc2"]
                 [re-frame "0.11.0-rc1"]
                 [day8.re-frame/http-fx "0.1.6"]
                 [day8.re-frame/re-frame-10x "0.4.4"]
                 [day8.re-frame/tracing "0.5.1"]
                 [cljs-ajax "0.7.3"]
                 [com.andrewmcveigh/cljs-time "0.5.2"]
                 [bidi "2.1.6"]
                 [kibu/pushy "0.3.8"]
                 [binaryage/devtools "0.9.10"]
                 [nubank/workspaces "1.0.13"]
                 [cider/cider-nrepl "0.21.0"]
                 [stylefy "1.14.0"]]
  
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :license {:name "Eclipse Public License - v 1.0"
            :url "http://www.eclipse.org/legal/epl-v10.html"
            :distribution :repo
            :comments "same as Clojure"})