(ns vds.demo.core
  (:require [re-frame.core :refer [dispatch
                                   dispatch-sync
                                   clear-subscription-cache!]]
            [reagent.core :as reagent]
            [vds.demo.router :as router]
            [vds.demo.events]  ;; These three are only
            [vds.demo.subs]    ;; required to make the compiler
            [vds.demo.views]
            [vds.config :as config]
            [stylefy.core :as stylefy]
            )) ;; load them

(defn dev-setup
  []
  (when config/debug?
    (enable-console-print!)
    (println "dev mode")))

(defn mount-root
  []
  (clear-subscription-cache!)
  (reagent/render [vds.demo.views/app]
                  (.getElementById js/document "app")))

;; -- Entry Point -------------------------------------------------------------
;; Within ../../resources/public/index.html you'll see this code:
;; window.onload = function() { admin.core.main() } this is the entry 
;; function that kicks off the app once the HTML is loaded.
;;
(defn ^:export init
  []
  ;; Router config can be found within `./router.cljs`. Here we are just hooking
  ;; up the router on start
  (router/start!)
  (stylefy/init {:use-caching? false})
  ;; Put an initial value into app-db.
  ;; The event handler for `:initialise-db` can be found in `events.cljs`
  ;; Using the sync version of dispatch means that value is in
  ;; place before we go onto the next step.
  (dispatch-sync [:initialize-db])

  ;; Render the UI into the HTML's <div id="app" /> element
  ;; The view function `admin.views/admin-app` is the
  ;; root view for the entire UI.
  ; (reagent/render [vds.demo.views/app]
  ;                 (.getElementById js/document "app")))
  (mount-root))