# Ultra

Hey, you know who has two thumbs and strong opinions? That's right, it's me.

Ultra is a Leiningen plugin aiming to provide an absolutely kick-ass development environment.

## Installation

Add the following to your `:user` profile:

```clojure
[venantius/ultra "0.1.6"]
```

## Features

*A colorized REPL!*
![colorized repl](https://venantius.github.io/ultra/images/colorized-repl.png)

*Clearer test output!*
![test output demo](https://venantius.github.io/ultra/images/test-output.png)

*Better stacktraces!*
![test stacktrace demo](https://venantius.github.io/ultra/images/colorized-test-stacktrace.png)

*Java object introspection!*
>> INSERT JAVA OBJECT INTROSPECTION

## Configuration

```clojure
{:user {:plugins [[venantius/ultra "0.1.6"]]
        :ultra {:color-scheme :solarized_dark
                :width 80
                :print-color true}}}
```

### Color schemes

At the moment Ultra supports the following color schemes:
 - `:solarized_dark`
 - `:default`

If you want to set the colors yourself instead of using a theme you can configure them directly, e.g.:

```clojure
{:user {:plugins [[venantius/ultra "0.1.6"]]
        :ultra {:print-color true
                :color-scheme {:delimiter [:red]
                               :tag [:red]
                               :nil [:cyan]
                               :boolean [:cyan]
                               :number [:cyan]
                               :string [:cyan]
                               :character [:cyan]
                               :keyword [:green]
                               :symbol nil
                               :function-symbol [:blue]
                               :class-delimiter [:blue]
                               :class-name nil
                               :exception nil}}}}
```

## Todo

- [ ] Only run add-ultra once
- [ ] Swap the class mismatch text around, expected should be actual and vice-versa
- [ ] prn-diffs for lists / vectors
- [ ] prn-diffs for sets
- [ ] Pomegranate for hot dependency loading
- [ ] Iroh
- [ ] Slamhound?

wishlist?
- [ ] lein-kibit
- [ ] lein-bikeshed
- [ ] lein-eastwood
- [ ] repetition-hunter

## Contributing

Please open an issue here before submitting pull requests; I prefer to have documentation and consensus that either of our time will be well spent by working on it. 

Bug fixes are always appreciated and won't get too much pushback; new features will be held to a higher standard - this whole project is a massive exercise in ego, after all.

Pull Requests for new color schemes welcome; please include screenshots in your submission.

## Motivation

...or, why didn't you just put all of this stuff in your `~/.lein/profiles.clj`?

Great question, hypothetical asker! In short, my `:user` profile was starting to 
become bloated. It was difficult to tell whether plugins were interfering with 
each other, and my `:injections` key in particular was 
starting to look a little unwieldy. 

As I got further down the road of configuring my environment, I started to re-write
the core functionality of my other tools, and eventually ended up deep
in the guts of things. At some point it just made sense to split
it out into its own project.

## Special Thanks

Ultra wraps, calls, or draws inspiration from the following libraries, and their owners and authors deserve credit for doing most of the hard work:

 - [AvisoNovate/pretty](https://github.com/AvisoNovate/pretty) - Better exceptions
 - [brentonashworth/lein-difftest](https://github.com/brentonashworth/lein-difftest) - Lein-difftest - test diffs using difform
 - [greglook/puget](https://github.com/greglook/puget) - Colorized pretty-printing
 - [greglook/whidbey](https://github.com/greglook/whidbey) - Puget nREPL middleware
 - [jaycfields/expectations](https://github.com/jaycfields/expectations) - The Expectations testing library
 - [pjstadig/humane-test-output](https://github.com/pjstadig/humane-test-output) - Diffs in tests using clojure.test

## License

Anything that isn't already copyright of one of the above authors is Copyright © 2015 W. David Jarvis.

Distributed under the Eclipse Public License 1.0, the same as Clojure.
