(ns ventas-devtools.config
  (:require [clojure.java.io :as io]))

(defn sassc [theme-ids]
  (into (->> [{:src "src/scss/main.scss"
               :output-to "resources/public/files/css/style.css"
               :style "nested"
               :import-path "src/scss"}
              {:src "src/scss/email.scss"
               :output-to "resources/public/files/css/email.css"
               :style "nested"
               :import-path "src/scss"}]
             (filter #(.exists (io/file (:src %)))))
        (for [id theme-ids]
          {:src (str "src/scss/themes/" (name id) "/core.scss")
           :output-to (str "resources/public/files/css/themes/" (name id) ".css")
           :style "nested"
           :import-path "src/scss"})))