(def aot-namespaces
  ['clojure.tools.logging.impl
   'ventas.core])

(defproject {{raw-name}} "0.0.1-SNAPSHOT"
  :description "A ventas-based project"

  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :repositories {"my.datomic.com"
                 ~(merge
                    {:url "https://my.datomic.com/repo"}
                    (let [username (System/getenv "DATOMIC__USERNAME")
                          password (System/getenv "DATOMIC__PASSWORD")]
                      (when (and username password)
                        {:username username
                         :password password})))}

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/clojurescript "1.9.946" :scope "provided"]
                 [org.clojure/tools.namespace "0.3.0-alpha4"]
                 [org.clojure/spec.alpha "0.1.143" :scope "provided"]
                 [mount "0.1.11"]
                 [ventas "0.0.11-SNAPSHOT" :exclusions [com.datomic/datomic-pro com.datomic/datomic-free]]]

  :plugins [[lein-auto "0.1.3"]
            [lein-cljfmt "0.5.6"]
            [lein-cljsbuild "1.1.7"]]

  :source-paths ["src/clj" "src/cljs"]

  :jvm-opts ["-XX:-OmitStackTraceInFastThrow"
             "-Dapple.awt.UIElement=true" ;; Disable empty/useless menu item in OSX
             ]

  :clean-targets ^{:protect false} [:target-path :compile-path "resources/public/files/js"]

  :uberjar-name "ventas.jar"

  :main ^:skip-aot {{raw-name}}.core

  :repl-options {:init-ns repl
                 :port 4001
                 :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]
                 :timeout 120000}

  :aliases {"nrepl" ["repl" ":connect" "localhost:4001"]
            "prepare" ["do" ["clean"] ["with-profile" "development" "run" "-m" "ventas-devtools.uberjar/prepare" :project/ventas-build :project/main]]
            "release-install" ["with-profile" "release" "install"]}

  :target-path "target/%s"

  :cljsbuild {:builds
              [{:id "test"
                :source-paths ["src/cljs" "src/cljc" "test/cljs" "test/cljc" "test/doo"]
                :compiler {:output-to "resources/public/files/js/compiled/testable.js"
                           :main ventas.test-runner
                           :optimizations :none
                           :parallel-build true}}]}

  :doo {:build "test"}

  :ventas-build {:themes #{:example}}

  :profiles {:datomic-pro ^:leaky {:dependencies [[com.datomic/datomic-pro "0.9.5561.56" :exclusions [org.slf4j/slf4j-nop org.slf4j/slf4j-log4j12]]]}
             :datomic-free ^:leaky {:dependencies [[com.datomic/datomic-free "0.9.5561.56" :exclusions [org.slf4j/slf4j-nop org.slf4j/slf4j-log4j12]]]}
             :fmt {:source-paths ^:replace ["dev/cljs" "dev/clj" "src/clj" "src/cljc" "src/cljs"]}
             :build-client ^:leaky {:prep-tasks ["javac"
                                                 "compile"
                                                 ["run" "-m" "ventas-devtools.uberjar/prepare" :project/ventas-build :project/main]]}
             :development {:dependencies [[org.codehaus.plexus/plexus-utils "3.0.15"]
                                          [ventas/devtools "0.0.11-SNAPSHOT"]
                                          ;; CLJS
                                          [figwheel "0.5.15"]
                                          [figwheel-sidecar "0.5.15"]
                                          [com.cemerick/piggieback "0.2.2"]
                                          [binaryage/devtools "0.9.10"]]
                           :plugins [[cider/cider-nrepl "0.17.0-SNAPSHOT" :exclusions [org.clojure/tools.nrepl]]
                                     [refactor-nrepl "2.4.0-SNAPSHOT"]]
                           :source-paths ["dev/cljs" "dev/clj"]}
             :repl ^:repl [:datomic-pro :development {:plugins [[venantius/ultra "0.5.2"]]}]
             :uberjar [:datomic-pro :build-client {:source-paths ^:replace ["src/clj" "src/cljc"]
                                                   :main ventas.core
                                                   :omit-source true
                                                   :aot ~aot-namespaces}]})