goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__31472){
var vec__31473 = p__31472;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31473,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31473,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__31480 = clojure.data.diff(va,vb);
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31480,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31480,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31480,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = ((in_a) && (in_b) && (((!((ab == null))) || ((((va == null)) && ((vb == null)))))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((((in_a) && (((!((a_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),((((in_b) && (((!((b_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__31486 = arguments.length;
switch (G__31486) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__4037__auto__ = cljs.core.count(a);
var y__4038__auto__ = cljs.core.count(b);
return ((x__4037__auto__ > y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if(((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null))))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__4243__auto__ = (((x == null))?null:x);
var m__4244__auto__ = (clojure.data.equality_partition[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto__.call(null,x));
} else {
var m__4244__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if(((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null))))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__4243__auto__ = (((a == null))?null:a);
var m__4244__auto__ = (clojure.data.diff_similar[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto__.call(null,a,b));
} else {
var m__4244__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__31507_31533 = clojure.data.equality_partition;
var G__31508_31534 = "null";
var G__31509_31535 = ((function (G__31507_31533,G__31508_31534){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__31507_31533,G__31508_31534))
;
goog.object.set(G__31507_31533,G__31508_31534,G__31509_31535);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__31510_31536 = clojure.data.equality_partition;
var G__31511_31537 = "string";
var G__31512_31538 = ((function (G__31510_31536,G__31511_31537){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__31510_31536,G__31511_31537))
;
goog.object.set(G__31510_31536,G__31511_31537,G__31512_31538);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__31514_31539 = clojure.data.equality_partition;
var G__31515_31540 = "number";
var G__31516_31541 = ((function (G__31514_31539,G__31515_31540){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__31514_31539,G__31515_31540))
;
goog.object.set(G__31514_31539,G__31515_31540,G__31516_31541);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__31517_31542 = clojure.data.equality_partition;
var G__31518_31543 = "array";
var G__31519_31544 = ((function (G__31517_31542,G__31518_31543){
return (function (x){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
});})(G__31517_31542,G__31518_31543))
;
goog.object.set(G__31517_31542,G__31518_31543,G__31519_31544);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__31520_31545 = clojure.data.equality_partition;
var G__31521_31546 = "function";
var G__31522_31547 = ((function (G__31520_31545,G__31521_31546){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__31520_31545,G__31521_31546))
;
goog.object.set(G__31520_31545,G__31521_31546,G__31522_31547);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__31524_31549 = clojure.data.equality_partition;
var G__31525_31550 = "boolean";
var G__31526_31551 = ((function (G__31524_31549,G__31525_31550){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__31524_31549,G__31525_31550))
;
goog.object.set(G__31524_31549,G__31525_31550,G__31526_31551);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__31527_31553 = clojure.data.equality_partition;
var G__31528_31554 = "_";
var G__31529_31555 = ((function (G__31527_31553,G__31528_31554){
return (function (x){
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return new cljs.core.Keyword(null,"map","map",1371690461);
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return new cljs.core.Keyword(null,"set","set",304602554);
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
} else {
return new cljs.core.Keyword(null,"atom","atom",-397043653);

}
}
}
});})(G__31527_31553,G__31528_31554))
;
goog.object.set(G__31527_31553,G__31528_31554,G__31529_31555);
goog.object.set(clojure.data.Diff,"null",true);

var G__31556_31599 = clojure.data.diff_similar;
var G__31557_31600 = "null";
var G__31558_31601 = ((function (G__31556_31599,G__31557_31600){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__31556_31599,G__31557_31600))
;
goog.object.set(G__31556_31599,G__31557_31600,G__31558_31601);

goog.object.set(clojure.data.Diff,"string",true);

var G__31565_31603 = clojure.data.diff_similar;
var G__31566_31604 = "string";
var G__31567_31605 = ((function (G__31565_31603,G__31566_31604){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__31565_31603,G__31566_31604))
;
goog.object.set(G__31565_31603,G__31566_31604,G__31567_31605);

goog.object.set(clojure.data.Diff,"number",true);

var G__31571_31606 = clojure.data.diff_similar;
var G__31572_31607 = "number";
var G__31573_31608 = ((function (G__31571_31606,G__31572_31607){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__31571_31606,G__31572_31607))
;
goog.object.set(G__31571_31606,G__31572_31607,G__31573_31608);

goog.object.set(clojure.data.Diff,"array",true);

var G__31575_31609 = clojure.data.diff_similar;
var G__31576_31610 = "array";
var G__31577_31611 = ((function (G__31575_31609,G__31576_31610){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__31575_31609,G__31576_31610))
;
goog.object.set(G__31575_31609,G__31576_31610,G__31577_31611);

goog.object.set(clojure.data.Diff,"function",true);

var G__31578_31613 = clojure.data.diff_similar;
var G__31579_31614 = "function";
var G__31580_31615 = ((function (G__31578_31613,G__31579_31614){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__31578_31613,G__31579_31614))
;
goog.object.set(G__31578_31613,G__31579_31614,G__31580_31615);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__31582_31616 = clojure.data.diff_similar;
var G__31583_31617 = "boolean";
var G__31584_31618 = ((function (G__31582_31616,G__31583_31617){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__31582_31616,G__31583_31617))
;
goog.object.set(G__31582_31616,G__31583_31617,G__31584_31618);

goog.object.set(clojure.data.Diff,"_",true);

var G__31585_31622 = clojure.data.diff_similar;
var G__31586_31623 = "_";
var G__31587_31624 = ((function (G__31585_31622,G__31586_31623){
return (function (a,b){
var fexpr__31594 = (function (){var G__31595 = clojure.data.equality_partition(a);
var G__31595__$1 = (((G__31595 instanceof cljs.core.Keyword))?G__31595.fqn:null);
switch (G__31595__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31595__$1)].join('')));

}
})();
return (fexpr__31594.cljs$core$IFn$_invoke$arity$2 ? fexpr__31594.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__31594.call(null,a,b));
});})(G__31585_31622,G__31586_31623))
;
goog.object.set(G__31585_31622,G__31586_31623,G__31587_31624);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});

//# sourceMappingURL=clojure.data.js.map
