goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$IElement$_to_dom$arity$1 == null))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto__.call(null,this$));
} else {
var m__4244__auto____$1 = (shadow.dom._to_dom["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto__.call(null,this$));
} else {
var m__4244__auto____$1 = (shadow.dom._to_svg["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4244__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__33888 = coll;
var G__33889 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__33888,G__33889) : shadow.dom.lazy_native_coll_seq.call(null,G__33888,G__33889));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__3949__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode([cljs.core.str.cljs$core$IFn$_invoke$arity$1(el)].join(''));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__33902 = arguments.length;
switch (G__33902) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__33905 = arguments.length;
switch (G__33905) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__33910 = arguments.length;
switch (G__33910) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__33915 = arguments.length;
switch (G__33915) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__33920 = arguments.length;
switch (G__33920) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__33921 = document;
var G__33922 = shadow.dom.dom_node(el);
return goog.dom.contains(G__33921,G__33922);
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
var G__33923 = shadow.dom.dom_node(parent);
var G__33924 = shadow.dom.dom_node(el);
return goog.dom.contains(G__33923,G__33924);
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
var G__33926 = shadow.dom.dom_node(el);
var G__33927 = cls;
return goog.dom.classlist.add(G__33926,G__33927);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
var G__33928 = shadow.dom.dom_node(el);
var G__33929 = cls;
return goog.dom.classlist.remove(G__33928,G__33929);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__33931 = arguments.length;
switch (G__33931) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
var G__33932 = shadow.dom.dom_node(el);
var G__33933 = cls;
return goog.dom.classlist.toggle(G__33932,G__33933);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__3949__auto__ = !((typeof document !== 'undefined'));
if(or__3949__auto__){
return or__3949__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e33936){if((e33936 instanceof Object)){
var e = e33936;
return console.log("didnt support attachEvent",el,e);
} else {
throw e33936;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__3949__auto__ = !((typeof document !== 'undefined'));
if(or__3949__auto__){
return or__3949__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__33938 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__33939 = null;
var count__33940 = (0);
var i__33941 = (0);
while(true){
if((i__33941 < count__33940)){
var el = chunk__33939.cljs$core$IIndexed$_nth$arity$2(null,i__33941);
var handler_33955__$1 = ((function (seq__33938,chunk__33939,count__33940,i__33941,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33938,chunk__33939,count__33940,i__33941,el))
;
var G__33943_33956 = el;
var G__33944_33957 = cljs.core.name(ev);
var G__33945_33958 = handler_33955__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__33943_33956,G__33944_33957,G__33945_33958) : shadow.dom.dom_listen.call(null,G__33943_33956,G__33944_33957,G__33945_33958));


var G__33959 = seq__33938;
var G__33960 = chunk__33939;
var G__33961 = count__33940;
var G__33962 = (i__33941 + (1));
seq__33938 = G__33959;
chunk__33939 = G__33960;
count__33940 = G__33961;
i__33941 = G__33962;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__33938);
if(temp__5457__auto__){
var seq__33938__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33938__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__33938__$1);
var G__33963 = cljs.core.chunk_rest(seq__33938__$1);
var G__33964 = c__4351__auto__;
var G__33965 = cljs.core.count(c__4351__auto__);
var G__33966 = (0);
seq__33938 = G__33963;
chunk__33939 = G__33964;
count__33940 = G__33965;
i__33941 = G__33966;
continue;
} else {
var el = cljs.core.first(seq__33938__$1);
var handler_33967__$1 = ((function (seq__33938,chunk__33939,count__33940,i__33941,el,seq__33938__$1,temp__5457__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33938,chunk__33939,count__33940,i__33941,el,seq__33938__$1,temp__5457__auto__))
;
var G__33952_33969 = el;
var G__33953_33970 = cljs.core.name(ev);
var G__33954_33971 = handler_33967__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__33952_33969,G__33953_33970,G__33954_33971) : shadow.dom.dom_listen.call(null,G__33952_33969,G__33953_33970,G__33954_33971));


var G__33972 = cljs.core.next(seq__33938__$1);
var G__33973 = null;
var G__33974 = (0);
var G__33975 = (0);
seq__33938 = G__33972;
chunk__33939 = G__33973;
count__33940 = G__33974;
i__33941 = G__33975;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__33977 = arguments.length;
switch (G__33977) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
var G__33979 = shadow.dom.dom_node(el);
var G__33980 = cljs.core.name(ev);
var G__33981 = handler__$1;
return (shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__33979,G__33980,G__33981) : shadow.dom.dom_listen.call(null,G__33979,G__33980,G__33981));
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
var G__33984 = shadow.dom.dom_node(el);
var G__33985 = cljs.core.name(ev);
var G__33986 = handler;
return (shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3(G__33984,G__33985,G__33986) : shadow.dom.dom_listen_remove.call(null,G__33984,G__33985,G__33986));
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__33990 = cljs.core.seq(events);
var chunk__33991 = null;
var count__33992 = (0);
var i__33993 = (0);
while(true){
if((i__33993 < count__33992)){
var vec__33994 = chunk__33991.cljs$core$IIndexed$_nth$arity$2(null,i__33993);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33994,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33994,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34001 = seq__33990;
var G__34002 = chunk__33991;
var G__34003 = count__33992;
var G__34004 = (i__33993 + (1));
seq__33990 = G__34001;
chunk__33991 = G__34002;
count__33992 = G__34003;
i__33993 = G__34004;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__33990);
if(temp__5457__auto__){
var seq__33990__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33990__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__33990__$1);
var G__34005 = cljs.core.chunk_rest(seq__33990__$1);
var G__34006 = c__4351__auto__;
var G__34007 = cljs.core.count(c__4351__auto__);
var G__34008 = (0);
seq__33990 = G__34005;
chunk__33991 = G__34006;
count__33992 = G__34007;
i__33993 = G__34008;
continue;
} else {
var vec__33997 = cljs.core.first(seq__33990__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33997,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33997,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34010 = cljs.core.next(seq__33990__$1);
var G__34011 = null;
var G__34012 = (0);
var G__34013 = (0);
seq__33990 = G__34010;
chunk__33991 = G__34011;
count__33992 = G__34012;
i__33993 = G__34013;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__34014 = cljs.core.seq(styles);
var chunk__34015 = null;
var count__34016 = (0);
var i__34017 = (0);
while(true){
if((i__34017 < count__34016)){
var vec__34018 = chunk__34015.cljs$core$IIndexed$_nth$arity$2(null,i__34017);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34018,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34018,(1),null);
var G__34021_34032 = dom;
var G__34022_34033 = cljs.core.name(k);
var G__34023_34034 = (((v == null))?"":v);
goog.style.setStyle(G__34021_34032,G__34022_34033,G__34023_34034);


var G__34035 = seq__34014;
var G__34036 = chunk__34015;
var G__34037 = count__34016;
var G__34038 = (i__34017 + (1));
seq__34014 = G__34035;
chunk__34015 = G__34036;
count__34016 = G__34037;
i__34017 = G__34038;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__34014);
if(temp__5457__auto__){
var seq__34014__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34014__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__34014__$1);
var G__34039 = cljs.core.chunk_rest(seq__34014__$1);
var G__34040 = c__4351__auto__;
var G__34041 = cljs.core.count(c__4351__auto__);
var G__34042 = (0);
seq__34014 = G__34039;
chunk__34015 = G__34040;
count__34016 = G__34041;
i__34017 = G__34042;
continue;
} else {
var vec__34024 = cljs.core.first(seq__34014__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34024,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34024,(1),null);
var G__34027_34044 = dom;
var G__34028_34045 = cljs.core.name(k);
var G__34029_34046 = (((v == null))?"":v);
goog.style.setStyle(G__34027_34044,G__34028_34045,G__34029_34046);


var G__34047 = cljs.core.next(seq__34014__$1);
var G__34048 = null;
var G__34049 = (0);
var G__34050 = (0);
seq__34014 = G__34047;
chunk__34015 = G__34048;
count__34016 = G__34049;
i__34017 = G__34050;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__34051_34052 = key;
var G__34051_34053__$1 = (((G__34051_34052 instanceof cljs.core.Keyword))?G__34051_34052.fqn:null);
switch (G__34051_34053__$1) {
case "id":
el.id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "class":
el.className = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_34056 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__3949__auto__ = goog.string.startsWith(ks_34056,"data-");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return goog.string.startsWith(ks_34056,"aria-");
}
})())){
el.setAttribute(ks_34056,value);
} else {
(el[ks_34056] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
var G__34057 = shadow.dom.dom_node(el);
var G__34058 = cls;
return goog.dom.classlist.contains(G__34057,G__34058);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec__$1)].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__34065){
var map__34066 = p__34065;
var map__34066__$1 = ((((!((map__34066 == null)))?(((((map__34066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34066.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34066):map__34066);
var props = map__34066__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34066__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__34068 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34068,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34068,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34068,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__34072 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__34072,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__34072;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__34085 = arguments.length;
switch (G__34085) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__34089){
var vec__34090 = p__34089;
var seq__34091 = cljs.core.seq(vec__34090);
var first__34092 = cljs.core.first(seq__34091);
var seq__34091__$1 = cljs.core.next(seq__34091);
var nn = first__34092;
var first__34092__$1 = cljs.core.first(seq__34091__$1);
var seq__34091__$2 = cljs.core.next(seq__34091__$1);
var np = first__34092__$1;
var nc = seq__34091__$2;
var node = vec__34090;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34096 = nn;
var G__34097 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34096,G__34097) : create_fn.call(null,G__34096,G__34097));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34098 = nn;
var G__34099 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34098,G__34099) : create_fn.call(null,G__34098,G__34099));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__34115 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34115,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34115,(1),null);
var seq__34119_34135 = cljs.core.seq(node_children);
var chunk__34120_34136 = null;
var count__34121_34137 = (0);
var i__34122_34138 = (0);
while(true){
if((i__34122_34138 < count__34121_34137)){
var child_struct_34139 = chunk__34120_34136.cljs$core$IIndexed$_nth$arity$2(null,i__34122_34138);
var children_34140 = shadow.dom.dom_node(child_struct_34139);
if(cljs.core.seq_QMARK_(children_34140)){
var seq__34123_34141 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34140));
var chunk__34125_34142 = null;
var count__34126_34143 = (0);
var i__34127_34144 = (0);
while(true){
if((i__34127_34144 < count__34126_34143)){
var child_34145 = chunk__34125_34142.cljs$core$IIndexed$_nth$arity$2(null,i__34127_34144);
if(cljs.core.truth_(child_34145)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34145);


var G__34146 = seq__34123_34141;
var G__34147 = chunk__34125_34142;
var G__34148 = count__34126_34143;
var G__34149 = (i__34127_34144 + (1));
seq__34123_34141 = G__34146;
chunk__34125_34142 = G__34147;
count__34126_34143 = G__34148;
i__34127_34144 = G__34149;
continue;
} else {
var G__34150 = seq__34123_34141;
var G__34151 = chunk__34125_34142;
var G__34152 = count__34126_34143;
var G__34153 = (i__34127_34144 + (1));
seq__34123_34141 = G__34150;
chunk__34125_34142 = G__34151;
count__34126_34143 = G__34152;
i__34127_34144 = G__34153;
continue;
}
} else {
var temp__5457__auto___34154 = cljs.core.seq(seq__34123_34141);
if(temp__5457__auto___34154){
var seq__34123_34155__$1 = temp__5457__auto___34154;
if(cljs.core.chunked_seq_QMARK_(seq__34123_34155__$1)){
var c__4351__auto___34156 = cljs.core.chunk_first(seq__34123_34155__$1);
var G__34157 = cljs.core.chunk_rest(seq__34123_34155__$1);
var G__34158 = c__4351__auto___34156;
var G__34159 = cljs.core.count(c__4351__auto___34156);
var G__34160 = (0);
seq__34123_34141 = G__34157;
chunk__34125_34142 = G__34158;
count__34126_34143 = G__34159;
i__34127_34144 = G__34160;
continue;
} else {
var child_34161 = cljs.core.first(seq__34123_34155__$1);
if(cljs.core.truth_(child_34161)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34161);


var G__34162 = cljs.core.next(seq__34123_34155__$1);
var G__34163 = null;
var G__34164 = (0);
var G__34165 = (0);
seq__34123_34141 = G__34162;
chunk__34125_34142 = G__34163;
count__34126_34143 = G__34164;
i__34127_34144 = G__34165;
continue;
} else {
var G__34166 = cljs.core.next(seq__34123_34155__$1);
var G__34167 = null;
var G__34168 = (0);
var G__34169 = (0);
seq__34123_34141 = G__34166;
chunk__34125_34142 = G__34167;
count__34126_34143 = G__34168;
i__34127_34144 = G__34169;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34140);
}


var G__34170 = seq__34119_34135;
var G__34171 = chunk__34120_34136;
var G__34172 = count__34121_34137;
var G__34173 = (i__34122_34138 + (1));
seq__34119_34135 = G__34170;
chunk__34120_34136 = G__34171;
count__34121_34137 = G__34172;
i__34122_34138 = G__34173;
continue;
} else {
var temp__5457__auto___34174 = cljs.core.seq(seq__34119_34135);
if(temp__5457__auto___34174){
var seq__34119_34175__$1 = temp__5457__auto___34174;
if(cljs.core.chunked_seq_QMARK_(seq__34119_34175__$1)){
var c__4351__auto___34176 = cljs.core.chunk_first(seq__34119_34175__$1);
var G__34177 = cljs.core.chunk_rest(seq__34119_34175__$1);
var G__34178 = c__4351__auto___34176;
var G__34179 = cljs.core.count(c__4351__auto___34176);
var G__34180 = (0);
seq__34119_34135 = G__34177;
chunk__34120_34136 = G__34178;
count__34121_34137 = G__34179;
i__34122_34138 = G__34180;
continue;
} else {
var child_struct_34181 = cljs.core.first(seq__34119_34175__$1);
var children_34182 = shadow.dom.dom_node(child_struct_34181);
if(cljs.core.seq_QMARK_(children_34182)){
var seq__34129_34183 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34182));
var chunk__34131_34184 = null;
var count__34132_34186 = (0);
var i__34133_34187 = (0);
while(true){
if((i__34133_34187 < count__34132_34186)){
var child_34190 = chunk__34131_34184.cljs$core$IIndexed$_nth$arity$2(null,i__34133_34187);
if(cljs.core.truth_(child_34190)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34190);


var G__34192 = seq__34129_34183;
var G__34193 = chunk__34131_34184;
var G__34194 = count__34132_34186;
var G__34195 = (i__34133_34187 + (1));
seq__34129_34183 = G__34192;
chunk__34131_34184 = G__34193;
count__34132_34186 = G__34194;
i__34133_34187 = G__34195;
continue;
} else {
var G__34197 = seq__34129_34183;
var G__34198 = chunk__34131_34184;
var G__34199 = count__34132_34186;
var G__34200 = (i__34133_34187 + (1));
seq__34129_34183 = G__34197;
chunk__34131_34184 = G__34198;
count__34132_34186 = G__34199;
i__34133_34187 = G__34200;
continue;
}
} else {
var temp__5457__auto___34201__$1 = cljs.core.seq(seq__34129_34183);
if(temp__5457__auto___34201__$1){
var seq__34129_34202__$1 = temp__5457__auto___34201__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34129_34202__$1)){
var c__4351__auto___34203 = cljs.core.chunk_first(seq__34129_34202__$1);
var G__34204 = cljs.core.chunk_rest(seq__34129_34202__$1);
var G__34205 = c__4351__auto___34203;
var G__34206 = cljs.core.count(c__4351__auto___34203);
var G__34207 = (0);
seq__34129_34183 = G__34204;
chunk__34131_34184 = G__34205;
count__34132_34186 = G__34206;
i__34133_34187 = G__34207;
continue;
} else {
var child_34208 = cljs.core.first(seq__34129_34202__$1);
if(cljs.core.truth_(child_34208)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34208);


var G__34209 = cljs.core.next(seq__34129_34202__$1);
var G__34210 = null;
var G__34211 = (0);
var G__34212 = (0);
seq__34129_34183 = G__34209;
chunk__34131_34184 = G__34210;
count__34132_34186 = G__34211;
i__34133_34187 = G__34212;
continue;
} else {
var G__34213 = cljs.core.next(seq__34129_34202__$1);
var G__34214 = null;
var G__34215 = (0);
var G__34216 = (0);
seq__34129_34183 = G__34213;
chunk__34131_34184 = G__34214;
count__34132_34186 = G__34215;
i__34133_34187 = G__34216;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34182);
}


var G__34219 = cljs.core.next(seq__34119_34175__$1);
var G__34220 = null;
var G__34221 = (0);
var G__34222 = (0);
seq__34119_34135 = G__34219;
chunk__34120_34136 = G__34220;
count__34121_34137 = G__34221;
i__34122_34138 = G__34222;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
var G__34230 = shadow.dom.dom_node(node);
return goog.dom.removeChildren(G__34230);
});
shadow.dom.remove = (function shadow$dom$remove(node){
if(((!((node == null)))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__34232 = cljs.core.seq(node);
var chunk__34233 = null;
var count__34234 = (0);
var i__34235 = (0);
while(true){
if((i__34235 < count__34234)){
var n = chunk__34233.cljs$core$IIndexed$_nth$arity$2(null,i__34235);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34237 = seq__34232;
var G__34238 = chunk__34233;
var G__34239 = count__34234;
var G__34240 = (i__34235 + (1));
seq__34232 = G__34237;
chunk__34233 = G__34238;
count__34234 = G__34239;
i__34235 = G__34240;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__34232);
if(temp__5457__auto__){
var seq__34232__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34232__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__34232__$1);
var G__34241 = cljs.core.chunk_rest(seq__34232__$1);
var G__34242 = c__4351__auto__;
var G__34243 = cljs.core.count(c__4351__auto__);
var G__34244 = (0);
seq__34232 = G__34241;
chunk__34233 = G__34242;
count__34234 = G__34243;
i__34235 = G__34244;
continue;
} else {
var n = cljs.core.first(seq__34232__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34245 = cljs.core.next(seq__34232__$1);
var G__34246 = null;
var G__34247 = (0);
var G__34248 = (0);
seq__34232 = G__34245;
chunk__34233 = G__34246;
count__34234 = G__34247;
i__34235 = G__34248;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
var G__34251 = shadow.dom.dom_node(new$);
var G__34252 = shadow.dom.dom_node(old);
return goog.dom.replaceNode(G__34251,G__34252);
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__34256 = arguments.length;
switch (G__34256) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node(el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__34261 = arguments.length;
switch (G__34261) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node(el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__34267 = arguments.length;
switch (G__34267) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__3949__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node(node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4534__auto__ = [];
var len__4531__auto___34275 = arguments.length;
var i__4532__auto___34276 = (0);
while(true){
if((i__4532__auto___34276 < len__4531__auto___34275)){
args__4534__auto__.push((arguments[i__4532__auto___34276]));

var G__34277 = (i__4532__auto___34276 + (1));
i__4532__auto___34276 = G__34277;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__34271_34278 = cljs.core.seq(nodes);
var chunk__34272_34279 = null;
var count__34273_34280 = (0);
var i__34274_34281 = (0);
while(true){
if((i__34274_34281 < count__34273_34280)){
var node_34282 = chunk__34272_34279.cljs$core$IIndexed$_nth$arity$2(null,i__34274_34281);
fragment.appendChild(shadow.dom._to_dom(node_34282));


var G__34283 = seq__34271_34278;
var G__34284 = chunk__34272_34279;
var G__34285 = count__34273_34280;
var G__34286 = (i__34274_34281 + (1));
seq__34271_34278 = G__34283;
chunk__34272_34279 = G__34284;
count__34273_34280 = G__34285;
i__34274_34281 = G__34286;
continue;
} else {
var temp__5457__auto___34287 = cljs.core.seq(seq__34271_34278);
if(temp__5457__auto___34287){
var seq__34271_34288__$1 = temp__5457__auto___34287;
if(cljs.core.chunked_seq_QMARK_(seq__34271_34288__$1)){
var c__4351__auto___34289 = cljs.core.chunk_first(seq__34271_34288__$1);
var G__34290 = cljs.core.chunk_rest(seq__34271_34288__$1);
var G__34291 = c__4351__auto___34289;
var G__34292 = cljs.core.count(c__4351__auto___34289);
var G__34293 = (0);
seq__34271_34278 = G__34290;
chunk__34272_34279 = G__34291;
count__34273_34280 = G__34292;
i__34274_34281 = G__34293;
continue;
} else {
var node_34294 = cljs.core.first(seq__34271_34288__$1);
fragment.appendChild(shadow.dom._to_dom(node_34294));


var G__34295 = cljs.core.next(seq__34271_34288__$1);
var G__34296 = null;
var G__34297 = (0);
var G__34298 = (0);
seq__34271_34278 = G__34295;
chunk__34272_34279 = G__34296;
count__34273_34280 = G__34297;
i__34274_34281 = G__34298;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq34270){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34270));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__34299_34313 = cljs.core.seq(scripts);
var chunk__34300_34314 = null;
var count__34301_34315 = (0);
var i__34302_34316 = (0);
while(true){
if((i__34302_34316 < count__34301_34315)){
var vec__34303_34317 = chunk__34300_34314.cljs$core$IIndexed$_nth$arity$2(null,i__34302_34316);
var script_tag_34318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34303_34317,(0),null);
var script_body_34319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34303_34317,(1),null);
eval(script_body_34319);


var G__34320 = seq__34299_34313;
var G__34321 = chunk__34300_34314;
var G__34322 = count__34301_34315;
var G__34323 = (i__34302_34316 + (1));
seq__34299_34313 = G__34320;
chunk__34300_34314 = G__34321;
count__34301_34315 = G__34322;
i__34302_34316 = G__34323;
continue;
} else {
var temp__5457__auto___34324 = cljs.core.seq(seq__34299_34313);
if(temp__5457__auto___34324){
var seq__34299_34325__$1 = temp__5457__auto___34324;
if(cljs.core.chunked_seq_QMARK_(seq__34299_34325__$1)){
var c__4351__auto___34326 = cljs.core.chunk_first(seq__34299_34325__$1);
var G__34327 = cljs.core.chunk_rest(seq__34299_34325__$1);
var G__34328 = c__4351__auto___34326;
var G__34329 = cljs.core.count(c__4351__auto___34326);
var G__34330 = (0);
seq__34299_34313 = G__34327;
chunk__34300_34314 = G__34328;
count__34301_34315 = G__34329;
i__34302_34316 = G__34330;
continue;
} else {
var vec__34306_34331 = cljs.core.first(seq__34299_34325__$1);
var script_tag_34332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34306_34331,(0),null);
var script_body_34333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34306_34331,(1),null);
eval(script_body_34333);


var G__34334 = cljs.core.next(seq__34299_34325__$1);
var G__34335 = null;
var G__34336 = (0);
var G__34337 = (0);
seq__34299_34313 = G__34334;
chunk__34300_34314 = G__34335;
count__34301_34315 = G__34336;
i__34302_34316 = G__34337;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (scripts){
return (function (s__$1,p__34309){
var vec__34310 = p__34309;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34310,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34310,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
var G__34338 = shadow.dom.dom_node(el);
var G__34339 = cls;
return goog.dom.getAncestorByClass(G__34338,G__34339);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__34341 = arguments.length;
switch (G__34341) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
var G__34342 = shadow.dom.dom_node(el);
var G__34343 = cljs.core.name(tag);
return goog.dom.getAncestorByTagNameAndClass(G__34342,G__34343);
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
var G__34344 = shadow.dom.dom_node(el);
var G__34345 = cljs.core.name(tag);
var G__34346 = cljs.core.name(cls);
return goog.dom.getAncestorByTagNameAndClass(G__34344,G__34345,G__34346);
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
var G__34348 = shadow.dom.dom_node(dom);
return goog.dom.forms.getValue(G__34348);
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
var G__34349 = shadow.dom.dom_node(dom);
var G__34350 = value;
return goog.dom.forms.setValue(G__34349,G__34350);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__34351 = cljs.core.seq(style_keys);
var chunk__34352 = null;
var count__34353 = (0);
var i__34354 = (0);
while(true){
if((i__34354 < count__34353)){
var it = chunk__34352.cljs$core$IIndexed$_nth$arity$2(null,i__34354);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__34355 = seq__34351;
var G__34356 = chunk__34352;
var G__34357 = count__34353;
var G__34358 = (i__34354 + (1));
seq__34351 = G__34355;
chunk__34352 = G__34356;
count__34353 = G__34357;
i__34354 = G__34358;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__34351);
if(temp__5457__auto__){
var seq__34351__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34351__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__34351__$1);
var G__34359 = cljs.core.chunk_rest(seq__34351__$1);
var G__34360 = c__4351__auto__;
var G__34361 = cljs.core.count(c__4351__auto__);
var G__34362 = (0);
seq__34351 = G__34359;
chunk__34352 = G__34360;
count__34353 = G__34361;
i__34354 = G__34362;
continue;
} else {
var it = cljs.core.first(seq__34351__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__34363 = cljs.core.next(seq__34351__$1);
var G__34364 = null;
var G__34365 = (0);
var G__34366 = (0);
seq__34351 = G__34363;
chunk__34352 = G__34364;
count__34353 = G__34365;
i__34354 = G__34366;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__4203__auto____$1,k__4204__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k34368,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__34372 = k34368;
var G__34372__$1 = (((G__34372 instanceof cljs.core.Keyword))?G__34372.fqn:null);
switch (G__34372__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34368,else__4206__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34367){
var self__ = this;
var G__34367__$1 = this;
return (new cljs.core.RecordIter((0),G__34367__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__34373 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__34373(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34369,other34370){
var self__ = this;
var this34369__$1 = this;
return ((!((other34370 == null))) && ((this34369__$1.constructor === other34370.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34369__$1.x,other34370.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34369__$1.y,other34370.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34369__$1.__extmap,other34370.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__34367){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__34374 = cljs.core.keyword_identical_QMARK_;
var expr__34375 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__34377 = new cljs.core.Keyword(null,"x","x",2099068185);
var G__34378 = expr__34375;
return (pred__34374.cljs$core$IFn$_invoke$arity$2 ? pred__34374.cljs$core$IFn$_invoke$arity$2(G__34377,G__34378) : pred__34374.call(null,G__34377,G__34378));
})())){
return (new shadow.dom.Coordinate(G__34367,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34379 = new cljs.core.Keyword(null,"y","y",-1757859776);
var G__34380 = expr__34375;
return (pred__34374.cljs$core$IFn$_invoke$arity$2 ? pred__34374.cljs$core$IFn$_invoke$arity$2(G__34379,G__34380) : pred__34374.call(null,G__34379,G__34380));
})())){
return (new shadow.dom.Coordinate(self__.x,G__34367,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__34367),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__34367){
var self__ = this;
var this__4202__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__34367,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return cljs.core._assoc(this__4208__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__34371){
var extmap__4236__auto__ = (function (){var G__34381 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34371,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__34371)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34381);
} else {
return G__34381;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__34371),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__34371),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = (function (){var G__34383 = shadow.dom.dom_node(el);
return goog.style.getPosition(G__34383);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = (function (){var G__34384 = shadow.dom.dom_node(el);
return goog.style.getClientPosition(G__34384);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = (function (){var G__34385 = shadow.dom.dom_node(el);
return goog.style.getPageOffset(G__34385);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__4203__auto____$1,k__4204__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k34387,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__34391 = k34387;
var G__34391__$1 = (((G__34391 instanceof cljs.core.Keyword))?G__34391.fqn:null);
switch (G__34391__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34387,else__4206__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#shadow.dom.Size{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34386){
var self__ = this;
var G__34386__$1 = this;
return (new cljs.core.RecordIter((0),G__34386__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__34392 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__34392(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34388,other34389){
var self__ = this;
var this34388__$1 = this;
return ((!((other34389 == null))) && ((this34388__$1.constructor === other34389.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34388__$1.w,other34389.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34388__$1.h,other34389.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34388__$1.__extmap,other34389.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__34386){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__34393 = cljs.core.keyword_identical_QMARK_;
var expr__34394 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__34396 = new cljs.core.Keyword(null,"w","w",354169001);
var G__34397 = expr__34394;
return (pred__34393.cljs$core$IFn$_invoke$arity$2 ? pred__34393.cljs$core$IFn$_invoke$arity$2(G__34396,G__34397) : pred__34393.call(null,G__34396,G__34397));
})())){
return (new shadow.dom.Size(G__34386,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34398 = new cljs.core.Keyword(null,"h","h",1109658740);
var G__34399 = expr__34394;
return (pred__34393.cljs$core$IFn$_invoke$arity$2 ? pred__34393.cljs$core$IFn$_invoke$arity$2(G__34398,G__34399) : pred__34393.call(null,G__34398,G__34399));
})())){
return (new shadow.dom.Size(self__.w,G__34386,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__34386),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__34386){
var self__ = this;
var this__4202__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__34386,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return cljs.core._assoc(this__4208__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__34390){
var extmap__4236__auto__ = (function (){var G__34400 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34390,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__34390)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34400);
} else {
return G__34400;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__34390),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__34390),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj((function (){var G__34402 = shadow.dom.dom_node(el);
return goog.style.getSize(G__34402);
})());
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(shadow.dom.get_size(el));
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4405__auto__ = opts;
var l__4406__auto__ = a__4405__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4406__auto__)){
var G__34403 = (i + (1));
var G__34404 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__34403;
ret = G__34404;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__34405){
var vec__34406 = p__34405;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34406,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34406,(1),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(k)),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent([cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__34410 = arguments.length;
switch (G__34410) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__34412_34414 = new_node;
var G__34413_34415 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingAfter(G__34412_34414,G__34413_34415);

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__34416_34418 = new_node;
var G__34417_34419 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingBefore(G__34416_34418,G__34417_34419);

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5455__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5455__auto__)){
var child = temp__5455__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__34420 = ps;
var G__34421 = (i + (1));
el__$1 = G__34420;
i = G__34421;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
var G__34422 = shadow.dom.dom_node(el);
return goog.dom.getParentElement(G__34422);
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
var G__34423 = shadow.dom.dom_node(el);
return goog.dom.getNextElementSibling(G__34423);
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
var G__34424 = shadow.dom.dom_node(el);
return goog.dom.getPreviousElementSibling(G__34424);
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__34425 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34425,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34425,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34425,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__34428_34438 = cljs.core.seq(props);
var chunk__34429_34439 = null;
var count__34430_34440 = (0);
var i__34431_34441 = (0);
while(true){
if((i__34431_34441 < count__34430_34440)){
var vec__34432_34442 = chunk__34429_34439.cljs$core$IIndexed$_nth$arity$2(null,i__34431_34441);
var k_34443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34432_34442,(0),null);
var v_34444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34432_34442,(1),null);
el.setAttributeNS((function (){var temp__5457__auto__ = cljs.core.namespace(k_34443);
if(cljs.core.truth_(temp__5457__auto__)){
var ns = temp__5457__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_34443),v_34444);


var G__34445 = seq__34428_34438;
var G__34446 = chunk__34429_34439;
var G__34447 = count__34430_34440;
var G__34448 = (i__34431_34441 + (1));
seq__34428_34438 = G__34445;
chunk__34429_34439 = G__34446;
count__34430_34440 = G__34447;
i__34431_34441 = G__34448;
continue;
} else {
var temp__5457__auto___34449 = cljs.core.seq(seq__34428_34438);
if(temp__5457__auto___34449){
var seq__34428_34450__$1 = temp__5457__auto___34449;
if(cljs.core.chunked_seq_QMARK_(seq__34428_34450__$1)){
var c__4351__auto___34451 = cljs.core.chunk_first(seq__34428_34450__$1);
var G__34452 = cljs.core.chunk_rest(seq__34428_34450__$1);
var G__34453 = c__4351__auto___34451;
var G__34454 = cljs.core.count(c__4351__auto___34451);
var G__34455 = (0);
seq__34428_34438 = G__34452;
chunk__34429_34439 = G__34453;
count__34430_34440 = G__34454;
i__34431_34441 = G__34455;
continue;
} else {
var vec__34435_34456 = cljs.core.first(seq__34428_34450__$1);
var k_34457 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34435_34456,(0),null);
var v_34458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34435_34456,(1),null);
el.setAttributeNS((function (){var temp__5457__auto____$1 = cljs.core.namespace(k_34457);
if(cljs.core.truth_(temp__5457__auto____$1)){
var ns = temp__5457__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_34457),v_34458);


var G__34459 = cljs.core.next(seq__34428_34450__$1);
var G__34460 = null;
var G__34461 = (0);
var G__34462 = (0);
seq__34428_34438 = G__34459;
chunk__34429_34439 = G__34460;
count__34430_34440 = G__34461;
i__34431_34441 = G__34462;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__34464 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34464,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34464,(1),null);
var seq__34467_34485 = cljs.core.seq(node_children);
var chunk__34469_34486 = null;
var count__34470_34487 = (0);
var i__34471_34488 = (0);
while(true){
if((i__34471_34488 < count__34470_34487)){
var child_struct_34489 = chunk__34469_34486.cljs$core$IIndexed$_nth$arity$2(null,i__34471_34488);
if(!((child_struct_34489 == null))){
if(typeof child_struct_34489 === 'string'){
var text_34490 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_34490),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_34489)].join(''));
} else {
var children_34491 = shadow.dom.svg_node(child_struct_34489);
if(cljs.core.seq_QMARK_(children_34491)){
var seq__34473_34492 = cljs.core.seq(children_34491);
var chunk__34475_34493 = null;
var count__34476_34494 = (0);
var i__34477_34495 = (0);
while(true){
if((i__34477_34495 < count__34476_34494)){
var child_34496 = chunk__34475_34493.cljs$core$IIndexed$_nth$arity$2(null,i__34477_34495);
if(cljs.core.truth_(child_34496)){
node.appendChild(child_34496);


var G__34497 = seq__34473_34492;
var G__34498 = chunk__34475_34493;
var G__34499 = count__34476_34494;
var G__34500 = (i__34477_34495 + (1));
seq__34473_34492 = G__34497;
chunk__34475_34493 = G__34498;
count__34476_34494 = G__34499;
i__34477_34495 = G__34500;
continue;
} else {
var G__34501 = seq__34473_34492;
var G__34502 = chunk__34475_34493;
var G__34503 = count__34476_34494;
var G__34504 = (i__34477_34495 + (1));
seq__34473_34492 = G__34501;
chunk__34475_34493 = G__34502;
count__34476_34494 = G__34503;
i__34477_34495 = G__34504;
continue;
}
} else {
var temp__5457__auto___34505 = cljs.core.seq(seq__34473_34492);
if(temp__5457__auto___34505){
var seq__34473_34506__$1 = temp__5457__auto___34505;
if(cljs.core.chunked_seq_QMARK_(seq__34473_34506__$1)){
var c__4351__auto___34507 = cljs.core.chunk_first(seq__34473_34506__$1);
var G__34508 = cljs.core.chunk_rest(seq__34473_34506__$1);
var G__34509 = c__4351__auto___34507;
var G__34510 = cljs.core.count(c__4351__auto___34507);
var G__34511 = (0);
seq__34473_34492 = G__34508;
chunk__34475_34493 = G__34509;
count__34476_34494 = G__34510;
i__34477_34495 = G__34511;
continue;
} else {
var child_34512 = cljs.core.first(seq__34473_34506__$1);
if(cljs.core.truth_(child_34512)){
node.appendChild(child_34512);


var G__34513 = cljs.core.next(seq__34473_34506__$1);
var G__34514 = null;
var G__34515 = (0);
var G__34516 = (0);
seq__34473_34492 = G__34513;
chunk__34475_34493 = G__34514;
count__34476_34494 = G__34515;
i__34477_34495 = G__34516;
continue;
} else {
var G__34517 = cljs.core.next(seq__34473_34506__$1);
var G__34518 = null;
var G__34519 = (0);
var G__34520 = (0);
seq__34473_34492 = G__34517;
chunk__34475_34493 = G__34518;
count__34476_34494 = G__34519;
i__34477_34495 = G__34520;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_34491);
}
}


var G__34521 = seq__34467_34485;
var G__34522 = chunk__34469_34486;
var G__34523 = count__34470_34487;
var G__34524 = (i__34471_34488 + (1));
seq__34467_34485 = G__34521;
chunk__34469_34486 = G__34522;
count__34470_34487 = G__34523;
i__34471_34488 = G__34524;
continue;
} else {
var G__34525 = seq__34467_34485;
var G__34526 = chunk__34469_34486;
var G__34527 = count__34470_34487;
var G__34528 = (i__34471_34488 + (1));
seq__34467_34485 = G__34525;
chunk__34469_34486 = G__34526;
count__34470_34487 = G__34527;
i__34471_34488 = G__34528;
continue;
}
} else {
var temp__5457__auto___34529 = cljs.core.seq(seq__34467_34485);
if(temp__5457__auto___34529){
var seq__34467_34530__$1 = temp__5457__auto___34529;
if(cljs.core.chunked_seq_QMARK_(seq__34467_34530__$1)){
var c__4351__auto___34531 = cljs.core.chunk_first(seq__34467_34530__$1);
var G__34532 = cljs.core.chunk_rest(seq__34467_34530__$1);
var G__34533 = c__4351__auto___34531;
var G__34534 = cljs.core.count(c__4351__auto___34531);
var G__34535 = (0);
seq__34467_34485 = G__34532;
chunk__34469_34486 = G__34533;
count__34470_34487 = G__34534;
i__34471_34488 = G__34535;
continue;
} else {
var child_struct_34536 = cljs.core.first(seq__34467_34530__$1);
if(!((child_struct_34536 == null))){
if(typeof child_struct_34536 === 'string'){
var text_34537 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_34537),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_34536)].join(''));
} else {
var children_34538 = shadow.dom.svg_node(child_struct_34536);
if(cljs.core.seq_QMARK_(children_34538)){
var seq__34479_34539 = cljs.core.seq(children_34538);
var chunk__34481_34540 = null;
var count__34482_34541 = (0);
var i__34483_34542 = (0);
while(true){
if((i__34483_34542 < count__34482_34541)){
var child_34543 = chunk__34481_34540.cljs$core$IIndexed$_nth$arity$2(null,i__34483_34542);
if(cljs.core.truth_(child_34543)){
node.appendChild(child_34543);


var G__34544 = seq__34479_34539;
var G__34545 = chunk__34481_34540;
var G__34546 = count__34482_34541;
var G__34547 = (i__34483_34542 + (1));
seq__34479_34539 = G__34544;
chunk__34481_34540 = G__34545;
count__34482_34541 = G__34546;
i__34483_34542 = G__34547;
continue;
} else {
var G__34548 = seq__34479_34539;
var G__34549 = chunk__34481_34540;
var G__34550 = count__34482_34541;
var G__34551 = (i__34483_34542 + (1));
seq__34479_34539 = G__34548;
chunk__34481_34540 = G__34549;
count__34482_34541 = G__34550;
i__34483_34542 = G__34551;
continue;
}
} else {
var temp__5457__auto___34552__$1 = cljs.core.seq(seq__34479_34539);
if(temp__5457__auto___34552__$1){
var seq__34479_34553__$1 = temp__5457__auto___34552__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34479_34553__$1)){
var c__4351__auto___34554 = cljs.core.chunk_first(seq__34479_34553__$1);
var G__34555 = cljs.core.chunk_rest(seq__34479_34553__$1);
var G__34556 = c__4351__auto___34554;
var G__34557 = cljs.core.count(c__4351__auto___34554);
var G__34558 = (0);
seq__34479_34539 = G__34555;
chunk__34481_34540 = G__34556;
count__34482_34541 = G__34557;
i__34483_34542 = G__34558;
continue;
} else {
var child_34559 = cljs.core.first(seq__34479_34553__$1);
if(cljs.core.truth_(child_34559)){
node.appendChild(child_34559);


var G__34560 = cljs.core.next(seq__34479_34553__$1);
var G__34561 = null;
var G__34562 = (0);
var G__34563 = (0);
seq__34479_34539 = G__34560;
chunk__34481_34540 = G__34561;
count__34482_34541 = G__34562;
i__34483_34542 = G__34563;
continue;
} else {
var G__34564 = cljs.core.next(seq__34479_34553__$1);
var G__34565 = null;
var G__34566 = (0);
var G__34567 = (0);
seq__34479_34539 = G__34564;
chunk__34481_34540 = G__34565;
count__34482_34541 = G__34566;
i__34483_34542 = G__34567;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_34538);
}
}


var G__34568 = cljs.core.next(seq__34467_34530__$1);
var G__34569 = null;
var G__34570 = (0);
var G__34571 = (0);
seq__34467_34485 = G__34568;
chunk__34469_34486 = G__34569;
count__34470_34487 = G__34570;
i__34471_34488 = G__34571;
continue;
} else {
var G__34572 = cljs.core.next(seq__34467_34530__$1);
var G__34573 = null;
var G__34574 = (0);
var G__34575 = (0);
seq__34467_34485 = G__34572;
chunk__34469_34486 = G__34573;
count__34470_34487 = G__34574;
i__34471_34488 = G__34575;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

var G__34576_34582 = shadow.dom._to_svg;
var G__34577_34583 = "string";
var G__34578_34584 = ((function (G__34576_34582,G__34577_34583){
return (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
});})(G__34576_34582,G__34577_34583))
;
goog.object.set(G__34576_34582,G__34577_34583,G__34578_34584);

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

var G__34579_34585 = shadow.dom._to_svg;
var G__34580_34586 = "null";
var G__34581_34587 = ((function (G__34579_34585,G__34580_34586){
return (function (_){
return null;
});})(G__34579_34585,G__34580_34586))
;
goog.object.set(G__34579_34585,G__34580_34586,G__34581_34587);
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4534__auto__ = [];
var len__4531__auto___34590 = arguments.length;
var i__4532__auto___34591 = (0);
while(true){
if((i__4532__auto___34591 < len__4531__auto___34590)){
args__4534__auto__.push((arguments[i__4532__auto___34591]));

var G__34592 = (i__4532__auto___34591 + (1));
i__4532__auto___34591 = G__34592;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq34588){
var G__34589 = cljs.core.first(seq34588);
var seq34588__$1 = cljs.core.next(seq34588);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34589,seq34588__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__34594 = arguments.length;
switch (G__34594) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});})(buf,chan))
;
var G__34595_34610 = shadow.dom.dom_node(el);
var G__34596_34611 = cljs.core.name(event);
var G__34597_34612 = event_fn;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__34595_34610,G__34596_34611,G__34597_34612) : shadow.dom.dom_listen.call(null,G__34595_34610,G__34596_34611,G__34597_34612));

if(cljs.core.truth_((function (){var and__3938__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__3938__auto__)){
return !(once_or_cleanup === true);
} else {
return and__3938__auto__;
}
})())){
var c__31383__auto___34613 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___34613,buf,chan,event_fn){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___34613,buf,chan,event_fn){
return (function (state_34602){
var state_val_34603 = (state_34602[(1)]);
if((state_val_34603 === (1))){
var state_34602__$1 = state_34602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34602__$1,(2),once_or_cleanup);
} else {
if((state_val_34603 === (2))){
var inst_34599 = (state_34602[(2)]);
var inst_34600 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_34602__$1 = (function (){var statearr_34604 = state_34602;
(statearr_34604[(7)] = inst_34599);

return statearr_34604;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34602__$1,inst_34600);
} else {
return null;
}
}
});})(c__31383__auto___34613,buf,chan,event_fn))
;
return ((function (switch__31021__auto__,c__31383__auto___34613,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__31022__auto__ = null;
var shadow$dom$state_machine__31022__auto____0 = (function (){
var statearr_34605 = [null,null,null,null,null,null,null,null];
(statearr_34605[(0)] = shadow$dom$state_machine__31022__auto__);

(statearr_34605[(1)] = (1));

return statearr_34605;
});
var shadow$dom$state_machine__31022__auto____1 = (function (state_34602){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_34602);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e34606){if((e34606 instanceof Object)){
var ex__31025__auto__ = e34606;
var statearr_34607_34614 = state_34602;
(statearr_34607_34614[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34602);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34606;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34615 = state_34602;
state_34602 = G__34615;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
shadow$dom$state_machine__31022__auto__ = function(state_34602){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__31022__auto____0.call(this);
case 1:
return shadow$dom$state_machine__31022__auto____1.call(this,state_34602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__31022__auto____0;
shadow$dom$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__31022__auto____1;
return shadow$dom$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___34613,buf,chan,event_fn))
})();
var state__31385__auto__ = (function (){var statearr_34608 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_34608[(6)] = c__31383__auto___34613);

return statearr_34608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___34613,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
